/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.input;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.mule.runtime.api.metadata.DataType;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.module.WeaveUIModuleManager;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.SelectMetadataElement;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionWizard;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionWizardDialog;
import org.mule.tooling.ui.widgets.treetable.TreeTableEditorContentProvider;

public class SelectSampleDataEditor
extends Composite {
    private TreeViewer viewer;
    private TreeViewerColumn nameColumn;
    private TreeViewerColumn metadataColumn;
    private TreeViewerColumn buttonColumn;
    private List<SelectMetadataElement> fetchedRequirements;
    private IMuleProject project;

    public SelectSampleDataEditor(Composite parent, int style) {
        super(parent, style);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(15, 15).applyTo((Composite)this);
        GridDataFactory.fillDefaults().applyTo((Control)this);
        this.createControl(this);
    }

    protected void createControl(Composite parent) {
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)parent);
        this.viewer = new TreeViewer(parent, 2818);
        this.viewer.setUseHashlookup(true);
        this.viewer.getTree().setHeaderVisible(true);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(this.viewer.getControl());
        this.addColumns();
        this.viewer.setContentProvider((IContentProvider)new TreeTableEditorContentProvider());
    }

    public void update() {
        this.viewer.setInput(this.getMetadataList());
        this.layout();
    }

    public List<SelectMetadataElement> getMetadataList() {
        return this.fetchedRequirements;
    }

    public void addColumns() {
        this.setNameColumn(new TreeViewerColumn(this.viewer, 0));
        this.getNameColumn().getColumn().setResizable(true);
        this.getNameColumn().getColumn().setText("Name");
        this.getNameColumn().getColumn().setWidth(100);
        this.getNameColumn().setLabelProvider((CellLabelProvider)new NameLabelProvider());
        this.setMetadataColumn(new TreeViewerColumn(this.viewer, 0));
        this.getMetadataColumn().getColumn().setResizable(true);
        this.getMetadataColumn().getColumn().setText("Metadata");
        this.getMetadataColumn().getColumn().setWidth(150);
        this.getMetadataColumn().setLabelProvider((CellLabelProvider)new MetadataLabelProvider());
        this.getMetadataColumn().setEditingSupport((EditingSupport)new ElementMetadataEditingSupport((ColumnViewer)this.viewer));
        this.setButtonColumn(new TreeViewerColumn(this.viewer, 0));
        this.getButtonColumn().getColumn().setResizable(false);
        this.getButtonColumn().getColumn().setText("Actions");
        this.getButtonColumn().getColumn().setWidth(60);
        this.getButtonColumn().setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            private Map<TreeItem, Button> buttons = new HashMap<TreeItem, Button>();

            public void update(ViewerCell cell) {
                TreeItem item = (TreeItem)cell.getItem();
                if (this.buttons.get(item) != null) {
                    this.buttons.get(item).dispose();
                }
                Button button = new Button((Composite)cell.getViewerRow().getControl(), 0);
                button.setText("...");
                button.addMouseListener((MouseListener)new SelectMetadataAction(SelectSampleDataEditor.this.viewer, (SelectMetadataElement)((Object)item.getData())));
                this.buttons.put(item, button);
                item.addDisposeListener((DisposeListener)new ItemDisposeListener(this.buttons, item));
                TreeEditor editor = new TreeEditor(item.getParent());
                editor.minimumWidth = 25;
                editor.minimumHeight = 14;
                editor.grabVertical = false;
                editor.grabHorizontal = false;
                editor.verticalAlignment = 0x1000000;
                editor.horizontalAlignment = 0x1000000;
                editor.setEditor((Control)button, item, cell.getColumnIndex());
                editor.layout();
            }
        });
    }

    public TreeViewerColumn getMetadataColumn() {
        return this.metadataColumn;
    }

    public void setMetadataColumn(TreeViewerColumn treeViewerColumn) {
        this.metadataColumn = treeViewerColumn;
    }

    public TreeViewerColumn getNameColumn() {
        return this.nameColumn;
    }

    public void setNameColumn(TreeViewerColumn treeViewerColumn) {
        this.nameColumn = treeViewerColumn;
    }

    public void setRequiredSampleData(List<SelectMetadataElement> fetchedRequirements) {
        this.fetchedRequirements = fetchedRequirements;
        this.update();
    }

    public void clearFocus() {
        this.getParent().setFocus();
    }

    public void setProject(IMuleProject project) {
        this.project = project;
    }

    public TreeViewerColumn getButtonColumn() {
        return this.buttonColumn;
    }

    public void setButtonColumn(TreeViewerColumn buttonColumn) {
        this.buttonColumn = buttonColumn;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public class ElementMetadataEditingSupport
    extends EditingSupport {
        public ElementMetadataEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected CellEditor getCellEditor(Object element) {
            ComboBoxViewerCellEditor cellEditor = new ComboBoxViewerCellEditor((Composite)this.getViewer().getControl(), 8);
            cellEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            cellEditor.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            cellEditor.setInput((Object)WeaveUIModuleManager.getMetadataFormats());
            return cellEditor;
        }

        protected boolean canEdit(Object element) {
            return element instanceof SelectMetadataElement && ((SelectMetadataElement)((Object)element)).isUnknown();
        }

        protected Object getValue(Object element) {
            SelectMetadataElement element2 = (SelectMetadataElement)((Object)element);
            if (element2.getDataType() != null) {
                return element2.getDataType();
            }
            return DataType.XML_STRING;
        }

        protected void setValue(Object element, Object value) {
            ((SelectMetadataElement)((Object)element)).setDataType((DataType)value);
            this.getViewer().update(element, null);
        }
    }

    public final class ItemDisposeListener
    implements DisposeListener {
        private final TreeItem item;
        private Map<TreeItem, Button> buttons;

        private ItemDisposeListener(Map<TreeItem, Button> buttons, TreeItem item) {
            this.buttons = buttons;
            this.item = item;
        }

        public void widgetDisposed(DisposeEvent e) {
            if (this.buttons.get(this.item) != null) {
                this.buttons.get(this.item).dispose();
            }
        }
    }

    public class MetadataLabelProvider
    extends ColumnLabelProvider {
        public String getText(Object element) {
            SelectMetadataElement selectMetadataElement = (SelectMetadataElement)((Object)element);
            if (StringUtils.isNotBlank((String)selectMetadataElement.getModule()) && StringUtils.isNotBlank((String)selectMetadataElement.getMetadataKey())) {
                return selectMetadataElement.getLabel();
            }
            if (!selectMetadataElement.isUnknown()) {
                return selectMetadataElement.getMetadataId();
            }
            if (selectMetadataElement.getDataType() != null) {
                return selectMetadataElement.getDataType().getMediaType().getPrimaryType();
            }
            return "Unknown";
        }
    }

    public class NameLabelProvider
    extends ColumnLabelProvider {
        public String getText(Object element) {
            SelectMetadataElement e = (SelectMetadataElement)((Object)element);
            return e.getId();
        }
    }

    public final class SelectMetadataAction
    extends MouseAdapter {
        private TreeViewer treeViewer;
        private SelectMetadataElement element;

        public SelectMetadataAction(TreeViewer treeViewer, SelectMetadataElement element) {
            this.treeViewer = treeViewer;
            this.element = element;
        }

        public void mouseUp(MouseEvent e) {
            if (this.treeViewer.isCellEditorActive()) {
                this.treeViewer.applyEditorValue();
            }
            MetadataDefinitionWizard wizard = new MetadataDefinitionWizard(SelectSampleDataEditor.this.project);
            Shell activeShell = Display.getCurrent().getActiveShell();
            MetadataDefinitionWizardDialog dialog = new MetadataDefinitionWizardDialog(activeShell, wizard);
            if (dialog.open() == 0) {
                this.element.setMetadataResult(wizard.getResult());
                this.treeViewer.refresh();
            }
        }
    }
}

