/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.input;

import javax.xml.namespace.QName;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.InputType;
import org.mule.tooling.ui.modules.core.metadata.MetadataTypeHelper;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.widgets.treetable.TreeTableElement;

public class SelectMetadataElement
extends TreeTableElement {
    private MetadataType metadata;
    private InputType type;
    private DataType dataType;
    private MetadataResult result;

    public SelectMetadataElement(String name, MetadataType model, InputType type) {
        super(new QName(name));
        this.metadata = model;
        this.type = type;
    }

    public String getId() {
        if (this.type == null) {
            return "";
        }
        if (InputType.PAYLOAD.equals((Object)this.type)) {
            return InputType.PAYLOAD.getCategory();
        }
        if (InputType.ATTRIBUTES.equals((Object)this.type)) {
            return InputType.ATTRIBUTES.getCategory();
        }
        return this.type.getCategory() + "-" + this.getName();
    }

    public InputType getType() {
        return this.type;
    }

    public MetadataType getMetadata() {
        return this.result != null ? this.result.getMetadataType() : this.metadata;
    }

    public boolean isUnknown() {
        return MetadataFactory.isUndefined((MetadataType)this.getMetadata());
    }

    public String getMetadataId() {
        return MetadataTypeHelper.getLabel((MetadataType)this.getMetadata());
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getModule() {
        return this.result != null ? this.result.getModule() : "";
    }

    public String getMetadataKey() {
        return this.result != null ? this.result.getKey() : "";
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public void setMetadata(MetadataType metadata) {
        this.metadata = metadata;
    }

    public String getLabel() {
        boolean custom = "#Custom Type#".equals(this.getModule());
        if (custom) {
            return this.getMetadataKey() + ": " + this.getMetadataId();
        }
        return this.getModule() + " / " + this.getMetadataKey();
    }

    public void setMetadataResult(MetadataResult result) {
        this.result = result;
    }

    public MetadataResult getMetadataResult() {
        return this.result;
    }
}

