/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.input;

import java.util.List;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.SelectMetadataElement;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.SelectSampleDataEditor;
import org.mule.tooling.ui.widgets.dialog.IDialogEditorPresenter;
import org.mule.tooling.ui.widgets.dialog.IEditorMessageLogger;

public class SelectDataTypeSelectorController
implements IDialogEditorPresenter<SelectSampleDataEditor> {
    private SelectSampleDataEditor editor;
    private IEditorMessageLogger logger;
    private List<SelectMetadataElement> response;
    private List<SelectMetadataElement> fetchedRequirements;
    private IMuleProject project;

    public SelectDataTypeSelectorController(List<SelectMetadataElement> fetchedRequirements, IMuleProject project) {
        this.fetchedRequirements = fetchedRequirements;
        this.project = project;
    }

    public void handle(SelectSampleDataEditor editor) {
        this.editor = editor;
        editor.setProject(this.project);
        editor.setRequiredSampleData(this.fetchedRequirements);
    }

    public void validate() {
        this.editor.clearFocus();
        this.logger.okMessage((Object)this, 0);
        for (SelectMetadataElement element : this.editor.getMetadataList()) {
            if (element.getMetadataResult() != null || !element.isUnknown() || element.getDataType() != null) continue;
            this.logger.errorMessage((Object)this, "Metadata for selected types cannot be Unknown. Click on it to change the type.", 0);
            return;
        }
    }

    public void onSave() {
        this.editor.clearFocus();
        this.setResponse(this.editor.getMetadataList());
    }

    public void setResponse(List<SelectMetadataElement> response) {
        this.response = response;
    }

    public List<SelectMetadataElement> getResponse() {
        return this.response;
    }

    public void onCancel() {
    }

    public void setMessageLogger(IEditorMessageLogger logger) {
        this.logger = logger;
    }
}

