/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.input;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.SelectDataTypeSelectorController;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.SelectMetadataElement;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.SelectSampleDataEditor;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.InputType;
import org.mule.tooling.ui.widgets.dialog.IDialogEditorPresenter;
import org.mule.tooling.ui.widgets.dialog.TitleAreaEditorDialog;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public class RequireSampleDataCalculator {
    private List<String> requiredVariables;
    private IMetaDataProvider metadataProvider;
    private IMuleProject project;

    public RequireSampleDataCalculator(List<String> requiredVariables, IMetaDataProvider inputMetadata, IMuleProject project) {
        this.requiredVariables = requiredVariables;
        this.metadataProvider = inputMetadata;
        this.project = project;
    }

    public List<SelectMetadataElement> calculateRequiredSampleData() {
        List<SelectMetadataElement> fetchedRequirements = this.fetchRequirementsMetadataList();
        if (this.areRequirementsWellDefined(fetchedRequirements)) {
            return fetchedRequirements;
        }
        SelectDataTypeSelectorController controller = new SelectDataTypeSelectorController(fetchedRequirements, this.project);
        TitleAreaEditorDialog dialog = new WidgetUtils().createTitleEditorDialog(SelectSampleDataEditor.class, (IDialogEditorPresenter)controller, "Sample data types requirements", " Metadata should be defined. Please click to select a type.");
        dialog.setSize(400, 300);
        if (dialog.open() == 0) {
            List<SelectMetadataElement> response = controller.getResponse();
            return response;
        }
        return Collections.emptyList();
    }

    private boolean areRequirementsWellDefined(List<SelectMetadataElement> fetchedRequirements) {
        for (SelectMetadataElement selectMetadataElement : fetchedRequirements) {
            if (!selectMetadataElement.isUnknown()) continue;
            return false;
        }
        return true;
    }

    private List<SelectMetadataElement> fetchRequirementsMetadataList() {
        ArrayList<SelectMetadataElement> response = new ArrayList<SelectMetadataElement>();
        MetadataEvent inputMetadata = this.metadataProvider.getMetadata();
        if (this.requiredVariables.contains("payload")) {
            response.add(new SelectMetadataElement("payload", inputMetadata.getMessage().getPayload(), InputType.PAYLOAD));
        }
        if (this.requiredVariables.contains("attributes")) {
            response.add(new SelectMetadataElement("attributes", inputMetadata.getMessage().getAttributes(), InputType.ATTRIBUTES));
        }
        for (ObjectFieldType metaDataField : inputMetadata.getVariables().getFields()) {
            String name = metaDataField.getKey().getName().getLocalPart();
            if (!this.requiredVariables.contains("vars." + name)) continue;
            response.add(new SelectMetadataElement(name, metaDataField.getValue(), InputType.VARIABLES));
        }
        return response;
    }
}

