/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.input;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.graphical.livedata.DataWeaveValueSelectorExpression;
import org.mule.tooling.dfl.ui.graphical.livedata.ILiveDataProvider;
import org.mule.tooling.dfl.ui.graphical.livedata.ITreeLiveDataProvider;
import org.mule.tooling.dfl.ui.module.IWeaveUIModule;
import org.mule.tooling.dfl.ui.module.WeaveUIModuleManager;
import org.mule.tooling.dfl.ui.utils.FlatFileSchemaUtils;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.MessageTransformerEventTypes;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.OutputLiveDataUpdatedEvent;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.AbstractWeaveValueLiveDataProvider;
import org.mule.tooling.utils.SilentRunner;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.weave.engine.ModuleOption;
import org.mule.tooling.weave.engine.WeaveEngineHelperManager;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.DataWeaveValue;
import org.mule.weave.v2.runtime.ExecuteResult;
import org.mule.weave.v2.runtime.ScriptingBindings;

public class OutputTreeLiveDataProvider
implements ITreeLiveDataProvider {
    private EventBus eventBus;
    private DataWeaveValue rootValue = null;

    public OutputTreeLiveDataProvider(EventBus eventBus) {
        this.eventBus = eventBus;
        this.eventBus.registerListener(MessageTransformerEventTypes.ON_PREVIEW_EXECUTED, this::scheduleValueUpdate);
    }

    private void scheduleValueUpdate(final String content, final String mimeType, final Map<String, Object> properties) {
        Job liveDataUpdater = new Job("Updating tree live data for output"){

            protected IStatus run(IProgressMonitor monitor) {
                DataWeaveScriptingEngine dataWeaveScriptingEngine = new DataWeaveScriptingEngine();
                IWeaveUIModule moduleByContentType = WeaveUIModuleManager.getModuleByContentType((String)mimeType);
                String previewMimeType = moduleByContentType.getPreviewResultMimeType();
                HashMap readerProperties = new HashMap();
                if (previewMimeType != "application/dw") {
                    List readerOptions = WeaveEngineHelperManager.getReaderOptions((String)mimeType);
                    for (ModuleOption moduleOption : readerOptions) {
                        String optionName = moduleOption.getName();
                        if (!properties.containsKey(optionName)) continue;
                        readerProperties.put(optionName, properties.get(optionName));
                    }
                    FlatFileSchemaUtils.fixSchemaPathIsRequired((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), readerProperties);
                }
                DataWeaveScript compile = dataWeaveScriptingEngine.compile("payload", new String[]{"payload"});
                SilentRunner.run(() -> {
                    ExecuteResult exec = compile.exec(new ScriptingBindings().addBinding("payload", (Object)content, previewMimeType, readerProperties));
                    OutputTreeLiveDataProvider.this.rootValue = exec.asDWValue();
                    OutputTreeLiveDataProvider.this.eventBus.fireEvent((IEvent)new OutputLiveDataUpdatedEvent());
                });
                return Status.OK_STATUS;
            }
        };
        liveDataUpdater.schedule();
    }

    public ILiveDataProvider getLiveDataProvider(DataWeaveValueSelectorExpression expression) {
        return new AbstractWeaveValueLiveDataProvider(expression){

            @Override
            protected DataWeaveValue getValue() {
                return OutputTreeLiveDataProvider.this.rootValue;
            }
        };
    }
}

