/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.input;

import java.util.List;
import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.enricher.MetadataEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataEventEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataOperationEnricher;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.datasense.MetadataHelper;
import org.mule.tooling.model.messageflow.ComponentId;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.dfl.contribution.editor.datasense.MetadataOperations;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.TwoWayHandler;
import org.mule.tooling.ui.dfl.contribution.editor.script.EditorContext;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.VariableMetadataDefinitionWizard;
import org.mule.tooling.ui.modules.core.metadata.MetadataHelpers;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageRowType;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionConfiguration;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionWizard;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionWizardDialog;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class NewVariableAction
extends Action {
    private EditorContext context;
    private TwoWayHandler twoWayHandler;
    private GraphicalTreeNode<?> treeNode;

    public NewVariableAction(GraphicalTreeNode<?> treeNode, EditorContext context, TwoWayHandler twoWayHandler) {
        super("New Variable");
        this.context = context;
        this.treeNode = treeNode;
        this.twoWayHandler = twoWayHandler;
    }

    public void run() {
        VariableMetadataDefinitionWizard wizard = new VariableMetadataDefinitionWizard(this.context.getProject(), "Variable");
        Shell activeShell = Display.getCurrent().getActiveShell();
        MetadataDefinitionWizardDialog dialog = new MetadataDefinitionWizardDialog(activeShell, (MetadataDefinitionWizard)wizard);
        if (dialog.open() == 0) {
            String propertyName = wizard.getVariableName();
            MetadataResult result = wizard.getResult();
            ComponentId componentId = ComponentId.from((IMessageFlowEntity)this.context.getNode());
            if (componentId.isUndefined()) {
                PropertyCollectionMap props = this.context.getNode().getProperties().toPropertyCollectionMap();
                componentId = MetadataHelpers.defineComponentIdProperty((IMessageFlowNode)this.context.getNode(), (PropertyCollectionMap)props, (ComponentId)componentId);
            }
            ITypesManager typesManager = MetadataHelper.getTypesManager((IMuleProject)this.context.getProject());
            Optional maybeEnricher = typesManager.getEnricher(componentId);
            MetadataEventEnricher inputEnricher = new MetadataEventEnricher();
            MetadataEventEnricher outputEnricher = new MetadataEventEnricher();
            MessageRowType currentRowType = (MessageRowType)MetadataHelper.getCurrentMessageRowType(this.treeNode).get();
            MessageRowType[] messageRowTypeArray = MessageRowType.values();
            int n = messageRowTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MessageRowType rowType = messageRowTypeArray[n2];
                List configurations = rowType.loadConfigFrom(maybeEnricher);
                if (rowType.equals((Object)currentRowType)) {
                    MetadataDefinitionConfiguration newMetadataDefinitionConfiguration = MetadataHelper.createConfig((MetadataResult)result, Optional.of(propertyName));
                    configurations.add(newMetadataDefinitionConfiguration);
                }
                if (!configurations.isEmpty()) {
                    rowType.processMetadataDefinitionConfig(configurations, inputEnricher, outputEnricher);
                }
                ++n2;
            }
            typesManager.enrich(new MetadataEnricher(componentId, inputEnricher, outputEnricher, new MetadataOperationEnricher()));
            typesManager.persistCustomTypes();
            MetadataOperations.reloadPropagationAndEditorMarkers(this.twoWayHandler);
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

