/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.input;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.TreeItem;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.tooling.dfl.ui.graphical.model.ITreeGraphicalMapping;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class MappingsPathFormatter {
    private static final int MAX_LENGTH = 80;

    public static Map<String, ITreeGraphicalMapping> formatOutputPaths(Collection<ITreeGraphicalMapping> mappingsFromSelection) {
        TreeMap<Path, ITreeGraphicalMapping> pathsAndMappings = new TreeMap<Path, ITreeGraphicalMapping>();
        for (ITreeGraphicalMapping mapping : mappingsFromSelection) {
            TreeItem rightTreeItem = mapping.getRightItem().getTreeItem();
            pathsAndMappings.put(Path.from(rightTreeItem), mapping);
        }
        LinkedHashMap<String, ITreeGraphicalMapping> result = new LinkedHashMap<String, ITreeGraphicalMapping>();
        for (Map.Entry pathAndMapping : pathsAndMappings.entrySet()) {
            result.put(((Path)pathAndMapping.getKey()).formatAsString(80), (ITreeGraphicalMapping)pathAndMapping.getValue());
        }
        return result;
    }

    public static class Path
    implements Comparable<Path>,
    Iterable<String> {
        private List<String> items;

        public Path(List<String> items) {
            this.items = items;
        }

        @Override
        public int compareTo(Path o) {
            int result = this.items.size() - o.items.size();
            return result == 0 ? this.toString().compareTo(o.toString()) : result;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            Iterator<String> iter = this.items.iterator();
            while (iter.hasNext()) {
                buff.append(iter.next());
                if (!iter.hasNext()) continue;
                buff.append(".");
            }
            return buff.toString();
        }

        private static Path from(TreeItem item) {
            ObjectFieldType field;
            LinkedList<String> items = new LinkedList<String>();
            while ((field = Path.fieldFrom(item)) != null) {
                items.addFirst(field.getKey().getName().getLocalPart());
                item = item.getParentItem();
            }
            return new Path(items);
        }

        private static ObjectFieldType fieldFrom(TreeItem item) {
            if (item.getData() instanceof GraphicalTreeNode && ((GraphicalTreeNode)item.getData()).getModel() instanceof ObjectFieldType) {
                return (ObjectFieldType)((GraphicalTreeNode)item.getData()).getModel();
            }
            return null;
        }

        @Override
        public Iterator<String> iterator() {
            final ListIterator<String> listIterator = this.items.listIterator(this.items.size());
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return listIterator.hasPrevious();
                }

                @Override
                public String next() {
                    return (String)listIterator.previous();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }

        public String formatAsString(int maxLength) {
            Iterator<String> iter = this.iterator();
            Object text = iter.next();
            int charsLeft = maxLength - ((String)text).length() - 3;
            while (iter.hasNext() && charsLeft > 0) {
                String current = iter.next();
                if (charsLeft - current.length() <= 0 && charsLeft > 4) {
                    text = StringUtils.abbreviate((String)current, (int)charsLeft) + (String)text;
                    charsLeft = 0;
                }
                if (charsLeft <= 0) continue;
                text = current + "." + (String)text;
            }
            return text;
        }
    }
}

