/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.input;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.dialogs.PatternFilter;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.IMuleResources;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.dfl.ui.DFLEditor;
import org.mule.tooling.dfl.ui.graphical.WeaveUIConstants;
import org.mule.tooling.dfl.ui.input.DFLStudioFilteredTree;
import org.mule.tooling.dfl.ui.module.DataWeaveValueUITree;
import org.mule.tooling.dfl.ui.module.IWeaveUIModule;
import org.mule.tooling.dfl.ui.module.PreviewFactory;
import org.mule.tooling.dfl.ui.module.WeaveUIModuleManager;
import org.mule.tooling.dfl.ui.scafflod.WeaveMetadataTypeScaffoldingService;
import org.mule.tooling.dfl.ui.utils.ImagesHelper;
import org.mule.tooling.dfl.ui.utils.ResourcesHelper;
import org.mule.tooling.metadata.sample.AttributesEventSelector;
import org.mule.tooling.metadata.sample.IMetadataEventSelector;
import org.mule.tooling.metadata.sample.MetadataSampleService;
import org.mule.tooling.metadata.sample.PayloadEventSelector;
import org.mule.tooling.metadata.sample.VariableEventSelector;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.InputTreeDragSource;
import org.mule.tooling.ui.dfl.contribution.editor.script.EditorContext;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.MessageTransformerEventTypes;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.SampleDataModifiedEvent;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.SampleDataOpenedEvent;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.InputTabContext;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.SampleDataTypeSelectorController;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.SampleDataTypeSelectorEditor;
import org.mule.tooling.ui.dfl.contribution.editor.script.output.SampleDataValidator;
import org.mule.tooling.ui.modules.core.metadata.MetadataTypeHelper;
import org.mule.tooling.ui.widgets.action.DisposableAction;
import org.mule.tooling.ui.widgets.dialog.ISimpleDialogEditorPresenter;
import org.mule.tooling.ui.widgets.dialog.SimpleEditorDialog;
import org.mule.tooling.ui.widgets.listener.IdleDocumentEventListener;
import org.mule.tooling.ui.widgets.search.LimitedLevelPatternFilter;
import org.mule.tooling.ui.widgets.toolbar.LabelControlContribution;
import org.mule.tooling.ui.widgets.tree.StudioFilteredTree;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeContentProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeLabelProvider;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.utils.ObjectHolder;
import org.mule.tooling.utils.SilentRunner;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventRegistrationHandler;
import org.mule.tooling.utils.eventbus.IEvent;

public class InputViewer
extends Composite {
    private EditorContext context;
    private StudioFilteredTree inputMetadataTree;
    private CTabFolder inputTabsFolder;
    private Map<String, InputTabContext> tabsCache = new HashMap<String, InputTabContext>();

    public InputViewer(Composite parent, EditorContext context) {
        super(parent, 0);
        this.context = context;
        this.setBackground(WeaveUIConstants.WHITE);
        this.createControls(this);
    }

    public void dispose() {
        super.dispose();
        this.tabsCache.clear();
        this.tabsCache = null;
    }

    private void createControls(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        Composite outerWrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(outerWrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)outerWrapper);
        outerWrapper.setBackground(WeaveUIConstants.WHITE);
        this.createTabWrapper(outerWrapper);
    }

    private void createTabWrapper(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        wrapper.setBackground(WeaveUIConstants.WHITE);
        GridLayoutFactory.fillDefaults().applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)wrapper);
        this.inputTabsFolder = new CTabFolder(wrapper, 1024);
        this.inputTabsFolder.setBackground(WeaveUIConstants.WHITE);
        this.inputTabsFolder.setSelectionBackground(WeaveUIConstants.WHITE);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.inputTabsFolder);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.inputTabsFolder);
        CTabItem tree = new CTabItem(this.inputTabsFolder, 0);
        tree.setText("Context");
        Composite treeWrapper = new Composite((Composite)this.inputTabsFolder, 0);
        treeWrapper.setBackground(WeaveUIConstants.WHITE);
        GridLayoutFactory.fillDefaults().applyTo(treeWrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)treeWrapper);
        Rectangle margins = Geometry.createDiffRectangle((int)10, (int)10, (int)5, (int)10);
        this.setInputMetadataTree((StudioFilteredTree)new DFLStudioFilteredTree(treeWrapper, 768, (PatternFilter)new LimitedLevelPatternFilter(8), margins));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.getInputMetadataTree());
        this.getInputMetadataTree().getViewer().getTree().setBackground(WeaveUIConstants.WHITE);
        this.getInputMetadataTree().getViewer().setUseHashlookup(true);
        this.configureTreeProviders(this.getInputMetadataTree().getViewer());
        InputTreeDragSource dragListener = new InputTreeDragSource(this.getInputMetadataTree().getViewer());
        this.getInputMetadataTree().getViewer().addDragSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)dragListener);
        tree.setControl((Control)treeWrapper);
        this.addCloseTabHandler();
        this.refresh();
    }

    private void addCloseTabHandler() {
        this.inputTabsFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), "Close Sample Data", null, "Do you want to delete your sample data", 6, new String[]{"Cancel", "Close tab and Delete file", "Close tab and Keep file"}, 2);
                int rs = dialog.open();
                if (rs > 0) {
                    CTabItem tabItem = (CTabItem)event.item;
                    String partId = tabItem.getText();
                    InputTabContext inputTabContext = InputViewer.this.tabsCache.get(partId);
                    if (inputTabContext != null) {
                        IMetadataEventSelector metadataSelector = inputTabContext.getMetadataSelector();
                        if (rs == 1) {
                            InputViewer.this.getSampleService().deleteSample(InputViewer.this.context.getNode(), metadataSelector);
                        }
                        InputViewer.this.tabsCache.remove(partId);
                        InputViewer.this.context.getEventBus().fireEvent((IEvent)new SampleDataModifiedEvent(SampleDataModifiedEvent.SampleDataModificationType.DELETED, null, metadataSelector));
                    }
                } else {
                    event.doit = false;
                }
            }
        });
    }

    private void configureTreeProviders(TreeViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new GraphicalTreeLabelProvider());
        viewer.setContentProvider((IContentProvider)new GraphicalTreeContentProvider());
    }

    public void refresh() {
        this.createInputTabs();
        this.inputTabsFolder.setSelection(0);
    }

    private void createInputTabs() {
        int index = this.inputTabsFolder.getSelectionIndex();
        this.disposeSecondaryTabs();
        this.tabsCache.clear();
        MetadataEvent metadata = this.context.getInputMetadataProvider().getMetadata();
        PayloadEventSelector payloadEventSelector = new PayloadEventSelector();
        this.openEditorIfSamplePresent((IMetadataEventSelector)payloadEventSelector, (MetadataType)payloadEventSelector.select(metadata).get());
        for (ObjectFieldType metaDataField : metadata.getVariables().getFields()) {
            String variableName = metaDataField.getKey().getName().getLocalPart();
            VariableEventSelector variableEventSelector = new VariableEventSelector(variableName);
            this.openEditorIfSamplePresent((IMetadataEventSelector)variableEventSelector, (MetadataType)variableEventSelector.select(metadata).get());
        }
        AttributesEventSelector attributesEventSelector = new AttributesEventSelector();
        this.openEditorIfSamplePresent((IMetadataEventSelector)attributesEventSelector, (MetadataType)attributesEventSelector.select(metadata).get());
        this.inputTabsFolder.update();
        if (index < this.inputTabsFolder.getItemCount()) {
            this.inputTabsFolder.setSelection(index);
        } else {
            this.inputTabsFolder.setSelection(0);
        }
    }

    private void disposeSecondaryTabs() {
        int items = this.inputTabsFolder.getItemCount() - 1;
        while (items > 0) {
            this.inputTabsFolder.getItem(items).dispose();
            --items;
        }
    }

    private void openEditorIfSamplePresent(IMetadataEventSelector selector, MetadataType type) {
        if (!this.tabsCache.containsKey(selector.getId())) {
            this.appendTabIfSampleFileIsInCache(selector, type);
        }
    }

    private void appendTabIfSampleFileIsInCache(IMetadataEventSelector selector, MetadataType type) {
        Optional sampleFile = this.getSampleService().getSampleFile(this.context.getNode(), selector);
        if (sampleFile.isPresent()) {
            this.appendTabWithSampleDataToEditor((IFile)sampleFile.get(), selector, type);
        }
    }

    private void appendTabWithSampleDataToEditor(IFile file, IMetadataEventSelector selector, MetadataType type) {
        Composite container = new Composite((Composite)this.inputTabsFolder, 0);
        container.setBackground(WeaveUIConstants.WHITE);
        GridLayoutFactory.fillDefaults().applyTo(container);
        GridDataFactory.fillDefaults().applyTo((Control)container);
        Composite toolbarContainer = new Composite(container, 8);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 5, 0).applyTo(toolbarContainer);
        GridDataFactory.fillDefaults().hint(4, 36).grab(true, false).align(4, 0x1000000).applyTo((Control)toolbarContainer);
        toolbarContainer.setBackground(WeaveUIConstants.WHITE);
        ToolBar toolbarControl = new ToolBar(toolbarContainer, 524288);
        ToolBarManager toolBar = new ToolBarManager(toolbarControl);
        GridLayoutFactory.fillDefaults().applyTo((Composite)toolbarControl);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)toolbarControl);
        Composite toolbarSeparator = new Composite(toolbarContainer, 0);
        GridDataFactory.fillDefaults().grab(true, false).hint(4, 1).applyTo((Control)toolbarSeparator);
        toolbarSeparator.setBackground(WeaveUIConstants.ALUMINUM_4);
        GridLayoutFactory.fillDefaults().applyTo(toolbarSeparator);
        IWeaveUIModule uiModule = WeaveUIModuleManager.getModuleByMetaDataModel((MetadataType)type);
        this.createSampleDataEditor(uiModule, container, toolBar, file, selector, type);
        CTabItem sampleDataTab = new CTabItem(this.inputTabsFolder, 64);
        sampleDataTab.setText(selector.getId());
        sampleDataTab.setControl((Control)container);
        this.tabsCache.put(selector.getId(), new InputTabContext(sampleDataTab, file, selector, type));
        try {
            Throwable throwable = null;
            Object var12_14 = null;
            try (InputStream contents = file.getContents();){
                byte[] content = IOUtils.toByteArray((InputStream)contents);
                this.context.getEventBus().fireEvent((IEvent)new SampleDataOpenedEvent(content, selector));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)("Error reading sample file content data for :" + selector.getId()), (Throwable)e);
        }
        toolBar.update(true);
    }

    private void createSampleDataEditor(IWeaveUIModule uiModule, Composite container, ToolBarManager toolBar, IFile file, IMetadataEventSelector selector, MetadataType type) {
        ImportSampleDataAction importAction = new ImportSampleDataAction(uiModule, selector);
        toolBar.add((IAction)importAction);
        toolBar.add((IContributionItem)new Separator());
        LabelControlContribution label = new LabelControlContribution(this.computeLabel(file), file.getFullPath().toOSString(), Optional.of(DFLEditor.TITLE_COLOR));
        toolBar.add((IContributionItem)label);
        importAction.addListener((labelString, content) -> {
            label.setText(labelString);
            toolBar.update(true);
            toolBar.getControl().layout();
        });
        if (uiModule.isBinaryDataFormat()) {
            DataWeaveValueUITree dataWeaveValueUITree = new DataWeaveValueUITree(container, 0);
            EventRegistrationHandler registerListener = this.context.getEventBus().registerUIThreadListener(MessageTransformerEventTypes.ON_INPUT_LIVE_DATA_UPDATED, (updatedSelector, value) -> {
                if (updatedSelector.getId().equals(selector.getId()) && !dataWeaveValueUITree.isDisposed()) {
                    dataWeaveValueUITree.content(value);
                }
            });
            dataWeaveValueUITree.addDisposeListener(e -> registerListener.unregister());
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)dataWeaveValueUITree);
        } else {
            SourceViewer inputViewer = PreviewFactory.buildSourceViewer((IWeaveUIModule)uiModule, (Composite)container, null, (boolean)false, null, null);
            IDocument inputDocument = PreviewFactory.buildDocument((IWeaveUIModule)uiModule);
            this.fillDocument(inputViewer, inputDocument, file);
            importAction.addListener((labelString, content) -> {
                inputDocument.set(new String((byte[])content, IMuleResources.DEFAULT_CHARSET));
                inputViewer.setDocument(inputDocument);
            });
            inputDocument.addDocumentListener((IDocumentListener)new IdleDocumentEventListener((IDocumentListener)new InputDocumentListener(this.context.getEventBus(), file, inputDocument, selector), inputViewer.getControl()));
            GridDataFactory.fillDefaults().grab(true, true).applyTo(inputViewer.getControl());
            PreviewFactory.configure((IWeaveUIModule)uiModule, (SourceViewer)inputViewer);
        }
    }

    private String computeLabel(IFile file) {
        try {
            long fileSizeInKB = EFS.getStore((URI)file.getLocationURI()).fetchInfo().getLength() / 1024L;
            return fileSizeInKB > 2048L ? file.getName() + " - Big files (> 2MB) might affect the performance" : file.getName();
        }
        catch (CoreException coreException) {
            return file.getName();
        }
    }

    private void fillDocument(SourceViewer inputViewer, IDocument inputDocument, IFile file) {
        try {
            String content = MuleResourceUtils.readContentsUsingDefaultCharset((IStorage)file);
            inputDocument.set(content);
            inputViewer.setDocument(inputDocument);
        }
        catch (IOException | CoreException e) {
            MuleCorePlugin.logError((String)"Error filling input document", (Throwable)e);
        }
    }

    public StudioFilteredTree getInputMetadataTree() {
        return this.inputMetadataTree;
    }

    public void setInputMetadataTree(StudioFilteredTree inputMetadataTree) {
        this.inputMetadataTree = inputMetadataTree;
    }

    public boolean containsSampleDataTab(String id) {
        return this.tabsCache.containsKey(id);
    }

    public void showSampleDataTab(String id) {
        this.inputTabsFolder.setSelection(this.tabsCache.get(id).getTab());
    }

    public void createSample(List<IMetadataEventSelector> list) {
        List<IMetadataEventSelector> requiredSamples = new SampleDataValidator(this.context).calculateRequiredSamples(list);
        for (IMetadataEventSelector eventSelector : requiredSamples) {
            MetadataEvent metadata;
            Optional selectedMetadata = eventSelector.select(metadata = this.context.getInputMetadataProvider().getMetadata());
            if (!selectedMetadata.isPresent()) continue;
            this.createSample((MetadataType)selectedMetadata.get(), eventSelector);
        }
    }

    public String getSampleFileName(MetadataType model) {
        IFolder sampleDataFolder = this.getSampleService().getSampleDataFolder();
        String sampleKey = MetadataTypeHelper.getId((MetadataType)model);
        String sampleDataMimeType = WeaveUIModuleManager.getModuleByMetaDataModel((MetadataType)model).getSampleDataMimeType();
        String extension = (String)WeaveUIModuleManager.getModuleByContentType((String)sampleDataMimeType).getExtensions().get(0);
        return ResourcesHelper.uniqueOSFileName((IFolder)sampleDataFolder, (String)sampleKey, (String)extension);
    }

    public void createSample(MetadataType metadataType, IMetadataEventSelector selector) {
        MetadataType adjustedModel;
        byte[] content = new byte[]{};
        Optional definedSampleIf = this.getSampleService().getDefinedSampleIf(metadataType);
        if (definedSampleIf.isPresent()) {
            content = ((String)definedSampleIf.get()).getBytes(IMuleResources.DEFAULT_CHARSET);
            adjustedModel = metadataType;
        } else if (MetadataFactory.isUndefined((MetadataType)metadataType)) {
            SampleDataTypeSelectorController controller = new SampleDataTypeSelectorController();
            SimpleEditorDialog dialog = WidgetUtils.createSimpleEditorDialog(SampleDataTypeSelectorEditor.class, (ISimpleDialogEditorPresenter)controller);
            dialog.setSize(350, 150);
            if (dialog.open() != 0) {
                return;
            }
            MetadataType userSelectedModel = new MockMetadataModelProvider().getModel(controller.getResult());
            content = this.createSample(userSelectedModel);
            adjustedModel = userSelectedModel;
        } else {
            content = this.createSample(metadataType);
            adjustedModel = metadataType;
        }
        MetadataSampleService.SampleStatus status = this.getSampleService().setSample(this.context.getNode(), selector, this.getSampleFileName(adjustedModel), content);
        SampleDataModifiedEvent.SampleDataModificationType created = status == MetadataSampleService.SampleStatus.CREATED ? SampleDataModifiedEvent.SampleDataModificationType.CREATED : SampleDataModifiedEvent.SampleDataModificationType.MODIFIED;
        this.context.getEventBus().fireEvent((IEvent)new SampleDataModifiedEvent(created, content, selector));
        this.openEditorIfSamplePresent(selector, adjustedModel);
        this.showSampleDataTab(selector.getId());
    }

    private byte[] createSample(MetadataType metadataType) {
        ObjectHolder contentHolder = new ObjectHolder();
        IRunnableWithProgress op = monitor -> {
            WeaveMetadataTypeScaffoldingService service = WeaveMetadataTypeScaffoldingService.getInstance();
            contentHolder.set((Object)service.scaffoldSampleData(this.context.getProject(), metadataType, monitor));
        };
        SilentRunner.run(() -> {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(WidgetUtils.getShell());
            progressMonitorDialog.run(true, false, op);
        });
        byte[] content = (byte[])contentHolder.get();
        return content;
    }

    private MetadataSampleService getSampleService() {
        return MetadataSampleService.getInstance((IMuleProject)this.context.getProject());
    }

    private final class ImportSampleDataAction
    extends DisposableAction {
        private IWeaveUIModule module;
        private IMetadataEventSelector selector;
        private List<BiConsumer<String, byte[]>> listeners;

        public ImportSampleDataAction(IWeaveUIModule uiModule, IMetadataEventSelector selector) {
            super("Import Sample From File.", ImagesHelper.getImageDescriptor((String)(ThemeUtils.getCurrentTheme().getDflImgFolder() + "import.png")));
            this.module = uiModule;
            this.selector = selector;
            this.listeners = new ArrayList<BiConsumer<String, byte[]>>();
            this.setId("RegenerateSampleData");
        }

        public void addListener(BiConsumer<String, byte[]> listener) {
            this.listeners.add(listener);
        }

        public void run() {
            try {
                FileDialog fileDialog = new FileDialog(WidgetUtils.getShell());
                fileDialog.setFilterExtensions(this.module.getExtensions().toArray(new String[0]));
                String osString = CoreUtils.getProjectRootFile((IMuleProject)InputViewer.this.context.getProject()).getAbsolutePath();
                fileDialog.setFilterPath(osString);
                String filePath = fileDialog.open();
                if (!StringUtils.isBlank((String)filePath)) {
                    File file = new File(filePath);
                    byte[] content = FileUtils.readFileToByteArray((File)file);
                    MetadataSampleService.SampleStatus status = MetadataSampleService.getInstance((IMuleProject)InputViewer.this.context.getProject()).setSample(InputViewer.this.context.getNode(), this.selector, file.getName(), content);
                    SampleDataModifiedEvent.SampleDataModificationType created = status == MetadataSampleService.SampleStatus.CREATED ? SampleDataModifiedEvent.SampleDataModificationType.CREATED : SampleDataModifiedEvent.SampleDataModificationType.MODIFIED;
                    InputViewer.this.context.getEventBus().fireEvent((IEvent)new SampleDataModifiedEvent(created, content, this.selector));
                    for (BiConsumer<String, byte[]> biConsumer : this.listeners) {
                        biConsumer.accept(file.getName(), content);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error importing sample data", e);
            }
        }

        public void dispose() {
            super.dispose();
        }
    }

    private static final class InputDocumentListener
    implements IDocumentListener {
        private final IDocument inputDocument;
        private IFile file;
        private EventBus bus;
        private IMetadataEventSelector selector;

        private InputDocumentListener(EventBus bus, IFile file, IDocument inputDocument, IMetadataEventSelector selector) {
            this.file = file;
            this.bus = bus;
            this.inputDocument = inputDocument;
            this.selector = selector;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            SilentRunner.run(() -> {
                if (!this.file.exists()) {
                    this.file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
                }
                this.file.setContents((InputStream)new ByteArrayInputStream(this.inputDocument.get().getBytes(this.file.getCharset())), true, true, (IProgressMonitor)new NullProgressMonitor());
                byte[] bytes = this.inputDocument.get().getBytes(IMuleResources.DEFAULT_CHARSET);
                this.bus.fireEvent((IEvent)new SampleDataModifiedEvent(SampleDataModifiedEvent.SampleDataModificationType.MODIFIED, bytes, this.selector));
            });
        }
    }

    public static class MockMetadataModelProvider {
        public MetadataType getModel(MetadataFormat metadataFormat) {
            ObjectType model;
            if (MetadataFormat.CSV.equals((Object)metadataFormat)) {
                ArrayTypeBuilder arrayBuilder = BaseTypeBuilder.create((MetadataFormat)metadataFormat).arrayType();
                ObjectTypeBuilder builder = new ObjectTypeBuilder(metadataFormat);
                builder.addField().key("name").value((TypeBuilder)BaseTypeBuilder.create((MetadataFormat)metadataFormat).stringType());
                builder.addField().key("lastName").value((TypeBuilder)BaseTypeBuilder.create((MetadataFormat)metadataFormat).stringType());
                model = arrayBuilder.of((MetadataType)builder.build()).build();
            } else if (MetadataFormat.JSON.equals((Object)metadataFormat)) {
                ObjectTypeBuilder builder = new ObjectTypeBuilder(metadataFormat);
                builder.addField().key("age").value((TypeBuilder)BaseTypeBuilder.create((MetadataFormat)metadataFormat).numberType());
                builder.addField().key("name").value((TypeBuilder)BaseTypeBuilder.create((MetadataFormat)metadataFormat).stringType());
                model = builder.build();
            } else if (MetadataFormat.XML.equals((Object)metadataFormat)) {
                ObjectTypeBuilder builder = new ObjectTypeBuilder(metadataFormat);
                builder.addField().key("name").value((TypeBuilder)BaseTypeBuilder.create((MetadataFormat)metadataFormat).stringType());
                model = builder.build();
            } else if (MetadataFormat.JAVA.equals((Object)metadataFormat)) {
                ObjectTypeBuilder builder = new ObjectTypeBuilder(metadataFormat);
                builder.addField().key("name").value((TypeBuilder)BaseTypeBuilder.create((MetadataFormat)metadataFormat).stringType());
                builder.addField().key("age").value((TypeBuilder)BaseTypeBuilder.create((MetadataFormat)metadataFormat).numberType());
                builder.addField().key("double").value((TypeBuilder)BaseTypeBuilder.create((MetadataFormat)metadataFormat).numberType());
                builder.addField().key("birthday").value((TypeBuilder)BaseTypeBuilder.create((MetadataFormat)metadataFormat).dateType());
                model = builder.build();
            } else {
                ObjectTypeBuilder builder = new ObjectTypeBuilder(metadataFormat);
                builder.addField().key("name").value((TypeBuilder)BaseTypeBuilder.create((MetadataFormat)metadataFormat).stringType());
                model = builder.build();
            }
            return model;
        }
    }
}

