/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.input;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.graphical.livedata.DataWeaveValueSelectorExpression;
import org.mule.tooling.dfl.ui.graphical.livedata.ILiveDataProvider;
import org.mule.tooling.dfl.ui.graphical.livedata.ITreeLiveDataProvider;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.dfl.ui.module.IWeaveUIModule;
import org.mule.tooling.dfl.ui.module.WeaveUIModuleManager;
import org.mule.tooling.dfl.ui.utils.DwMetadataUtils;
import org.mule.tooling.dfl.ui.utils.FlatFileSchemaUtils;
import org.mule.tooling.metadata.sample.IMetadataEventSelector;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.InputLiveDataUpdatedEvent;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.MessageTransformerEventTypes;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.SampleDataModifiedEvent;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.AbstractWeaveValueLiveDataProvider;
import org.mule.tooling.ui.modules.core.metadata.MetadataTypeHelper;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.DataWeaveValue;
import org.mule.weave.v2.runtime.ExecuteResult;
import org.mule.weave.v2.runtime.ScriptingBindings;

public class InputTreeLiveDataProviderManager {
    private EventBus eventBus;
    private Map<String, DataWeaveValue> rootValues = new HashMap<String, DataWeaveValue>();
    private IMetaDataProvider event;

    public InputTreeLiveDataProviderManager(EventBus eventBus, IMetaDataProvider metadataEvent) {
        this.eventBus = eventBus;
        this.event = metadataEvent;
        this.eventBus.registerListener(MessageTransformerEventTypes.ON_SAMPLE_DATA_MODIFED, (kind, content, selector) -> {
            if (kind == SampleDataModifiedEvent.SampleDataModificationType.DELETED) {
                DataWeaveValue remove = this.rootValues.remove(selector.getId());
                if (remove != null) {
                    eventBus.fireEvent((IEvent)new InputLiveDataUpdatedEvent(selector, remove));
                }
            } else {
                this.scheduleValueUpdate(content, selector);
            }
        });
        this.eventBus.registerListener(MessageTransformerEventTypes.ON_SAMPLE_DATA_OPENED, this::scheduleValueUpdate);
    }

    private void scheduleValueUpdate(byte[] content, IMetadataEventSelector selector) {
        this.scheduleValueUpdate(content, selector, a -> {});
    }

    private void scheduleValueUpdate(final byte[] content, final IMetadataEventSelector selector, Consumer<DataWeaveValue> consumer) {
        Optional select = selector.select(this.event.getMetadata());
        if (select.isPresent()) {
            final MetadataType metadataType = (MetadataType)select.get();
            if (metadataType instanceof AnyType || metadataType instanceof BinaryType) {
                return;
            }
            Job liveDataUpdater = new Job("Updating tree live data for " + selector.getId()){

                protected IStatus run(IProgressMonitor monitor) {
                    Map readerProperties;
                    String mimeType = (String)metadataType.getMetadataFormat().getValidMimeTypes().iterator().next();
                    IWeaveUIModule moduleByContentType = WeaveUIModuleManager.getModuleByContentType((String)mimeType);
                    String inputSampleDataMimetype = moduleByContentType.getSampleDataMimeType();
                    if (inputSampleDataMimetype == "application/dw") {
                        readerProperties = new HashMap();
                    } else {
                        readerProperties = DwMetadataUtils.getReaderProperties((MetadataType)metadataType);
                        if ("application/flatfile".equals(inputSampleDataMimetype)) {
                            readerProperties.putAll(MetadataTypeHelper.getAdditionalProperties((MetadataType)metadataType));
                        }
                        IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
                        FlatFileSchemaUtils.fixSchemaPathIsRequired((IMuleProject)muleProject, readerProperties);
                    }
                    DataWeaveScriptingEngine dataWeaveScriptingEngine = new DataWeaveScriptingEngine();
                    DataWeaveScript compile = dataWeaveScriptingEngine.compile("payload", new String[]{"payload"});
                    try {
                        ExecuteResult exec = compile.exec(new ScriptingBindings().addBinding("payload", (Object)content, inputSampleDataMimetype, readerProperties));
                        DataWeaveValue asDWValue = exec.asDWValue();
                        InputTreeLiveDataProviderManager.this.rootValues.put(selector.getId(), asDWValue);
                        InputTreeLiveDataProviderManager.this.eventBus.fireEvent((IEvent)new InputLiveDataUpdatedEvent(selector, asDWValue));
                    }
                    catch (Exception e) {
                        MuleCorePlugin.logError((String)("Error while parsing sample data for :`" + selector.getId() + "` with mimeType " + mimeType), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            liveDataUpdater.schedule();
        }
    }

    public void loadSampleData(IFile sampleFile, IMetadataEventSelector selector, Consumer<DataWeaveValue> consumer) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream is = sampleFile.getContents();){
                this.scheduleValueUpdate(IOUtils.toByteArray((InputStream)is), selector, consumer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)("Error while reading sample content data for :" + selector.getId()), (Throwable)e);
        }
    }

    public ILiveDataProvider getLiveData(final IMetadataEventSelector selector, DataWeaveValueSelectorExpression expression) {
        return new AbstractWeaveValueLiveDataProvider(expression){

            @Override
            protected DataWeaveValue getValue() {
                return InputTreeLiveDataProviderManager.this.rootValues.get(selector.getId());
            }
        };
    }

    public ITreeLiveDataProvider getLiveDataProvider(IMetadataEventSelector selector) {
        return new InputTreeLiveDataProvider(selector);
    }

    public class InputTreeLiveDataProvider
    implements ITreeLiveDataProvider {
        private IMetadataEventSelector selector;

        public InputTreeLiveDataProvider(IMetadataEventSelector selector) {
            this.selector = selector;
        }

        public ILiveDataProvider getLiveDataProvider(DataWeaveValueSelectorExpression expression) {
            return InputTreeLiveDataProviderManager.this.getLiveData(this.selector, expression);
        }
    }
}

