/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.input;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.mule.tooling.dfl.ui.graphical.model.ITreeGraphicalMapping;
import org.mule.tooling.dfl.ui.graphical.util.TreeViewerHelper;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.TwoWayHandler;
import org.mule.tooling.ui.dfl.contribution.editor.script.EditorContext;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.ClearMetadataAction;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.GoToMappingAction;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.InputViewer;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.MappingsPathFormatter;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.NewVariableAction;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.SelectMappingAction;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.SetMetadataAction;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.SpecifySampleDataAction;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.IMappingModel;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class InputContextMenuProvider {
    private final EditorContext context;
    private final InputViewer inputViewer;
    private final IMappingModel messageTransformer;
    private boolean isGoToAction;
    private TwoWayHandler twoWayHandler;
    private Iterable<ITreeGraphicalMapping> mappings = Collections.emptyList();

    public InputContextMenuProvider(EditorContext context, InputViewer inputViewer, IMappingModel transformerModel) {
        this.context = context;
        this.inputViewer = inputViewer;
        this.messageTransformer = transformerModel;
    }

    public boolean isGoToAction() {
        return this.isGoToAction;
    }

    public void setGoToAction(boolean isGoToAction) {
        this.isGoToAction = isGoToAction;
    }

    public EditorContext getContext() {
        return this.context;
    }

    public IMappingModel getMessageTransformer() {
        return this.messageTransformer;
    }

    public void provideContextMenuFor(Control control, ISelectionProvider selectionProvider) {
        this.provideContextMenuFor(control, this.createMenuListener(selectionProvider));
    }

    public void provideContextMenuForLink(Control control, ISelectionProvider selectionProvider, TreeItem item, GraphicalTreeNode<?> node) {
        this.provideContextMenuFor(control, new LinkContextMenuListener(selectionProvider, item, node));
    }

    private void provideContextMenuFor(Control control, IMenuListener menuListener) {
        MenuManager menuManager = new MenuManager();
        menuManager.addMenuListener(menuListener);
        menuManager.setRemoveAllWhenShown(true);
        control.setMenu(menuManager.createContextMenu(control));
    }

    public void provideContextMenuFor(Viewer viewer) {
        this.provideContextMenuFor(viewer.getControl(), (ISelectionProvider)viewer);
    }

    public IMenuListener createMenuListener(ISelectionProvider selectionProvider) {
        return new InputContextMenuListener(selectionProvider);
    }

    public void updateMappings(Iterable<ITreeGraphicalMapping> mappings) {
        this.mappings = mappings == null ? Collections.emptyList() : mappings;
    }

    protected IAction createSetMetaDataActionFor(GraphicalTreeNode<?> treeNode) {
        return new SetMetadataAction(this.twoWayHandler, this.context.getInputMetadataProvider(), treeNode);
    }

    protected IAction createClearMetaDataActionFor(GraphicalTreeNode<?> treeNode) {
        return new ClearMetadataAction(this.twoWayHandler, this.context.getInputMetadataProvider(), treeNode, this.messageTransformer);
    }

    protected IAction createNewVariableActionFor(GraphicalTreeNode<?> treeNode) {
        return new NewVariableAction(treeNode, this.context, this.twoWayHandler);
    }

    protected IAction createSpecifySampleDataActionFor(GraphicalTreeNode<?> treeNode) {
        return new SpecifySampleDataAction(treeNode, this.context.getInputMetadataProvider(), this.inputViewer);
    }

    protected IAction createSelectMappingAction(String text, ITreeGraphicalMapping mapping) {
        return new SelectMappingAction(text, mapping, this.twoWayHandler);
    }

    protected IAction createGoToMappingAction(String text, ITreeGraphicalMapping mapping) {
        return new GoToMappingAction(text, mapping, this.twoWayHandler);
    }

    protected Collection<ITreeGraphicalMapping> mappingsFrom(GraphicalTreeNode<?> treeNode) {
        ArrayList<ITreeGraphicalMapping> result = new ArrayList<ITreeGraphicalMapping>();
        HashSet<TreeItem> outputs = new HashSet<TreeItem>();
        for (ITreeGraphicalMapping mapping : this.mappings) {
            TreeItem leftTreeItem = mapping.getLeftItem().getTreeItem();
            if (leftTreeItem == null || leftTreeItem.getData() != treeNode || outputs.contains(mapping.getRightItem().getTreeItem())) continue;
            result.add(mapping);
            TreeItem rightTreeItem = mapping.getRightItem().getTreeItem();
            outputs.add(rightTreeItem);
        }
        return result;
    }

    public void setTwoWayHandler(TwoWayHandler twoWayHandler) {
        this.twoWayHandler = twoWayHandler;
    }

    private class InputContextMenuListener
    implements IMenuListener {
        private final ISelectionProvider selectionProvider;

        public InputContextMenuListener(ISelectionProvider selectionProvider) {
            this.selectionProvider = selectionProvider;
        }

        public void menuAboutToShow(IMenuManager manager) {
            Optional<GraphicalTreeNode<?>> maybeNode = this.getSelectedNode();
            if (maybeNode.isPresent()) {
                this.fillMenu(manager, maybeNode.get());
            }
            InputContextMenuProvider.this.setGoToAction(false);
        }

        protected void fillMenu(IMenuManager manager, GraphicalTreeNode<?> node) {
            if (this.modelIsMetadataRoot(node)) {
                this.fillInputVariableMenu(manager, node);
            } else if (this.modelIsMetadataVariables(node)) {
                this.fillVariablesMenu(manager, node);
            } else {
                this.fillFieldMenu(manager, node);
            }
        }

        private Optional<GraphicalTreeNode<?>> getSelectedNode() {
            return TreeViewerHelper.getSelectedNode((ISelectionProvider)this.selectionProvider);
        }

        private boolean modelIsMetadataRoot(GraphicalTreeNode<?> node) {
            return !this.isVariablesNode(node) && (node.getParent() == null || this.isVariablesNode(node.getParent()));
        }

        private boolean isVariablesNode(GraphicalTreeNode<?> node) {
            return "vars".equals(node.getId());
        }

        private boolean modelIsMetadataVariables(GraphicalTreeNode<?> node) {
            return this.isVariablesNode(node);
        }

        private void fillFieldMenu(IMenuManager manager, GraphicalTreeNode<?> treeNode) {
            Collection<ITreeGraphicalMapping> mappingsFromSelection = InputContextMenuProvider.this.mappingsFrom(treeNode);
            if (mappingsFromSelection.size() < 2) {
                return;
            }
            for (Map.Entry<String, ITreeGraphicalMapping> entry : MappingsPathFormatter.formatOutputPaths(mappingsFromSelection).entrySet()) {
                if (InputContextMenuProvider.this.isGoToAction) {
                    manager.add(InputContextMenuProvider.this.createGoToMappingAction(entry.getKey(), entry.getValue()));
                    continue;
                }
                manager.add(InputContextMenuProvider.this.createSelectMappingAction(entry.getKey(), entry.getValue()));
            }
        }

        protected void fillInputVariableMenu(IMenuManager manager, GraphicalTreeNode<?> treeNode) {
            manager.add(InputContextMenuProvider.this.createSetMetaDataActionFor(treeNode));
            manager.add(InputContextMenuProvider.this.createClearMetaDataActionFor(treeNode));
            manager.add(InputContextMenuProvider.this.createSpecifySampleDataActionFor(treeNode));
        }

        private void fillVariablesMenu(IMenuManager manager, GraphicalTreeNode<?> treeNode) {
            manager.add(InputContextMenuProvider.this.createNewVariableActionFor(treeNode));
        }
    }

    private class LinkContextMenuListener
    extends InputContextMenuListener {
        private TreeItem item;
        private GraphicalTreeNode<?> node;

        public LinkContextMenuListener(ISelectionProvider selectionProvider, TreeItem item, GraphicalTreeNode<?> node) {
            super(selectionProvider);
            this.item = item;
            this.node = node;
        }

        @Override
        public void menuAboutToShow(IMenuManager manager) {
            this.fillMenu(manager, this.node);
        }

        @Override
        protected void fillInputVariableMenu(IMenuManager manager, GraphicalTreeNode<?> treeNode) {
            manager.add(InputContextMenuProvider.this.createSetMetaDataActionFor(treeNode));
            manager.add(InputContextMenuProvider.this.createClearMetaDataActionFor(treeNode));
            manager.add((IAction)new SpecifySampleDataAction(treeNode, InputContextMenuProvider.this.context.getInputMetadataProvider(), InputContextMenuProvider.this.inputViewer));
        }
    }
}

