/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.input;

import org.eclipse.swt.widgets.TreeItem;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.InputType;

public final class InputConfigurationHelper {
    private InputConfigurationHelper() {
    }

    public static boolean isInputPayload(TreeItem currentItem) {
        String name;
        String string = name = currentItem != null ? currentItem.getText() : null;
        return name != null && name.startsWith("Payload");
    }

    public static boolean isInputAttributes(TreeItem currentItem) {
        String name;
        String string = name = currentItem != null ? currentItem.getText() : null;
        return name != null && name.startsWith("Attributes");
    }

    public static boolean isInputVariables(TreeItem currentItem) {
        String name;
        String string = name = currentItem != null ? currentItem.getText() : null;
        return name != null && name.startsWith("Variables");
    }

    public static boolean isAdditionalInputSource(TreeItem currentItem) {
        return InputConfigurationHelper.isInputVariables(currentItem);
    }

    public static InputType getInputType(TreeItem currentItem) {
        if (InputConfigurationHelper.isInputPayload(currentItem)) {
            return InputType.PAYLOAD;
        }
        if (InputConfigurationHelper.isInputAttributes(currentItem)) {
            return InputType.ATTRIBUTES;
        }
        if (InputConfigurationHelper.isInputVariables(currentItem.getParentItem())) {
            return InputType.VARIABLES;
        }
        throw new RuntimeException("Invalid input type");
    }

    public static String getInputConfigurationName(TreeItem item) {
        return InputConfigurationHelper.getInputConfigurationName(item.getText());
    }

    public static String getInputConfigurationName(String str) {
        return str.substring(0, str.indexOf(":") - 1);
    }
}

