/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.input;

import java.util.List;
import java.util.Optional;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.datasense.MetadataHelper;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.dfl.ui.utils.GraphicalTreeNodeUtils;
import org.mule.tooling.model.messageflow.ComponentId;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.ui.dfl.contribution.editor.datasense.RemoveMetadataOperation;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.TwoWayHandler;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.AbstractMetaDataTreeAction;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.IMappingModel;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageRowType;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class ClearMetadataAction
extends AbstractMetaDataTreeAction {
    private final TwoWayHandler twoWayHandler;
    private final Optional<MessageRowType> maybeCurrentRowType;
    private final IMappingModel messageTransformer;

    public ClearMetadataAction(TwoWayHandler twoWayHandler, IMetaDataProvider metaDataProvider, GraphicalTreeNode<?> treeNode, IMappingModel messageTransformer) {
        super("Clear Metadata", treeNode, metaDataProvider);
        this.twoWayHandler = twoWayHandler;
        this.messageTransformer = messageTransformer;
        this.maybeCurrentRowType = GraphicalTreeNodeUtils.isUnresolvedMetadataNodeId(treeNode) ? Optional.empty() : Optional.ofNullable(metaDataProvider.isPayload(treeNode.getId()) ? MessageRowType.INPUT_PAYLOAD : (metaDataProvider.isAttributes(treeNode.getId()) ? MessageRowType.INPUT_ATTRIBUTES : (MessageRowType)MetadataHelper.getCurrentMessageRowType((GraphicalTreeNode)treeNode.getParent()).get()));
    }

    public void run() {
        this.maybeCurrentRowType.ifPresent(currentRowType -> {
            RemoveMetadataOperation updateOperation = new RemoveMetadataOperation(this.twoWayHandler, (MessageRowType)currentRowType, (GraphicalTreeNode<?>)this.treeNode, this.messageTransformer);
            updateOperation.remove();
        });
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.maybeCurrentRowType.isPresent() && this.isCustomMetadata();
    }

    private boolean isCustomMetadata() {
        return this.maybeCurrentRowType.map(currentRowType -> {
            ComponentId componentId = ComponentId.from((IMessageFlowEntity)this.messageTransformer.getNode());
            if (componentId.isDefined()) {
                ITypesManager typesManager = MetadataHelper.getTypesManager((IMuleProject)this.messageTransformer.getMuleProject());
                Optional enricher = typesManager.getEnricher(componentId);
                List configurations = currentRowType.loadConfigFrom(enricher);
                if (configurations != null && !configurations.isEmpty()) {
                    return true;
                }
                return false;
            }
            return false;
        }).orElse(false);
    }
}

