/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.input;

import java.util.Optional;
import org.eclipse.jface.viewers.StyledString;
import org.mule.tooling.dfl.ui.graphical.livedata.DataWeaveValueSelectorExpression;
import org.mule.tooling.dfl.ui.graphical.livedata.ILiveDataProvider;
import org.mule.tooling.dfl.ui.module.DataWeaveValueUIHelper;
import org.mule.weave.v2.runtime.ArrayDataWeaveValue;
import org.mule.weave.v2.runtime.DataWeaveValue;
import org.mule.weave.v2.runtime.SimpleDataWeaveValue;

public abstract class AbstractWeaveValueLiveDataProvider
implements ILiveDataProvider {
    private DataWeaveValueSelectorExpression expression;

    public AbstractWeaveValueLiveDataProvider(DataWeaveValueSelectorExpression expression) {
        this.expression = expression;
    }

    protected abstract DataWeaveValue getValue();

    public Optional<String> getLiveData() {
        Optional<DataWeaveValue> selected = this.getSelectedValue();
        if (selected.isPresent()) {
            DataWeaveValue arrayItem;
            ArrayDataWeaveValue arrayDataWeaveValue;
            DataWeaveValue selectedValue = selected.get();
            if (selectedValue instanceof SimpleDataWeaveValue) {
                return Optional.of(((SimpleDataWeaveValue)selectedValue).valueAsString());
            }
            if (selectedValue instanceof ArrayDataWeaveValue && (arrayDataWeaveValue = (ArrayDataWeaveValue)selectedValue).head().isDefined() && (arrayItem = (DataWeaveValue)arrayDataWeaveValue.head().get()) instanceof SimpleDataWeaveValue) {
                return Optional.of("[" + ((SimpleDataWeaveValue)arrayItem).valueAsString() + "]");
            }
        }
        return Optional.empty();
    }

    public Optional<DataWeaveValue> getSelectedValue() {
        DataWeaveValue dataWeaveValue = this.getValue();
        if (dataWeaveValue != null) {
            return this.expression.select(dataWeaveValue);
        }
        return Optional.empty();
    }

    public StyledString.Styler getStyle() {
        Optional<DataWeaveValue> selectedValue = this.getSelectedValue();
        if (selectedValue.isPresent()) {
            return DataWeaveValueUIHelper.getStyler((DataWeaveValue)selectedValue.get());
        }
        return super.getStyle();
    }
}

