/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script.input;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.dfl.ui.utils.GraphicalTreeNodeUtils;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.InputType;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public abstract class AbstractMetaDataTreeAction
extends Action {
    protected final GraphicalTreeNode<? extends MetadataType> treeNode;
    private IMetaDataProvider metaDataProvider;

    public AbstractMetaDataTreeAction(String text, GraphicalTreeNode<?> treeNode, IMetaDataProvider metaDataProvider) {
        super(text);
        this.treeNode = this.asMetaDataTreeNode(treeNode);
        this.metaDataProvider = metaDataProvider;
    }

    public AbstractMetaDataTreeAction(String text, ImageDescriptor image, GraphicalTreeNode<?> treeNode, IMetaDataProvider metaDataProvider) {
        super(text, image);
        this.treeNode = this.asMetaDataTreeNode(treeNode);
        this.metaDataProvider = metaDataProvider;
    }

    public AbstractMetaDataTreeAction(String text, int style, GraphicalTreeNode<?> treeNode, IMetaDataProvider metaDataProvider) {
        super(text, style);
        this.treeNode = this.asMetaDataTreeNode(treeNode);
        this.metaDataProvider = metaDataProvider;
    }

    protected MetadataType getMetadataType() {
        return (MetadataType)this.treeNode.getModel();
    }

    protected InputType getInputType() {
        if (this.metaDataProvider.isPayload(this.treeNode.getId())) {
            return InputType.PAYLOAD;
        }
        if (this.metaDataProvider.isAttributes(this.treeNode.getId())) {
            return InputType.ATTRIBUTES;
        }
        if (this.treeNode.getParent() != null) {
            return InputType.VARIABLES;
        }
        throw new IllegalStateException("Cannot determine the InputType for the current tree node");
    }

    public boolean isEnabled() {
        return !GraphicalTreeNodeUtils.isUnresolvedMetadataNodeId(this.treeNode);
    }

    private GraphicalTreeNode<? extends MetadataType> asMetaDataTreeNode(GraphicalTreeNode<?> treeNode) {
        return treeNode;
    }
}

