/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.flatfile.FlatfileTypeLoader;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.graphical.WeaveUIConstants;
import org.mule.tooling.dfl.ui.graphical.model.ITreeGraphicalMapping;
import org.mule.tooling.dfl.ui.graphical.providers.IConnectorProvider;
import org.mule.tooling.dfl.ui.utils.WeaveGraphicalTreeNode;
import org.mule.tooling.metadata.annotations.ElementAnnotation;
import org.mule.tooling.metadata.annotations.PathAnnotation;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.mule.json.schemas.FlatFileSchemaUtils;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.IMappingModel;
import org.mule.tooling.ui.dfl.contribution.editor.utils.ProjectHelper;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeLabelProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class WeaveGraphicalTreeLabelProvider
extends GraphicalTreeLabelProvider {
    private static final int PADDING_IMAGE = 2;
    private static final Image WARNING_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
    private static Method viewerCellMethod;
    private static Method useColorsMethod;
    private static Method sharedTextLayoutMethod;
    private static Method columnViewerOwnerMethod;
    private static Method drawFocusMethod;
    private IConnectorProvider connectorProvider;
    private static final StyledString.Styler dataTypeStyler;
    private static final StyledString.Styler headerFieldStyler;
    private static final StyledString.Styler mappedFieldStyler;
    private static final StyledString.Styler unmappedFieldStyler;
    private static boolean methodsLoaded;
    private IMappingModel messageTransformer;
    private List<Indicator> indicators = new ArrayList<Indicator>();
    private int deltaOfLastMeasure;

    static {
        dataTypeStyler = new DataTypeStyler();
        headerFieldStyler = new HeaderFieldStyler();
        mappedFieldStyler = new MappedFieldStyler();
        unmappedFieldStyler = new UnmappedFieldStyler();
        try {
            viewerCellMethod = StyledCellLabelProvider.class.getDeclaredMethod("getViewerCell", Event.class, Object.class);
            viewerCellMethod.setAccessible(true);
            useColorsMethod = StyledCellLabelProvider.class.getDeclaredMethod("useColors", Event.class);
            useColorsMethod.setAccessible(true);
            sharedTextLayoutMethod = StyledCellLabelProvider.class.getDeclaredMethod("getSharedTextLayout", Display.class);
            sharedTextLayoutMethod.setAccessible(true);
            columnViewerOwnerMethod = ColumnViewer.class.getDeclaredMethod("getColumnViewerOwner", Integer.TYPE);
            columnViewerOwnerMethod.setAccessible(true);
            drawFocusMethod = StyledCellLabelProvider.class.getDeclaredMethod("drawFocus", Event.class);
            drawFocusMethod.setAccessible(true);
            methodsLoaded = true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            methodsLoaded = false;
            MuleCorePlugin.logError((String)"Failed to init static in WeaveGraphicalTreeLabelProvider", (Throwable)e);
        }
    }

    public WeaveGraphicalTreeLabelProvider() {
        this(null);
    }

    public WeaveGraphicalTreeLabelProvider(IMappingModel messageTransformer) {
        this.messageTransformer = messageTransformer;
        this.indicators.add(new SchemaPathIndicator());
        this.indicators.add(new ValidateSchemaPathIndicator());
        this.indicators.add(new IdentIndicator());
    }

    public void setConnectorProvider(IConnectorProvider connectorProvider) {
        this.connectorProvider = connectorProvider;
    }

    public Color getForeground(Object element) {
        return WeaveUIConstants.ALUMINUM_5;
    }

    public Image getCustomImage(Object element) {
        GraphicalTreeNode node = (GraphicalTreeNode)element;
        for (Indicator indicator : this.indicators) {
            if (!indicator.isApplicable(node, this.messageTransformer)) continue;
            return WARNING_IMAGE;
        }
        return super.getImage(element);
    }

    public String getToolTipText(Object element) {
        GraphicalTreeNode node = (GraphicalTreeNode)element;
        StringBuilder sb = new StringBuilder();
        for (Indicator indicator : this.indicators) {
            if (!indicator.isApplicable(node, this.messageTransformer)) continue;
            sb.append(indicator.getToolTipText(node));
            sb.append("\n");
        }
        String result = sb.toString();
        if (!result.isEmpty()) {
            return result.substring(0, result.length() - 1);
        }
        String toolTipText = super.getToolTipText(element);
        return StringUtils.isNotEmpty((String)toolTipText) ? toolTipText : null;
    }

    protected StyledString.Styler getSuffixStyle(GraphicalTreeNode<?> element) {
        WeaveGraphicalTreeNode node = (WeaveGraphicalTreeNode)element;
        return node.getLiveDataSytle();
    }

    protected StyledString.Styler getDataStyle(ViewerCell cell) {
        if (this.connectorProvider != null) {
            TreeItem item = (TreeItem)cell.getItem();
            GraphicalTreeNode node = (GraphicalTreeNode)item.getData();
            String id = node.getId();
            if (this.isHeaderFile(id)) {
                return headerFieldStyler;
            }
            for (ITreeGraphicalMapping mapping : this.connectorProvider.getMappings()) {
                TreeItem connectorItem = this.connectorProvider.getConnectorItem(mapping);
                if (connectorItem != cell.getItem()) continue;
                return mappedFieldStyler;
            }
        }
        return unmappedFieldStyler;
    }

    protected StyledString.Styler getDataTypeStyle(ViewerCell cell) {
        StyledString.Styler result = dataTypeStyler;
        TreeItem item = (TreeItem)cell.getItem();
        GraphicalTreeNode node = (GraphicalTreeNode)item.getData();
        String id = node.getId();
        if (this.isHeaderFile(id)) {
            result = headerFieldStyler;
        }
        return result;
    }

    protected void paint(Event event, Object element) {
        GraphicalTreeNode node = (GraphicalTreeNode)element;
        if (node != null) {
            Object model = node.getModel();
            if (!MetadataUtils.isUnknown((Object)model)) {
                this.doPaint(event, element);
            }
        } else {
            this.doPaint(event, element);
        }
    }

    protected void doPaint(Event event, Object element) {
        try {
            boolean drawFocus;
            Rectangle textBounds;
            Rectangle imageBounds;
            Image image;
            if (!methodsLoaded || !this.isOwnerDrawEnabled()) {
                return;
            }
            ViewerCell cell = (ViewerCell)viewerCellMethod.invoke((Object)this, event, element);
            boolean applyColors = (Boolean)useColorsMethod.invoke((Object)this, event);
            GC gc = event.gc;
            Color oldForeground = gc.getForeground();
            Color oldBackground = gc.getBackground();
            if (applyColors) {
                Color background;
                Color foreground = cell.getForeground();
                if (foreground != null) {
                    gc.setForeground(foreground);
                }
                if ((background = cell.getBackground()) != null) {
                    gc.setBackground(background);
                }
            }
            if ((image = this.getCustomImage(element)) != null && (imageBounds = cell.getImageBounds()) != null) {
                Rectangle bounds = image.getBounds();
                int x = imageBounds.x + Math.max(0, (imageBounds.width - bounds.width) / 2);
                int y = imageBounds.y + Math.max(0, (imageBounds.height - bounds.height) / 2);
                gc.drawImage(image, x, y);
            }
            if ((textBounds = cell.getTextBounds()) != null) {
                TextLayout textLayout = (TextLayout)sharedTextLayoutMethod.invoke((Object)this, event.display);
                Rectangle layoutBounds = textLayout.getBounds();
                Widget widget = (Widget)columnViewerOwnerMethod.invoke((Object)this.getViewer(), cell.getColumnIndex());
                int style = widget.getStyle();
                int x = textBounds.x;
                if ((style & 0x20000) != 0) {
                    x = textBounds.x + textBounds.width - textLayout.getBounds().width;
                } else if ((style & 0x1000000) != 0) {
                    x = textBounds.x + (textBounds.width - textLayout.getBounds().width) / 2;
                }
                int y = textBounds.y + Math.max(0, (textBounds.height - layoutBounds.height) / 2);
                Rectangle saveClipping = gc.getClipping();
                gc.setClipping(textBounds);
                if (image != null) {
                    Rectangle bounds = image.getBounds();
                    textLayout.draw(gc, x + bounds.width + 2, y);
                } else {
                    textLayout.draw(gc, x, y);
                }
                gc.setClipping(saveClipping);
            }
            if (drawFocus = ((Boolean)drawFocusMethod.invoke((Object)this, event)).booleanValue()) {
                Rectangle focusBounds = cell.getViewerRow().getBounds();
                gc.drawFocus(focusBounds.x, focusBounds.y, focusBounds.width + this.deltaOfLastMeasure, focusBounds.height);
            }
            if (applyColors) {
                gc.setForeground(oldForeground);
                gc.setBackground(oldBackground);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void measure(Event event, Object element) {
        int initialValue = event.width;
        super.measure(event, element);
        this.deltaOfLastMeasure = event.width - initialValue;
        Image customImage = this.getCustomImage(element);
        if (customImage != null) {
            event.width = event.width + customImage.getBounds().width + 2;
        }
    }

    private boolean isHeaderFile(String id) {
        return "payload".equals(id) || "vars".equals(id) || "attributes".equals(id);
    }

    private static final class DataTypeStyler
    extends StyledString.Styler {
        private DataTypeStyler() {
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = WeaveUIConstants.ALUMINUM_DATA_TYPE;
            textStyle.font = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
        }
    }

    private static final class HeaderFieldStyler
    extends StyledString.Styler {
        private HeaderFieldStyler() {
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = ThemeUtils.getCurrentTheme().getForegroundColor();
        }
    }

    private static class IdentIndicator
    implements Indicator {
        private IdentIndicator() {
        }

        @Override
        public String getToolTipText(GraphicalTreeNode<?> node) {
            if (node != null) {
                Object model = node.getModel();
                MetadataType metadataType = (MetadataType)model;
                Optional maybeSchemaConstruct = FlatFileSchemaUtils.getStructureComponent((MetadataType)metadataType);
                return maybeSchemaConstruct.map(value -> "Missing " + value.getName() + " ident").orElse("Missing schema construct");
            }
            return "Missing reader configuration";
        }

        @Override
        public boolean isApplicable(GraphicalTreeNode<?> node, IMappingModel messageTransformer) {
            Object model;
            if (node != null && (model = node.getModel()) != null && !this.isUndefined(model) && messageTransformer != null && "payload".equals(node.getId())) {
                MetadataType metadataType = (MetadataType)model;
                MetadataFormat metadataFormat = metadataType.getMetadataFormat();
                boolean isFlatFile = FlatfileTypeLoader.FLAT_FILE.equals((Object)metadataFormat);
                boolean isCopyBook = FlatfileTypeLoader.COPYBOOK.equals((Object)metadataFormat);
                Optional maybeSchemaConstruct = FlatFileSchemaUtils.getStructureComponent((MetadataType)metadataType);
                return (isFlatFile || isCopyBook) && maybeSchemaConstruct.isPresent() && !metadataType.getAnnotation(ElementAnnotation.class).isPresent();
            }
            return false;
        }

        private boolean isUndefined(Object model) {
            return model instanceof MetadataType && MetadataFactory.isUndefined((MetadataType)((MetadataType)model));
        }
    }

    private static interface Indicator {
        public String getToolTipText(GraphicalTreeNode<?> var1);

        public boolean isApplicable(GraphicalTreeNode<?> var1, IMappingModel var2);
    }

    private static final class MappedFieldStyler
    extends StyledString.Styler {
        private MappedFieldStyler() {
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = ThemeUtils.getCurrentTheme().getForegroundColor();
        }
    }

    private static class SchemaPathIndicator
    implements Indicator {
        private SchemaPathIndicator() {
        }

        @Override
        public String getToolTipText(GraphicalTreeNode<?> node) {
            return "Missing schema path";
        }

        @Override
        public boolean isApplicable(GraphicalTreeNode<?> node, IMappingModel messageTransformer) {
            Object model;
            if (node != null && (model = node.getModel()) != null && !this.isUndefined(model) && messageTransformer != null && "payload".equals(node.getId())) {
                MetadataType metadataType = (MetadataType)model;
                MetadataFormat metadataFormat = metadataType.getMetadataFormat();
                boolean isFixedWidth = FlatfileTypeLoader.FIXED_WIDTH.equals((Object)metadataFormat);
                boolean isCopybook = FlatfileTypeLoader.COPYBOOK.equals((Object)metadataFormat);
                boolean isFlatFile = FlatfileTypeLoader.FLAT_FILE.equals((Object)metadataFormat);
                boolean isSchemaPathPresent = metadataType.getAnnotation(PathAnnotation.class).isPresent();
                return isFixedWidth | isCopybook | isFlatFile && !isSchemaPathPresent;
            }
            return false;
        }

        private boolean isUndefined(Object model) {
            return model instanceof MetadataType && MetadataFactory.isUndefined((MetadataType)((MetadataType)model));
        }
    }

    private static final class UnmappedFieldStyler
    extends StyledString.Styler {
        private UnmappedFieldStyler() {
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = WeaveUIConstants.ALUMINUM_5;
        }
    }

    private static class ValidateSchemaPathIndicator
    implements Indicator {
        private ValidateSchemaPathIndicator() {
        }

        @Override
        public String getToolTipText(GraphicalTreeNode<?> node) {
            return "Schema file not found on file system or classpath";
        }

        @Override
        public boolean isApplicable(GraphicalTreeNode<?> node, IMappingModel messageTransformer) {
            Object model;
            if (node != null && (model = node.getModel()) != null && !this.isUndefined(model) && messageTransformer != null && "payload".equals(node.getId())) {
                MetadataType metadataType = (MetadataType)model;
                MetadataFormat metadataFormat = metadataType.getMetadataFormat();
                boolean isFixedWidth = FlatfileTypeLoader.FIXED_WIDTH.equals((Object)metadataFormat);
                boolean isCopybook = FlatfileTypeLoader.COPYBOOK.equals((Object)metadataFormat);
                boolean isFlatFile = FlatfileTypeLoader.FLAT_FILE.equals((Object)metadataFormat);
                IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
                return isFixedWidth | isCopybook | isFlatFile && metadataType.getAnnotation(PathAnnotation.class).isPresent() && !ProjectHelper.getFile(muleProject, ((PathAnnotation)metadataType.getAnnotation(PathAnnotation.class).get()).getPath()).exists();
            }
            return false;
        }

        private boolean isUndefined(Object model) {
            return model instanceof MetadataType && MetadataFactory.isUndefined((MetadataType)((MetadataType)model));
        }
    }
}

