/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import java.util.Optional;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.dFL.AttributeElement;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.ui.graphical.view2code.KeyValuePairContainer;
import org.mule.tooling.dfl.ui.ls.DataWeaveLanguageService;
import org.mule.tooling.dfl.ui.utils.GraphicalTreeNodeUtils;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.TwoWayHandler;
import org.mule.tooling.ui.dfl.contribution.editor.script.ApplyFunctionAction;
import org.mule.tooling.ui.dfl.contribution.editor.script.FunctionDefinitionPresenterUtils;
import org.mule.tooling.ui.dfl.contribution.editor.script.OpenFunctionBrowserAction;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.weave.v2.editor.FunctionDefinition;
import org.mule.weave.v2.editor.FunctionParameterDefinition;
import org.mule.weave.v2.el.tooling.MuleWeaveToolingHelper;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.ts.WeaveType;
import scala.Option;

public class TransformationContextMenuManager
implements IMenuListener {
    private TwoWayHandler twoWayHandler;
    private Viewer viewer;

    public TransformationContextMenuManager(TwoWayHandler twoWayHandler, Viewer viewer) {
        this.twoWayHandler = twoWayHandler;
        this.viewer = viewer;
    }

    public void menuAboutToShow(IMenuManager manager) {
        GraphicalTreeNode element;
        AnalyticsRecordsFactory.single((String)Events.DW_APPLY_FUNCTION_MENU).track();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        IMuleProject project = this.twoWayHandler.getEditorContext().getProject();
        DataWeaveLanguageService instance = DataWeaveLanguageService.getInstance((IMuleProject)project);
        if (!selection.isEmpty() && !GraphicalTreeNodeUtils.isUnresolvedMetadataNodeId((GraphicalTreeNode)(element = (GraphicalTreeNode)selection.getFirstElement()))) {
            Optional<Expression> selectedExpression;
            MetadataType metadataType;
            Object model = element.getModel();
            if (model instanceof ObjectFieldType) {
                ObjectFieldType field = (ObjectFieldType)model;
                metadataType = field.getValue();
                selectedExpression = this.twoWayHandler.performFindKeyValuePairWork(selection).map(KeyValuePairContainer::getValue);
            } else if (model instanceof AttributeFieldType) {
                metadataType = ((AttributeFieldType)model).getValue();
                selectedExpression = this.twoWayHandler.performFindAttributeElement(selection).map(AttributeElement::getValue);
            } else if (model instanceof MetadataType) {
                metadataType = (MetadataType)model;
                selectedExpression = Optional.of(this.twoWayHandler.document().getBody().getContent().getElement());
            } else {
                return;
            }
            WeaveType selectedWeaveType = MuleWeaveToolingHelper.toWeaveType((MetadataType)metadataType);
            this.addFunctiontsFor(manager, instance, NameIdentifier.CORE_MODULE(), selectedWeaveType, selectedExpression, element);
            this.addFunctiontsFor(manager, instance, NameIdentifier.apply((String)"dw::core::Strings", (Option)Option.empty()), selectedWeaveType, selectedExpression, element);
            this.addFunctiontsFor(manager, instance, NameIdentifier.apply((String)"dw::core::Numbers", (Option)Option.empty()), selectedWeaveType, selectedExpression, element);
            manager.add((IContributionItem)new Separator("Function Browser"));
            manager.appendToGroup("Function Browser", (IAction)new OpenFunctionBrowserAction(selectedWeaveType, this.twoWayHandler, project, element, this.viewer));
        }
    }

    private void addFunctiontsFor(IMenuManager manager, DataWeaveLanguageService instance, NameIdentifier moduleId, WeaveType selectedWeaveType, Optional<Expression> keyValuePair, GraphicalTreeNode<?> selectedNode) {
        FunctionDefinition[] availableModuleFunctions = instance.availableModuleFunctions(moduleId);
        boolean first = true;
        FunctionDefinition[] functionDefinitionArray = availableModuleFunctions;
        int n = availableModuleFunctions.length;
        int n2 = 0;
        while (n2 < n) {
            FunctionDefinition functionDefinition = functionDefinitionArray[n2];
            if (functionDefinition.params().length == 1) {
                if (first) {
                    manager.add((IContributionItem)new Separator(moduleId.name()));
                    first = false;
                }
                Option returnType = functionDefinition.returnType();
                FunctionParameterDefinition param = functionDefinition.params()[0];
                Option weaveType = param.weaveType();
                if (weaveType.isDefined() && instance.canBeSubstituted((WeaveType)weaveType.get(), selectedWeaveType) && returnType.isDefined() && instance.canBeSubstituted((WeaveType)returnType.get(), selectedWeaveType)) {
                    NameIdentifier nameIdentifier = functionDefinition.nameIdentifier();
                    String functionLabel = FunctionDefinitionPresenterUtils.buildFunctionSignatureLabel(functionDefinition, param).toString();
                    if (!this.isInternalFunction(nameIdentifier)) {
                        ApplyFunctionAction action = new ApplyFunctionAction(this.twoWayHandler, functionLabel, selectedNode, functionDefinition, keyValuePair);
                        manager.appendToGroup(moduleId.name(), (IAction)action);
                    }
                }
            }
            ++n2;
        }
    }

    private boolean isInternalFunction(NameIdentifier nameIdentifier) {
        return nameIdentifier.localName().name().equals("native");
    }
}

