/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;

public class ToogleControlManager {
    private Composite control;
    private Action showOnlyCode;
    private Action hideMappings;
    private Action showFullMapping;

    public ToogleControlManager(Composite control, Action showOnlyCode, Action hideMappings, Action showFullMapping) {
        this.control = control;
        this.showOnlyCode = showOnlyCode;
        this.hideMappings = hideMappings;
        this.showFullMapping = showFullMapping;
        this.addListeners();
    }

    public Action getShowOnlyCode() {
        return this.showOnlyCode;
    }

    public Action getHideMappings() {
        return this.hideMappings;
    }

    public Action getShowFullMapping() {
        return this.showFullMapping;
    }

    private void addListeners() {
        final ActionCheckedListener showOnlyCodeListener = new ActionCheckedListener(this.hideMappings, this.showFullMapping);
        this.showOnlyCode.addPropertyChangeListener((IPropertyChangeListener)showOnlyCodeListener);
        final ActionCheckedListener hideMappindsListener = new ActionCheckedListener(this.showOnlyCode, this.showFullMapping);
        this.hideMappings.addPropertyChangeListener((IPropertyChangeListener)hideMappindsListener);
        final ActionCheckedListener showFullListener = new ActionCheckedListener(this.showOnlyCode, this.hideMappings);
        this.showFullMapping.addPropertyChangeListener((IPropertyChangeListener)showFullListener);
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ToogleControlManager.this.showOnlyCode.removePropertyChangeListener(showOnlyCodeListener);
                ToogleControlManager.this.hideMappings.removePropertyChangeListener(hideMappindsListener);
                ToogleControlManager.this.showFullMapping.removePropertyChangeListener(showFullListener);
            }
        });
    }

    public static class ActionCheckedListener
    implements IPropertyChangeListener {
        private Action[] actions2release;

        public ActionCheckedListener(Action ... actions2release) {
            this.actions2release = actions2release;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("checked".equals(event.getProperty()) && Boolean.TRUE.equals(event.getNewValue())) {
                Action[] actionArray = this.actions2release;
                int n = this.actions2release.length;
                int n2 = 0;
                while (n2 < n) {
                    Action toogleControlAction = actionArray[n2];
                    toogleControlAction.setChecked(false);
                    ++n2;
                }
            }
        }
    }
}

