/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.ui.dfl.contribution.DflPlugin;
import org.mule.tooling.ui.dfl.contribution.editor.action.IEditorModelAware;
import org.mule.tooling.ui.dfl.contribution.editor.script.BindingServiceHelper;
import org.mule.tooling.ui.dfl.contribution.editor.script.ToogleActionType;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.ToggleModeEvent;
import org.mule.tooling.ui.splitter.SashHandler;
import org.mule.tooling.ui.splitter.Splitter;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;

public class ToogleControlAction
extends Action {
    private Composite[] controls2Hide;
    private Composite[] controls2Show;
    private Splitter parent;
    private IEditorModelAware editorModel;
    private EventBus eventBus;
    private ToogleActionType type;

    public ToogleControlAction(ToogleActionType type, Splitter parent, EventBus eventBus, IEditorModelAware editorModel) {
        super("", 2);
        this.type = type;
        this.parent = parent;
        this.eventBus = eventBus;
        this.editorModel = editorModel;
        this.setToolTipText(type.getTooltip() + " (" + BindingServiceHelper.getShortcut(type.getCommandId()) + ")");
        this.setImageDescriptor(DflPlugin.getDefault().getImages().getImageDescriptor(type.getImage()));
    }

    public void setControls2Hide(Composite ... controls) {
        this.controls2Hide = controls;
    }

    public void setControls2Show(Composite ... controls) {
        this.controls2Show = controls;
    }

    public void run() {
        AnalyticsRecordsFactory.single((String)this.type.getAnalyticsEvent()).track();
        this.performChange();
        this.saveLastEditorMode();
        this.eventBus.fireEvent((IEvent)new ToggleModeEvent(this.type));
    }

    public void performChange() {
        Composite control;
        int n;
        int n2;
        Composite[] compositeArray;
        if (this.controls2Hide != null && this.controls2Hide.length > 0) {
            compositeArray = this.controls2Hide;
            n2 = this.controls2Hide.length;
            n = 0;
            while (n < n2) {
                control = compositeArray[n];
                control.setVisible(false);
                ++n;
            }
        }
        if (this.controls2Show != null && this.controls2Show.length > 0) {
            compositeArray = this.controls2Show;
            n2 = this.controls2Show.length;
            n = 0;
            while (n < n2) {
                control = compositeArray[n];
                control.setVisible(true);
                ++n;
            }
        }
        this.parent.layout(true, true);
        Display.getCurrent().syncExec(() -> {
            Map handlers = this.parent.getHandlers();
            for (SashHandler sashHandler : handlers.values()) {
                sashHandler.setPaintSashes(this.type.shouldPaintSashes());
            }
            this.editorModel.getCurrentTwoWayHandler().refreshGraphicalView();
        });
        this.setChecked(true);
    }

    public ToogleActionType getType() {
        return this.type;
    }

    private void saveLastEditorMode() {
        if (DflPlugin.reopenInLastEditorMode().booleanValue()) {
            DflPlugin.setDefaultToogleMode(this.type);
        }
    }
}

