/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import java.util.Collections;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.ui.datasense.IDataSenseProvider;
import org.mule.tooling.dfl.ui.datasense.OutputOverwriteDataSenseProvider;
import org.mule.tooling.dfl.ui.datasense.WeaveDataSenseProvider;
import org.mule.tooling.dfl.ui.embedded.editor.DFLTextViewerUndoManager;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.dfl.ui.ls.DataWeaveLanguageService;
import org.mule.tooling.dfl.ui.scafflod.ScaffoldingHelper;
import org.mule.tooling.dfl.ui.utils.GraphicalTreeNodeUtils;
import org.mule.tooling.dfl.ui.utils.ImagesHelper;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.TwoWayHandler;
import org.mule.tooling.ui.dfl.contribution.editor.script.BindingServiceHelper;
import org.mule.tooling.ui.dfl.contribution.editor.script.FunctionManagerComposite;
import org.mule.tooling.ui.dfl.contribution.editor.script.FunctionManagerPresenter;
import org.mule.tooling.ui.dfl.contribution.editor.script.FunctionParametersComposite;
import org.mule.tooling.ui.dfl.contribution.editor.script.FunctionParametersPresenter;
import org.mule.tooling.ui.dfl.contribution.handlers.OpenFunctionBrowserHandler;
import org.mule.tooling.ui.widgets.dialog.ISimpleDialogEditorPresenter;
import org.mule.tooling.ui.widgets.dialog.SimpleEditorDialog;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.weave.v2.editor.FunctionDefinition;
import org.mule.weave.v2.editor.ImplicitInput;
import org.mule.weave.v2.ts.WeaveType;

public class OpenFunctionBrowserAction
extends Action {
    private final WeaveType selectedWeaveType;
    private final IMuleProject project;
    private GraphicalTreeNode<?> element;
    private TwoWayHandler twoWayHandler;
    private Viewer viewer;

    public OpenFunctionBrowserAction(WeaveType selectedWeaveType, TwoWayHandler twoWayHandler, IMuleProject project, GraphicalTreeNode<?> element, Viewer viewer) {
        super("Browse Functions... (" + BindingServiceHelper.getShortcut(OpenFunctionBrowserHandler.COMMAND_ID) + ")", ImagesHelper.getImageDescriptor((String)(ThemeUtils.getCurrentTheme().getDflImgFolder() + "fx-browser.png")));
        this.selectedWeaveType = selectedWeaveType;
        this.twoWayHandler = twoWayHandler;
        this.project = project;
        this.element = element;
        this.viewer = viewer;
    }

    public boolean isEnabled() {
        GraphicalTreeNode element;
        if (this.twoWayHandler.getEditor().haveErrors()) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return selection.isEmpty() || !GraphicalTreeNodeUtils.isUnresolvedMetadataNodeId((GraphicalTreeNode)(element = (GraphicalTreeNode)selection.getFirstElement()));
    }

    public void run() {
        AnalyticsRecordsFactory.single((String)Events.DW_FUNCTION_BROWSER_OPEN).track();
        this.showFunctionManager();
    }

    private void showFunctionManager() {
        DFLTextViewerUndoManager textViewerUndoManager = (DFLTextViewerUndoManager)this.twoWayHandler.getEditor().getViewer().getUndoManager();
        FunctionManagerPresenter controller = new FunctionManagerPresenter(this.project, this.selectedWeaveType);
        SimpleEditorDialog dialog = WidgetUtils.createSimpleEditorDialog(FunctionManagerComposite.class, (ISimpleDialogEditorPresenter)controller, (String)"Insert", (String)"Cancel");
        dialog.setSize(700, 600);
        dialog.setTitle("Functions");
        if (dialog.open() == 0) {
            this.showParametersEditor(textViewerUndoManager, controller);
        }
    }

    private void showParametersEditor(DFLTextViewerUndoManager textViewerUndoManager, FunctionManagerPresenter controller) {
        Optional<FunctionDefinition> selectedFunction = controller.getSelectedFunction();
        if (selectedFunction.isPresent()) {
            FunctionDefinition functionDefinition = selectedFunction.get();
            if (functionDefinition.params().length == 0) {
                this.trackApplyFunction(functionDefinition);
                textViewerUndoManager.beginCrossCompoundChange();
                this.twoWayHandler.assignFunctionDefinition(this.element, functionDefinition, Collections.emptyList(), Collections.emptyList());
                textViewerUndoManager.endCrossCompoundChange();
            } else {
                IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
                Optional<Expression> expression = this.twoWayHandler.assignedExpressionTo(selection);
                IDataSenseProvider dataSense = IDataSenseProvider.create((IMetaDataProvider)this.twoWayHandler.getInputMetadataProvider(), (IMetaDataProvider)this.twoWayHandler.getOutputMetadataProvider());
                String code = "";
                if (expression.isPresent()) {
                    Expression value = expression.get();
                    code = ScaffoldingHelper.toExpressionAssignmentString((Document)this.twoWayHandler.document(), (Expression)value);
                    ICompositeNode node = NodeModelUtils.getNode((EObject)value);
                    if (node != null) {
                        int offset = node.getOffset();
                        ImplicitInput availableContext = DataWeaveLanguageService.getInstance((IMuleProject)this.project).availableContext(this.twoWayHandler.getEditor().getDocument().getResourceURI(), (IXtextDocument)this.twoWayHandler.getEditor().getDocument(), dataSense, offset);
                        dataSense = new WeaveDataSenseProvider(availableContext, this.selectedWeaveType);
                    }
                } else {
                    dataSense = new OutputOverwriteDataSenseProvider(dataSense, this.selectedWeaveType);
                }
                FunctionParametersPresenter functionParametersPresenter = new FunctionParametersPresenter(functionDefinition, dataSense, this.twoWayHandler.getProject(), code);
                SimpleEditorDialog paramsEditor = WidgetUtils.createSimpleEditorDialog(FunctionParametersComposite.class, (ISimpleDialogEditorPresenter)functionParametersPresenter, (String)"Finish", (String)"Cancel");
                paramsEditor.setBackButton("Back To Functions");
                paramsEditor.setSize(700, 600);
                paramsEditor.setTitle("Parameters for: " + functionDefinition.nameIdentifier().localName().name());
                int open = paramsEditor.open();
                if (open == 0) {
                    this.trackApplyFunction(functionDefinition);
                    textViewerUndoManager.beginCrossCompoundChange();
                    this.twoWayHandler.assignFunctionDefinition(this.element, functionDefinition, functionParametersPresenter.getExpressions(), functionParametersPresenter.getImports());
                    textViewerUndoManager.endCrossCompoundChange();
                } else if (open == 14) {
                    this.showFunctionManager();
                }
            }
        }
    }

    private void trackApplyFunction(FunctionDefinition functionDefinition) {
        String name = functionDefinition.nameIdentifier().toString();
        String params = String.valueOf(functionDefinition.params().length);
        AnalyticsRecordsFactory.single((String)Events.DW_APPLY_FUNCTION, (String[])new String[]{"quick", "false", "function", name, "params", params}).track();
    }
}

