/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.datasense.IDataSenseProvider;
import org.mule.tooling.dfl.ui.ls.DataWeaveLanguageService;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.TwoWayHandler;
import org.mule.weave.v2.editor.ValidationMessages;

public class GraphicalEditorDocumentChange
implements IDocumentListener {
    private final TwoWayHandler twoWayHandler;

    GraphicalEditorDocumentChange(TwoWayHandler twoWayHandler) {
        this.twoWayHandler = twoWayHandler;
    }

    public void documentChanged(DocumentEvent event) {
        if (!this.twoWayHandler.isDirty()) {
            String content;
            IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
            if (muleProject == null) {
                return;
            }
            XtextSourceViewer sourceViewer = this.twoWayHandler.getSourceViewer();
            IDocument document = sourceViewer.getDocument();
            if (document != null && !(content = document.get()).trim().isEmpty()) {
                PropagationInfo propagationInfo = this.twoWayHandler.getPropagationProvider().getPropagationInfo();
                ValidationMessages messages = DataWeaveLanguageService.getInstance((IMuleProject)muleProject).validateScript(document, (IDataSenseProvider)IDataSenseProvider.create((PropagationInfo)propagationInfo), true);
                if (messages.errorMessage().length == 0) {
                    this.twoWayHandler.refreshGraphicalView();
                } else {
                    this.twoWayHandler.showInvalidIndicator();
                }
            }
        }
        this.twoWayHandler.cleanDirtyFlag();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }
}

