/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.ImportDirective;
import org.mule.tooling.dfl.ui.datasense.IDataSenseProvider;
import org.mule.tooling.dfl.ui.datasense.OutputOverwriteDataSenseProvider;
import org.mule.tooling.dfl.ui.ls.DataWeaveLanguageService;
import org.mule.tooling.ui.dfl.contribution.editor.script.AssignmentEditorComposite;
import org.mule.tooling.ui.dfl.contribution.editor.script.AssignmentEditorPresenter;
import org.mule.tooling.ui.dfl.contribution.editor.script.FunctionDefinitionPresenterUtils;
import org.mule.tooling.ui.dfl.contribution.editor.script.FunctionParametersComposite;
import org.mule.tooling.ui.dfl.contribution.editor.utils.DwDocumentationStyler;
import org.mule.tooling.ui.dfl.contribution.editor.utils.ScalaConverters;
import org.mule.tooling.ui.widgets.dialog.ISimpleDialogEditorPresenter;
import org.mule.weave.v2.editor.FunctionDefinition;
import org.mule.weave.v2.editor.FunctionParameterDefinition;
import org.mule.weave.v2.ts.AnyType;
import org.mule.weave.v2.ts.WeaveType;
import scala.Option;

public class FunctionParametersPresenter
implements ISimpleDialogEditorPresenter<FunctionParametersComposite> {
    private FunctionDefinition function;
    private IDataSenseProvider inputContext;
    private IMuleProject project;
    private List<Expression> expressions = new ArrayList<Expression>();
    private List<ImportDirective> imports = new ArrayList<ImportDirective>();
    private String firstParamCode;
    private Map<String, AssignmentEditorPresenter> editorsByParam = new HashMap<String, AssignmentEditorPresenter>();

    public FunctionParametersPresenter(FunctionDefinition function, IDataSenseProvider inputMetadata, IMuleProject project, String firstCode) {
        this.function = function;
        this.inputContext = inputMetadata;
        this.project = project;
        this.firstParamCode = firstCode;
    }

    public void handle(FunctionParametersComposite editor) {
        StringBuilder stringBuilder = this.buildFunctionLabel();
        editor.withTitle(stringBuilder.toString());
        editor.withDocumentation(DwDocumentationStyler.applyToHtml(DataWeaveLanguageService.toHtml((String)this.function.markdownDoc())));
        boolean first = true;
        FunctionParameterDefinition[] functionParameterDefinitionArray = this.function.params();
        int n = functionParameterDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            FunctionParameterDefinition param = functionParameterDefinitionArray[n2];
            String code = "";
            if (first && !param.defaultValue().isDefined()) {
                code = this.firstParamCode;
                first = false;
            }
            WeaveType outputType = (WeaveType)ScalaConverters.asJava(param.weaveType()).orElse(new AnyType());
            OutputOverwriteDataSenseProvider dataSenseProvider = new OutputOverwriteDataSenseProvider(this.inputContext, outputType);
            AssignmentEditorComposite createParamEditor = editor.createParamEditor(param.name());
            Option defaultValue = param.defaultValue();
            AssignmentEditorPresenter assignmentEditorPresenter = new AssignmentEditorPresenter(outputType, param.name(), this.project, code, (IDataSenseProvider)dataSenseProvider, defaultValue.isDefined() ? (String)defaultValue.get() : null);
            assignmentEditorPresenter.handle(createParamEditor);
            this.editorsByParam.put(param.name(), assignmentEditorPresenter);
            ++n2;
        }
    }

    private StringBuilder buildFunctionLabel() {
        return FunctionDefinitionPresenterUtils.buildFunctionSignatureLabel(this.function, this.function.params());
    }

    public boolean onSave() {
        FunctionParameterDefinition[] params;
        this.imports.clear();
        FunctionParameterDefinition[] functionParameterDefinitionArray = params = this.function.params();
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            FunctionParameterDefinition functionParameterDefinition = functionParameterDefinitionArray[n2];
            AssignmentEditorPresenter editorOf = this.editorsByParam.get(functionParameterDefinition.name());
            boolean onSave = editorOf.onSave();
            if (!onSave && functionParameterDefinition.defaultValue().isEmpty()) {
                return false;
            }
            Expression expression = editorOf.getExpression();
            if (expression != null) {
                this.expressions.add(expression);
                List<ImportDirective> importedModules = editorOf.getImports();
                this.imports.addAll(importedModules);
            } else if (functionParameterDefinition.defaultValue().isEmpty()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public List<ImportDirective> getImports() {
        return this.imports;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public boolean onCancel() {
        return true;
    }
}

