/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.ls.DataWeaveJarIndexer;
import org.mule.tooling.dfl.ui.ls.DataWeaveLanguageService;
import org.mule.tooling.ui.dfl.contribution.editor.script.FunctionManagerComposite;
import org.mule.tooling.ui.dfl.contribution.editor.utils.DwDocumentationStyler;
import org.mule.tooling.ui.widgets.dialog.ISimpleDialogEditorPresenter;
import org.mule.tooling.ui.widgets.tree.model.EmptyGraphicalChildrenProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.tree.model.IGraphicalChildrenProvider;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.weave.v2.editor.FunctionDefinition;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.ts.WeaveType;

public class FunctionManagerPresenter
implements ISimpleDialogEditorPresenter<FunctionManagerComposite> {
    private IMuleProject project;
    private FunctionManagerComposite editor;
    private WeaveType resultWeaveType;
    private FunctionDefinition selectedFunction;

    public FunctionManagerPresenter(IMuleProject project, WeaveType resultWeaveType) {
        this.project = project;
        this.resultWeaveType = resultWeaveType;
    }

    public void handle(final FunctionManagerComposite editor) {
        this.editor = editor;
        GraphicalTreeNode input = new GraphicalTreeNode("Root", "", null, (IGraphicalChildrenProvider)new ModulesChildProvider());
        editor.getTree().getViewer().setInput((Object)input);
        editor.getTree().getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object firstElementObject = selection.getFirstElement();
                if (firstElementObject instanceof GraphicalTreeNode) {
                    Optional moduleDocumentation;
                    GraphicalTreeNode firstElement = (GraphicalTreeNode)firstElementObject;
                    Object model = firstElement.getModel();
                    if (model instanceof FunctionDefinition) {
                        String documentation = ((FunctionDefinition)model).markdownDoc();
                        WidgetUtils.getDisplay().asyncExec(() -> editor.getBrowser().setText(DwDocumentationStyler.applyToHtml(DataWeaveLanguageService.toHtml((String)documentation))));
                    } else if (model instanceof NameIdentifier && (moduleDocumentation = FunctionManagerPresenter.this.getLanguageService().moduleDocumentation((NameIdentifier)model)).isPresent()) {
                        editor.getBrowser().setText(DwDocumentationStyler.applyToHtml((String)moduleDocumentation.get()));
                    }
                }
            }
        });
        editor.getTree().getViewer().expandToLevel(2);
        WidgetUtils.getDisplay().asyncExec(() -> {
            GraphicalTreeNode[] children = input.getChildren(10);
            if (children.length > 0) {
                editor.getTree().getViewer().setSelection((ISelection)new StructuredSelection((Object)children[0]), true);
            }
        });
    }

    public boolean onSave() {
        Object model;
        Object firstElement = this.editor.getTree().getViewer().getStructuredSelection().getFirstElement();
        if (firstElement instanceof GraphicalTreeNode && (model = ((GraphicalTreeNode)firstElement).getModel()) instanceof FunctionDefinition) {
            this.selectedFunction = (FunctionDefinition)model;
            return true;
        }
        return false;
    }

    public boolean onCancel() {
        return true;
    }

    public Optional<FunctionDefinition> getSelectedFunction() {
        return Optional.ofNullable(this.selectedFunction);
    }

    private DataWeaveLanguageService getLanguageService() {
        return DataWeaveLanguageService.getInstance((IMuleProject)this.project);
    }

    static /* synthetic */ WeaveType access$1(FunctionManagerPresenter functionManagerPresenter) {
        return functionManagerPresenter.resultWeaveType;
    }

    private class FunctionDefinitionChildProvider
    implements IGraphicalChildrenProvider<NameIdentifier> {
        private WeaveType actual;

        public FunctionDefinitionChildProvider(WeaveType actual) {
            this.actual = actual;
        }

        public List<GraphicalTreeNode<?>> getChildren(GraphicalTreeNode<NameIdentifier> parent) {
            FunctionDefinition[] availableModuleFunctions = FunctionManagerPresenter.this.getLanguageService().availableModuleFunctions((NameIdentifier)parent.getModel());
            return Stream.of(availableModuleFunctions).filter(f -> {
                if (f.returnType().isDefined()) {
                    WeaveType expected = (WeaveType)f.returnType().get();
                    return FunctionManagerPresenter.this.getLanguageService().canBeSubstituted(this.actual, expected);
                }
                return true;
            }).filter(f -> !this.isNativeFunction((FunctionDefinition)f)).map(f -> {
                String theName = f.nameIdentifier().localName().name();
                return new GraphicalTreeNode(theName, "", f, (IGraphicalChildrenProvider)new EmptyGraphicalChildrenProvider());
            }).collect(Collectors.toList());
        }

        private boolean isNativeFunction(FunctionDefinition f) {
            return "dw::Core::native".equals(f.nameIdentifier().name());
        }
    }

    private class ModulesChildProvider
    implements IGraphicalChildrenProvider<Object> {
        private ModulesChildProvider() {
        }

        public List<GraphicalTreeNode<?>> getChildren(GraphicalTreeNode<Object> parent) {
            Set modulesNames = DataWeaveJarIndexer.getInstance((IMuleProject)FunctionManagerPresenter.this.project).getModulesNames();
            return modulesNames.stream().sorted((a, b) -> a.name().compareTo(b.name())).filter(n -> !this.isInternalModule((NameIdentifier)n)).map(name -> new GraphicalTreeNode(name.name(), "", name, (IGraphicalChildrenProvider)new FunctionDefinitionChildProvider(FunctionManagerPresenter.this.resultWeaveType))).collect(Collectors.toList());
        }

        private boolean isInternalModule(NameIdentifier moduleName) {
            return moduleName.name().contains("::internal::");
        }
    }
}

