/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.dialogs.PatternFilter;
import org.mule.tooling.browser.BrowserProxy;
import org.mule.tooling.browser.IBrowser;
import org.mule.tooling.dfl.ui.graphical.WeaveUIConstants;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.RowHeightDefinition;
import org.mule.tooling.ui.dfl.contribution.editor.script.FunctionDefinitionPresenterUtils;
import org.mule.tooling.ui.widgets.search.LimitedLevelPatternFilter;
import org.mule.tooling.ui.widgets.tree.StudioFilteredTree;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeContentProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeLabelProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.utils.OsDetect;
import org.mule.weave.v2.editor.FunctionDefinition;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;

public class FunctionManagerComposite
extends Composite {
    private StudioFilteredTree tree;
    private IBrowser browser;

    public FunctionManagerComposite(Composite parent, int style) {
        super(parent, style);
        GridLayoutFactory.swtDefaults().applyTo((Composite)this);
        SashForm container = new SashForm((Composite)this, style);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        Composite treeContainer = new Composite((Composite)container, 2048);
        treeContainer.setBackground(WeaveUIConstants.WHITE);
        GridLayoutFactory.fillDefaults().margins(2, 2).applyTo(treeContainer);
        FunctionPatternFilter patternFilter = new FunctionPatternFilter(128);
        this.tree = new StudioFilteredTree(treeContainer, 66304, (PatternFilter)patternFilter){

            protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
                return new TreeViewer(parent, style){

                    protected void preservingSelection(Runnable updateCode) {
                        if (OsDetect.isMac() || OsDetect.isLinux()) {
                            updateCode.run();
                        } else {
                            super.preservingSelection(updateCode);
                        }
                    }
                };
            }
        };
        this.tree.setBackground(WeaveUIConstants.WHITE);
        this.tree.getViewer().getTree().addListener(41, (Listener)new RowHeightDefinition(20));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tree);
        this.tree.getViewer().setLabelProvider((IBaseLabelProvider)new FunctionTreeLabelProvider());
        this.tree.getViewer().setContentProvider((IContentProvider)new GraphicalTreeContentProvider());
        Composite browserContainer = new Composite((Composite)container, 2048);
        GridLayoutFactory.fillDefaults().applyTo(browserContainer);
        this.browser = BrowserProxy.createBrowser((Composite)browserContainer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.browser.getComposite());
    }

    public IBrowser getBrowser() {
        return this.browser;
    }

    public StudioFilteredTree getTree() {
        return this.tree;
    }

    private static class FunctionPatternFilter
    extends LimitedLevelPatternFilter {
        public FunctionPatternFilter(int recursionLevel) {
            super(recursionLevel);
            this.setIncludeLeadingWildcard(true);
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            boolean leafMatch = super.isLeafMatch(viewer, element);
            if (leafMatch) {
                return true;
            }
            if (element instanceof GraphicalTreeNode) {
                Object model = ((GraphicalTreeNode)element).getModel();
                if (model instanceof FunctionDefinition) {
                    String[] aliases;
                    String[] stringArray = aliases = ((FunctionDefinition)model).labels();
                    int n = aliases.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String aka = stringArray[n2];
                        if (this.wordMatches(aka)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                return false;
            }
            return false;
        }
    }

    private static class FunctionTreeLabelProvider
    extends GraphicalTreeLabelProvider {
        protected void renderText(ViewerCell cell, StyledString styledString, GraphicalTreeNode<?> element) {
            Object model = element.getModel();
            if (model instanceof NameIdentifier) {
                styledString.append(model.toString(), WeaveUIConstants.MODULE_STYLE);
            } else if (model instanceof FunctionDefinition) {
                FunctionDefinition functionDefinition = (FunctionDefinition)model;
                FunctionDefinitionPresenterUtils.buildFunctionSignatureLabel(styledString, functionDefinition, functionDefinition.params());
            }
        }
    }
}

