/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import org.eclipse.jface.viewers.StyledString;
import org.mule.tooling.dfl.ui.graphical.WeaveUIConstants;
import org.mule.weave.v2.editor.FunctionDefinition;
import org.mule.weave.v2.editor.FunctionParameterDefinition;
import org.mule.weave.v2.ts.WeaveType;
import scala.Option;

public class FunctionDefinitionPresenterUtils {
    public static void renderFunctionParameter(StyledString styledString, FunctionParameterDefinition param) {
        styledString.append(param.name(), WeaveUIConstants.VARIABLE_STYLE);
        styledString.append(": ", WeaveUIConstants.VARIABLE_STYLE);
        Option weaveType = param.weaveType();
        String weaveTypeLabel = FunctionDefinitionPresenterUtils.maybeWeaveTypeToString((Option<WeaveType>)weaveType);
        styledString.append(weaveTypeLabel, WeaveUIConstants.TYPE_STYLE);
        Option defaultValue = param.defaultValue();
        if (defaultValue.isDefined()) {
            styledString.append("=");
            String defaultValueText = (String)defaultValue.get();
            if (defaultValueText.startsWith("\"")) {
                styledString.append(defaultValueText, WeaveUIConstants.STRING_STYLE);
            } else if (defaultValueText.startsWith("f") || defaultValueText.startsWith("t")) {
                styledString.append(defaultValueText, WeaveUIConstants.KEYWORD_STYLE);
            } else {
                styledString.append(defaultValueText, WeaveUIConstants.NUMBER_STYLE);
            }
        }
    }

    public static void renderFunctionParameter(StringBuilder stringBuilder, FunctionParameterDefinition param) {
        stringBuilder.append(param.name());
        stringBuilder.append(": ");
        Option weaveType = param.weaveType();
        String weaveTypeLabel = FunctionDefinitionPresenterUtils.maybeWeaveTypeToString((Option<WeaveType>)weaveType);
        stringBuilder.append(weaveTypeLabel);
        Option defaultValue = param.defaultValue();
        if (defaultValue.isDefined()) {
            stringBuilder.append("=");
            String defaultValueText = (String)defaultValue.get();
            if (defaultValueText.startsWith("\"")) {
                stringBuilder.append(defaultValueText);
            } else if (defaultValueText.startsWith("f") || defaultValueText.startsWith("t")) {
                stringBuilder.append(defaultValueText);
            } else {
                stringBuilder.append(defaultValueText);
            }
        }
    }

    public static String maybeWeaveTypeToString(Option<WeaveType> weaveType) {
        String weaveTypeLabel = weaveType.isDefined() ? ((WeaveType)weaveType.get()).toString(false, true) : "Any";
        return weaveTypeLabel;
    }

    public static StringBuilder buildFunctionSignatureLabel(FunctionDefinition function, FunctionParameterDefinition ... params) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(function.nameIdentifier().localName().name());
        stringBuilder.append("(");
        int i = 0;
        FunctionParameterDefinition[] functionParameterDefinitionArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            FunctionParameterDefinition param = functionParameterDefinitionArray[n2];
            if (i > 0) {
                stringBuilder.append(", ");
            }
            FunctionDefinitionPresenterUtils.renderFunctionParameter(stringBuilder, param);
            ++i;
            ++n2;
        }
        stringBuilder.append("): ");
        stringBuilder.append(FunctionDefinitionPresenterUtils.maybeWeaveTypeToString((Option<WeaveType>)function.returnType()));
        return stringBuilder;
    }

    public static void buildFunctionSignatureLabel(StyledString styledString, FunctionDefinition function, FunctionParameterDefinition ... params) {
        styledString.append(function.nameIdentifier().localName().name());
        styledString.append("(");
        boolean first = true;
        FunctionParameterDefinition[] functionParameterDefinitionArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            FunctionParameterDefinition param = functionParameterDefinitionArray[n2];
            if (!first) {
                styledString.append(", ");
            } else {
                first = false;
            }
            FunctionDefinitionPresenterUtils.renderFunctionParameter(styledString, param);
            ++n2;
        }
        styledString.append("): ");
        styledString.append(FunctionDefinitionPresenterUtils.maybeWeaveTypeToString((Option<WeaveType>)function.returnType()), WeaveUIConstants.TYPE_STYLE);
    }
}

