/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import java.util.List;
import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;
import org.mule.tooling.dfl.ui.graphical.events.AutoMappingClickEvent;
import org.mule.tooling.dfl.ui.graphical.model.ITreeGraphicalMapping;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.util.StructureManager;
import org.mule.tooling.dfl.ui.graphical.util.TreeViewerHelper;
import org.mule.tooling.dfl.ui.utils.GraphicalTreeNodeUtils;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.TwoWayHandler;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.utils.eventbus.IEvent;

public class ExplodeMappingAction
extends Action {
    private TreeViewer viewer;
    private TwoWayHandler twoWayHandler;
    private MappingNode sourceMappingNode;
    private MappingNode targetMappingNode;

    public ExplodeMappingAction(TwoWayHandler twoWayHandler, TreeViewer viewer) {
        super("Explode mapping");
        this.viewer = viewer;
        this.twoWayHandler = twoWayHandler;
    }

    public boolean isEnabled() {
        boolean isSingleSelection;
        TreeItem leftItem = null;
        TreeItem rightItem = null;
        TreeItem[] selection = this.viewer.getTree().getSelection();
        boolean isSingleMapping = false;
        boolean bl = isSingleSelection = selection.length == 1;
        if (isSingleSelection) {
            TreeItem item = selection[0];
            List<ITreeGraphicalMapping> mappings = this.twoWayHandler.getMappings();
            int countOfMappings = 0;
            for (ITreeGraphicalMapping mapping : mappings) {
                if (item != mapping.getRightItem().getTreeItem()) continue;
                leftItem = mapping.getLeftItem().getTreeItem();
                rightItem = mapping.getRightItem().getTreeItem();
                if (leftItem == null || rightItem == null) continue;
                ++countOfMappings;
            }
            isSingleMapping = countOfMappings == 1;
        }
        Optional nodeOpt = TreeViewerHelper.getSelectedNode((ISelectionProvider)this.viewer);
        return isSingleSelection && nodeOpt.map(node -> !GraphicalTreeNodeUtils.isUnresolvedMetadataNodeId((GraphicalTreeNode)node)).orElse(false) != false && isSingleMapping && this.validateStructure(leftItem, rightItem);
    }

    private boolean validateStructure(TreeItem leftItem, TreeItem rightItem) {
        if (leftItem == null || rightItem == null) {
            return false;
        }
        GraphicalTreeNode sourceNode = (GraphicalTreeNode)leftItem.getData();
        GraphicalTreeNode targetNode = (GraphicalTreeNode)rightItem.getData();
        this.sourceMappingNode = new MappingNode(sourceNode);
        this.targetMappingNode = new MappingNode(targetNode);
        return this.sourceMappingNode.isObject() && this.targetMappingNode.isObject() && StructureManager.compareObjects((GraphicalTreeNode)sourceNode, (GraphicalTreeNode)targetNode);
    }

    public void run() {
        this.twoWayHandler.getMappingPainter().getEventBus().fireEvent((IEvent)new AutoMappingClickEvent(this.sourceMappingNode, this.targetMappingNode));
        this.twoWayHandler.getMappingPainter().hideButton();
    }
}

