/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import java.util.HashMap;
import java.util.Map;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.datasense.DwMetadataProvider;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.dfl.ui.input.UndefinedMetaDataProvider;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.InputTreeLiveDataProviderManager;
import org.mule.tooling.ui.modules.core.metadata.IPropagationInfoProvider;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageRowType;
import org.mule.tooling.utils.eventbus.EventBus;

public class EditorContext {
    private final IMuleProject project;
    private final IMessageFlowNode node;
    private final EventBus eventBus;
    private final IMetaDataProvider inputMetadataProvider;
    private final Map<MessageRowType, IMetaDataProvider> outputMetadata;
    private final IPropagationInfoProvider propagationProvider;
    private MuleConfiguration muleConfiguration;
    private InputTreeLiveDataProviderManager inputLiveDataProvider;

    public EditorContext(IMuleProject project, MuleConfiguration muleConfiguration, IMessageFlowNode node, EventBus eventBus, IPropagationInfoProvider propagationProvider, IMetaDataProvider inputMetadataProvider, IMetaDataProvider outputPayloadMetadataProvider) {
        this.project = project;
        this.muleConfiguration = muleConfiguration;
        this.node = node;
        this.eventBus = eventBus;
        this.propagationProvider = propagationProvider;
        this.inputMetadataProvider = inputMetadataProvider;
        this.outputMetadata = new HashMap<MessageRowType, IMetaDataProvider>(3);
        this.outputMetadata.put(MessageRowType.OUTPUT_PAYLOAD, outputPayloadMetadataProvider);
        DwMetadataProvider outputVariablesMetaDataProvider = DwMetadataProvider.createOutputMetaDataProvider((IMuleProject)project, (IMessageFlowNode)node, (IPropagationInfoProvider)propagationProvider, (MessageRowType)MessageRowType.OUTPUT_VARIABLES);
        DwMetadataProvider outputAttributesMetaDataProvider = DwMetadataProvider.createOutputMetaDataProvider((IMuleProject)project, (IMessageFlowNode)node, (IPropagationInfoProvider)propagationProvider, (MessageRowType)MessageRowType.OUTPUT_ATTRIBUTES);
        this.outputMetadata.put(MessageRowType.OUTPUT_VARIABLES, (IMetaDataProvider)outputVariablesMetaDataProvider);
        this.outputMetadata.put(MessageRowType.OUTPUT_ATTRIBUTES, (IMetaDataProvider)outputAttributesMetaDataProvider);
        this.inputLiveDataProvider = new InputTreeLiveDataProviderManager(this.getEventBus(), this.getInputMetadataProvider());
    }

    public InputTreeLiveDataProviderManager getInputLiveDataProvider() {
        return this.inputLiveDataProvider;
    }

    public IMuleProject getProject() {
        return this.project;
    }

    public IMessageFlowNode getNode() {
        return this.node;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public IMetaDataProvider getInputMetadataProvider() {
        return this.inputMetadataProvider;
    }

    public IMetaDataProvider getOutputMetadataProvider(MessageRowType type) {
        if (this.outputMetadata.containsKey(type)) {
            return this.outputMetadata.get(type);
        }
        return new UndefinedMetaDataProvider();
    }

    public IMetaDataProvider getOutputMetadataProvider() {
        return this.getOutputMetadataProvider(MessageRowType.OUTPUT_PAYLOAD);
    }

    public IPropagationInfoProvider getPropagationProvider() {
        return this.propagationProvider;
    }

    public MuleConfiguration getMuleConfiguration() {
        return this.muleConfiguration;
    }
}

