/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.ui.datasense.IDataSenseProvider;
import org.mule.tooling.dfl.ui.datasense.OutputOverwriteDataSenseProvider;
import org.mule.tooling.dfl.ui.datasense.WeaveDataSenseProvider;
import org.mule.tooling.dfl.ui.embedded.editor.DFLTextViewerUndoManager;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.dfl.ui.ls.DataWeaveLanguageService;
import org.mule.tooling.dfl.ui.scafflod.ScaffoldingHelper;
import org.mule.tooling.dfl.ui.utils.GraphicalTreeNodeUtils;
import org.mule.tooling.dfl.ui.utils.ImagesHelper;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.TwoWayHandler;
import org.mule.tooling.ui.dfl.contribution.editor.script.AssignmentEditorComposite;
import org.mule.tooling.ui.dfl.contribution.editor.script.AssignmentEditorPresenter;
import org.mule.tooling.ui.dfl.contribution.editor.script.BindingServiceHelper;
import org.mule.tooling.ui.dfl.contribution.handlers.EditFieldAssignmentHandler;
import org.mule.tooling.ui.widgets.dialog.ISimpleDialogEditorPresenter;
import org.mule.tooling.ui.widgets.dialog.SimpleEditorDialog;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.weave.v2.editor.ImplicitInput;
import org.mule.weave.v2.el.tooling.MuleWeaveToolingHelper;
import org.mule.weave.v2.ts.WeaveType;

public class EditAssignmentAction
extends Action {
    private Viewer viewer;
    private TwoWayHandler twoWayHandler;

    public EditAssignmentAction(TwoWayHandler twoWayHandler, Viewer viewer) {
        super("Edit field assignment...  (" + BindingServiceHelper.getShortcut(EditFieldAssignmentHandler.COMMAND_ID) + ")", ImagesHelper.getImageDescriptor((String)(ThemeUtils.getCurrentTheme().getDflImgFolder() + "edit-assignment.png")));
        this.viewer = viewer;
        this.twoWayHandler = twoWayHandler;
    }

    public boolean isEnabled() {
        GraphicalTreeNode element;
        if (this.twoWayHandler.getEditor().haveErrors()) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return selection.isEmpty() || !GraphicalTreeNodeUtils.isUnresolvedMetadataNodeId((GraphicalTreeNode)(element = (GraphicalTreeNode)selection.getFirstElement()));
    }

    public void run() {
        GraphicalTreeNode element;
        AnalyticsRecordsFactory.single((String)Events.DW_EDIT_ASSIGNMENT_OPEN).track();
        DFLTextViewerUndoManager textViewerUndoManager = (DFLTextViewerUndoManager)this.twoWayHandler.getEditor().getViewer().getUndoManager();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty() && !GraphicalTreeNodeUtils.isUnresolvedMetadataNodeId((GraphicalTreeNode)(element = (GraphicalTreeNode)selection.getFirstElement()))) {
            String localPart;
            MetadataType metadataType;
            Object model = element.getModel();
            if (model instanceof ObjectFieldType) {
                ObjectFieldType field = (ObjectFieldType)model;
                metadataType = field.getValue();
                localPart = field.getKey().getName().getLocalPart();
            } else if (model instanceof AttributeFieldType) {
                metadataType = ((AttributeFieldType)model).getValue();
                localPart = ((AttributeFieldType)model).getKey().getName().getLocalPart();
            } else if (model instanceof MetadataType) {
                metadataType = (MetadataType)model;
                localPart = this.twoWayHandler.getCurrentTarget().getLabel();
            } else {
                return;
            }
            DataWeaveLanguageService dwls = DataWeaveLanguageService.getInstance((IMuleProject)this.twoWayHandler.getProject());
            WeaveType selectedWeaveType = MuleWeaveToolingHelper.toWeaveType((MetadataType)metadataType);
            IDataSenseProvider dataSense = IDataSenseProvider.create((IMetaDataProvider)this.twoWayHandler.getInputMetadataProvider(), (IMetaDataProvider)this.twoWayHandler.getOutputMetadataProvider());
            String code = "";
            Optional<Expression> expression = this.twoWayHandler.assignedExpressionTo(selection);
            if (expression.isPresent()) {
                Expression value = expression.get();
                code = ScaffoldingHelper.toExpressionAssignmentString((Document)this.twoWayHandler.document(), (Expression)value);
                ICompositeNode node = NodeModelUtils.getNode((EObject)value);
                if (node != null) {
                    int offset = node.getOffset();
                    ImplicitInput availableContext = dwls.availableContext(this.twoWayHandler.getEditor().getDocument().getResourceURI(), (IXtextDocument)this.twoWayHandler.getEditor().getDocument(), dataSense, offset);
                    dataSense = new WeaveDataSenseProvider(availableContext, selectedWeaveType);
                }
            } else {
                dataSense = new OutputOverwriteDataSenseProvider(dataSense, selectedWeaveType);
            }
            AssignmentEditorPresenter controller = new AssignmentEditorPresenter(selectedWeaveType, localPart, this.twoWayHandler.getProject(), code, dataSense, "");
            SimpleEditorDialog dialog = WidgetUtils.createSimpleEditorDialog(AssignmentEditorComposite.class, (ISimpleDialogEditorPresenter)controller, (String)"Finish", (String)"Cancel");
            dialog.setTitle("Editing '" + localPart + "'");
            dialog.setSize(500, 200);
            if (dialog.open() == 0 && controller.hasChanged()) {
                textViewerUndoManager.beginCrossCompoundChange();
                this.twoWayHandler.assignExpression(element, controller.getExpression(), controller.getImports());
                textViewerUndoManager.endCrossCompoundChange();
                this.twoWayHandler.refreshGraphicalView();
                this.twoWayHandler.deselect();
                this.twoWayHandler.applyFormatter();
            }
        }
    }
}

