/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.tooling.dfl.dFL.AttributeElement;
import org.mule.tooling.dfl.ui.embedded.editor.DFLTextViewerUndoManager;
import org.mule.tooling.dfl.ui.graphical.view2code.MultipleKeyValuePairContainer;
import org.mule.tooling.dfl.ui.utils.GraphicalTreeNodeUtils;
import org.mule.tooling.dfl.ui.utils.ImagesHelper;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.TwoWayHandler;
import org.mule.tooling.ui.dfl.contribution.editor.script.BindingServiceHelper;
import org.mule.tooling.ui.dfl.contribution.handlers.RemoveFieldAssignmentHandler;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class DeleteAssignmentAction
extends Action {
    private Viewer viewer;
    private TwoWayHandler twoWayHandler;
    private Optional<MultipleKeyValuePairContainer> multipleKeyValuePairContainerOptional = Optional.empty();
    private Optional<AttributeElement> attributeSelection = Optional.empty();

    public DeleteAssignmentAction(TwoWayHandler twoWayHandler, Viewer viewer) {
        super("Remove field assignment (" + BindingServiceHelper.getShortcut(RemoveFieldAssignmentHandler.COMMAND_ID) + ")", ImagesHelper.getImageDescriptor((String)(ThemeUtils.getCurrentTheme().getDflImgFolder() + "delete-assignment.png")));
        this.viewer = viewer;
        this.twoWayHandler = twoWayHandler;
    }

    public boolean isEnabled() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            GraphicalTreeNode element = (GraphicalTreeNode)selection.getFirstElement();
            if (GraphicalTreeNodeUtils.isUnresolvedMetadataNodeId((GraphicalTreeNode)element)) {
                return false;
            }
            if (element.getModel() instanceof ObjectFieldType) {
                this.multipleKeyValuePairContainerOptional = this.twoWayHandler.performFindMultipleKeyValuePairWork(selection);
                return this.multipleKeyValuePairContainerOptional.isPresent() && !this.multipleKeyValuePairContainerOptional.get().isEmpty();
            }
            this.attributeSelection = this.twoWayHandler.performFindAttributeElement(selection);
            return this.attributeSelection.isPresent();
        }
        return false;
    }

    public void run() {
        DFLTextViewerUndoManager textViewerUndoManager = (DFLTextViewerUndoManager)this.twoWayHandler.getEditor().getViewer().getUndoManager();
        textViewerUndoManager.beginCrossCompoundChange();
        if (this.attributeSelection.isPresent()) {
            this.twoWayHandler.performDeleteAttributeAssignment(this.attributeSelection);
        } else {
            this.twoWayHandler.performDeleteKeyValuePairAssignment(this.multipleKeyValuePairContainerOptional);
        }
        textViewerUndoManager.endCrossCompoundChange();
        this.twoWayHandler.deselect();
        this.twoWayHandler.applyFormatter();
        this.twoWayHandler.refreshGraphicalView();
    }
}

