/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.validation.Issue;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.tooling.client.api.ComponentDataSenseNotification;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.DFLEditor;
import org.mule.tooling.dfl.ui.DFLExtendedActivator;
import org.mule.tooling.dfl.ui.datasense.IDataSenseProvider;
import org.mule.tooling.dfl.ui.embedded.editor.DFLEmbeddedEditor;
import org.mule.tooling.dfl.ui.graphical.MappingPainter;
import org.mule.tooling.dfl.ui.graphical.WeaveUIConstants;
import org.mule.tooling.dfl.ui.graphical.listener.IRedrawFunction;
import org.mule.tooling.dfl.ui.graphical.listener.RedrawSelectionChangedListener;
import org.mule.tooling.dfl.ui.graphical.listener.RedrawTreeViewerListener;
import org.mule.tooling.dfl.ui.graphical.listener.ScrollBarSelectionListener;
import org.mule.tooling.dfl.ui.input.DFLStudioFilteredTree;
import org.mule.tooling.dfl.ui.input.DefaultContextMenuProvider;
import org.mule.tooling.dfl.ui.utils.GraphicalTreeNodeUtils;
import org.mule.tooling.messageflow.events.IMetadataPropagationFinishedListener;
import org.mule.tooling.messageflow.events.IMetadataPropagationStartedListener;
import org.mule.tooling.messageflow.events.PropagationEventTypes;
import org.mule.tooling.properties.views.MulePropertiesView;
import org.mule.tooling.ui.dfl.contribution.DflPlugin;
import org.mule.tooling.ui.dfl.contribution.editor.action.CreateTargetAction;
import org.mule.tooling.ui.dfl.contribution.editor.action.EditTargetAction;
import org.mule.tooling.ui.dfl.contribution.editor.action.IEditorModelAware;
import org.mule.tooling.ui.dfl.contribution.editor.action.RemoveTargetAction;
import org.mule.tooling.ui.dfl.contribution.editor.action.SelectTransformTargetAction;
import org.mule.tooling.ui.dfl.contribution.editor.action.errors.WeaveErrorDisplay;
import org.mule.tooling.ui.dfl.contribution.editor.action.errors.WeaveErrorListProvider;
import org.mule.tooling.ui.dfl.contribution.editor.datasense.MetadataOperations;
import org.mule.tooling.ui.dfl.contribution.editor.datasense.TargetAwareDataSenseProvider;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.TwoWayHandler;
import org.mule.tooling.ui.dfl.contribution.editor.script.BindingServiceHelper;
import org.mule.tooling.ui.dfl.contribution.editor.script.ClearOutputTargetMetadataAction;
import org.mule.tooling.ui.dfl.contribution.editor.script.DFLEditorHelper;
import org.mule.tooling.ui.dfl.contribution.editor.script.DeleteAssignmentAction;
import org.mule.tooling.ui.dfl.contribution.editor.script.EditAssignmentAction;
import org.mule.tooling.ui.dfl.contribution.editor.script.EditorContext;
import org.mule.tooling.ui.dfl.contribution.editor.script.ExplodeMappingAction;
import org.mule.tooling.ui.dfl.contribution.editor.script.GraphicalEditorDocumentChange;
import org.mule.tooling.ui.dfl.contribution.editor.script.OpenFunctionBrowserAction;
import org.mule.tooling.ui.dfl.contribution.editor.script.RedoAction;
import org.mule.tooling.ui.dfl.contribution.editor.script.SashRedraw;
import org.mule.tooling.ui.dfl.contribution.editor.script.SetOutputTargetMetadataAction;
import org.mule.tooling.ui.dfl.contribution.editor.script.SplitterRedraw;
import org.mule.tooling.ui.dfl.contribution.editor.script.ToogleActionType;
import org.mule.tooling.ui.dfl.contribution.editor.script.ToogleControlAction;
import org.mule.tooling.ui.dfl.contribution.editor.script.ToogleControlManager;
import org.mule.tooling.ui.dfl.contribution.editor.script.ToogleSizeManager;
import org.mule.tooling.ui.dfl.contribution.editor.script.TransformationContextMenuManager;
import org.mule.tooling.ui.dfl.contribution.editor.script.TransformerEditorModel;
import org.mule.tooling.ui.dfl.contribution.editor.script.UndoAction;
import org.mule.tooling.ui.dfl.contribution.editor.script.WeaveGraphicalTreeLabelProvider;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.MessageTransformerEventTypes;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.NewEditorOpenedEvent;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.ToggleModeEvent;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.TogglePreviewEvent;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.InputContextMenuProvider;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.InputViewer;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.IMappingModel;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.ITransformationTarget;
import org.mule.tooling.ui.dfl.contribution.editor.script.output.OutputPreviewController;
import org.mule.tooling.ui.dfl.contribution.editor.script.output.OutputPreviewEditor;
import org.mule.tooling.ui.dfl.contribution.editor.script.output.SampleDataValidator;
import org.mule.tooling.ui.dfl.contribution.handlers.EditFieldAssignmentHandler;
import org.mule.tooling.ui.dfl.contribution.handlers.InputSearchHandler;
import org.mule.tooling.ui.dfl.contribution.handlers.OpenFunctionBrowserHandler;
import org.mule.tooling.ui.dfl.contribution.handlers.OutputSearchHandler;
import org.mule.tooling.ui.dfl.contribution.handlers.RedoHandler;
import org.mule.tooling.ui.dfl.contribution.handlers.RemoveFieldAssignmentHandler;
import org.mule.tooling.ui.dfl.contribution.handlers.SearchHandler;
import org.mule.tooling.ui.dfl.contribution.handlers.SourceOnlyHandler;
import org.mule.tooling.ui.dfl.contribution.handlers.SourceWithGraphicsHandler;
import org.mule.tooling.ui.dfl.contribution.handlers.SourceWithTreeHandler;
import org.mule.tooling.ui.dfl.contribution.handlers.TogglePreviewHandler;
import org.mule.tooling.ui.dfl.contribution.handlers.UndoHandler;
import org.mule.tooling.ui.dfl.contribution.widget.DualCodePreviewContainer;
import org.mule.tooling.ui.splitter.Splitter;
import org.mule.tooling.ui.splitter.handlers.DefaultSashHandler;
import org.mule.tooling.ui.splitter.handlers.LeftSashHandler;
import org.mule.tooling.ui.splitter.handlers.RightSashHandler;
import org.mule.tooling.ui.widgets.action.DisposableToolbarManager;
import org.mule.tooling.ui.widgets.errors.ErrorManager;
import org.mule.tooling.ui.widgets.listener.IdleDocumentEventListener;
import org.mule.tooling.ui.widgets.search.LimitedLevelPatternFilter;
import org.mule.tooling.ui.widgets.toolbar.LabelControlContribution;
import org.mule.tooling.ui.widgets.tree.StudioFilteredTree;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeContentProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.utils.OsDetect;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.mule.tooling.weave.engine.WeaveEngineHelperManager;
import org.mule.weave.v2.el.tooling.MuleWeaveToolingHelper;
import org.mule.weave.v2.ts.WeaveType;

public class DataWeaveEditor
extends Composite
implements IEditorModelAware {
    private static final String METADATA_GROUP_NAME = "METADATA";
    private static final String TRANSFORMATIONS_GROUP_NAME = "Transformations";
    private static final String ASSIGNMENT_GROUP_NAME = "Assignment";
    private static final String METADATA_PROPAGATION_ISSUE_CODE = "Metadata Propagation";
    public static final int RECURSION_LEVEL = 8;
    private EditorContext context;
    private IMappingModel transformerModel;
    private Composite editorsComposite;
    private StackLayout graphicalEditorLayout;
    private Map<ITransformationTarget, TransformerEditorModel> editors;
    private ITransformationTarget currentTarget;
    private ErrorManager<Document, Issue> errorManager;
    private EventBusHelper helper;
    private ToogleActionType currentToogleType;
    private InputViewer inputViewer;
    private ToolBarManager layoutToolbar;
    private ToolBarManager targetToolBar;
    private EventBusHelper eventBusHelper = new EventBusHelper();
    private Map<String, AbstractHandler> handlers = new HashMap<String, AbstractHandler>();
    private List<IHandlerActivation> handlersActivation;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private EditAssignmentAction editFieldAssignmentAction;
    private DeleteAssignmentAction deleteFieldAssignment;
    private StudioFilteredTree outputTree;
    private TwoWayHandler twoWayHandler;

    public DataWeaveEditor(Composite parent, IMappingModel transformerModel, EditorContext context) {
        super(parent, 0);
        this.handlers.put("org.mule.tooling.ui.dfl.contribution.commands.undoCommand", new UndoHandler(this));
        this.handlers.put("org.mule.tooling.ui.dfl.contribution.commands.redoCommand", new RedoHandler(this));
        this.handlers.put("org.mule.tooling.ui.dfl.contribution.commands.searchCommand", new SearchHandler(this));
        this.handlers.put("org.mule.tooling.ui.dfl.contribution.commands.turnOnOffPreviewCommand", new TogglePreviewHandler(this));
        this.handlers.put(EditFieldAssignmentHandler.COMMAND_ID, new EditFieldAssignmentHandler(this));
        this.handlers.put(RemoveFieldAssignmentHandler.COMMAND_ID, new RemoveFieldAssignmentHandler(this));
        this.handlers.put(OpenFunctionBrowserHandler.COMMAND_ID, new OpenFunctionBrowserHandler(this));
        this.handlers.put("org.mule.tooling.ui.dfl.contribution.commands.sourceOnlyCommand", new SourceOnlyHandler(this));
        this.handlers.put("org.mule.tooling.ui.dfl.contribution.commands.sourceWithTreeCommand", new SourceWithTreeHandler(this));
        this.handlers.put("org.mule.tooling.ui.dfl.contribution.commands.sourceWithGraphicsCommand", new SourceWithGraphicsHandler(this));
        this.handlers.put("org.mule.tooling.ui.dfl.contribution.commands.inputSearchCommand", new InputSearchHandler(this));
        this.handlers.put("org.mule.tooling.ui.dfl.contribution.commands.outputSearchCommand", new OutputSearchHandler(this));
        this.handlersActivation = new ArrayList<IHandlerActivation>(this.handlers.size());
        this.context = context;
        this.transformerModel = transformerModel;
        this.undoAction = new UndoAction(this);
        this.redoAction = new RedoAction(this);
        this.editors = new HashMap<ITransformationTarget, TransformerEditorModel>();
        this.errorManager = new ErrorManager();
        this.currentToogleType = this.getDefaultAction();
        this.helper = new EventBusHelper();
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo((Composite)this);
        this.createControls(this);
        this.addListeners();
        context.getEventBus().registerUIThreadListener(MessageTransformerEventTypes.ON_INPUT_LIVE_DATA_UPDATED, (selector, value) -> {
            TwoWayHandler currentTwoWayHandler = this.getCurrentTwoWayHandler();
            if (currentTwoWayHandler != null) {
                currentTwoWayHandler.updateInputTreeLabels();
            }
        });
        context.getEventBus().registerUIThreadListener(MessageTransformerEventTypes.ON_OUTPUT_LIVE_DATA_UPDATED, () -> {
            TwoWayHandler currentTwoWayHandler = this.getCurrentTwoWayHandler();
            if (currentTwoWayHandler != null) {
                currentTwoWayHandler.updateOutputTreeLabels();
            }
        });
        if (context.getPropagationProvider().isPropagationAvailable()) {
            this.refreshMetadataTrees();
        } else {
            TwoWayHandler twoWayHandler = this.getCurrentTwoWayHandler();
            if (twoWayHandler != null) {
                MetadataOperations.onPropagationStarted(twoWayHandler);
            }
        }
        this.addDisposeListener(event -> WeaveEngineHelperManager.invalidateToolingAppFor((IMuleProject)context.getProject()));
        IHandlerService handlerService = (IHandlerService)MulePropertiesView.get().getSite().getService(IHandlerService.class);
        for (Map.Entry<String, AbstractHandler> entry : this.handlers.entrySet()) {
            IHandlerActivation handlerActivation = handlerService.activateHandler(entry.getKey(), (IHandler)entry.getValue());
            this.handlersActivation.add(handlerActivation);
        }
        ThemeUtils.setCssClass((Object)this, (String)"DataWeave");
    }

    public void setTargetToolBar(ToolBarManager targetToolBar) {
        this.targetToolBar = targetToolBar;
    }

    public void setLayoutToolbar(ToolBarManager layoutToolbar) {
        this.layoutToolbar = layoutToolbar;
    }

    public UndoAction getUndoAction() {
        return this.undoAction;
    }

    public RedoAction getRedoAction() {
        return this.redoAction;
    }

    public EditorContext getContext() {
        return this.context;
    }

    private ToogleActionType getDefaultAction() {
        return DflPlugin.getDefaultToogleMode();
    }

    public Map<ITransformationTarget, TransformerEditorModel> getEditors() {
        return this.editors;
    }

    private void addListeners() {
        this.helper.registerListener(this.context.getEventBus(), MessageTransformerEventTypes.ON_TRANSFORMATION_REMOVED, this::onTransformationRemoved);
        this.helper.registerUIListener(this.context.getEventBus(), MessageTransformerEventTypes.ON_TRANSFORMATION_SELECTED, target -> {
            this.openEditor(target);
            this.refreshTwoWayHandler();
        });
        this.helper.registerUIListener(this.context.getEventBus(), MessageTransformerEventTypes.ON_TRANSFORMATION_ADDED, target -> {
            this.openEditor(target);
            this.refreshTwoWayHandler();
        });
        this.helper.registerListener(this.context.getEventBus(), MessageTransformerEventTypes.ON_TRANSFORMATION_MODIFIED, target -> this.editors.get(target).getTwoWayHandler().refreshGraphicalView());
        this.helper.registerListener(this.context.getEventBus(), MessageTransformerEventTypes.ON_TOOGLE_MODE, toogledType -> {
            ToogleActionType toogleActionType = this.currentToogleType = toogledType;
        });
        this.helper.registerListener(MuleCorePlugin.getEventBus(), PropagationEventTypes.ON_METADATA_PROPAGATION_FINISHED, (IEventHandler)((IMetadataPropagationFinishedListener)propagationInfo -> {
            DFLEmbeddedEditor currentEditor = this.getCurrentEditor();
            if (currentEditor != null) {
                XtextDocument currentDocument = currentEditor.getDocument();
                this.errorManager.deleteAll((Object)currentDocument, issue -> METADATA_PROPAGATION_ISSUE_CODE.equals(issue.getCode()));
                ArrayList<Issue.IssueImpl> newIssues = new ArrayList<Issue.IssueImpl>();
                if (propagationInfo.hasErrors()) {
                    for (ComponentDataSenseNotification componentDataSenseNotification : propagationInfo.getNotifcations()) {
                        if (!componentDataSenseNotification.isError()) continue;
                        Issue.IssueImpl issue2 = new Issue.IssueImpl();
                        issue2.setSyntaxError(false);
                        issue2.setSeverity(Severity.ERROR);
                        issue2.setCode(METADATA_PROPAGATION_ISSUE_CODE);
                        issue2.setMessage(componentDataSenseNotification.getMessage());
                        issue2.setData(new String[]{componentDataSenseNotification.getReason()});
                        newIssues.add(issue2);
                    }
                }
                for (Issue issue2 : newIssues) {
                    this.errorManager.addIssue((Object)currentDocument, (Object)issue2);
                }
            }
        }));
        this.helper.registerUIListener(MuleCorePlugin.getEventBus(), PropagationEventTypes.ON_METADATA_PROPAGATION_FINISHED, (IEventHandler)((IMetadataPropagationFinishedListener)propagationInfo -> this.refreshTwoWayHandler()));
        this.helper.registerUIListener(MuleCorePlugin.getEventBus(), MessageTransformerEventTypes.ON_OUTPUT_METADATA_UPDATED, this::refreshTwoWayHandler);
        this.helper.registerUIListener(MuleCorePlugin.getEventBus(), PropagationEventTypes.ON_METADATA_PROPAGATION_STARTED, (IEventHandler)((IMetadataPropagationStartedListener)entity -> {
            TwoWayHandler twoWayHandler;
            if (this.context.getNode() == entity && (twoWayHandler = this.getCurrentTwoWayHandler()) != null) {
                MetadataOperations.onPropagationStarted(twoWayHandler);
            }
        }));
        this.helper.unregisterWith((Widget)this);
    }

    private void onTransformationRemoved(ITransformationTarget target) {
        DFLEmbeddedEditor sideEditor;
        TransformerEditorModel model = this.editors.get(target);
        Composite parent = model.getParent();
        if (parent != null && !parent.isDisposed()) {
            this.getShell().setFocus();
            parent.dispose();
        }
        if ((sideEditor = model.getEditor()) != null) {
            sideEditor.cleanDisposeListener();
        }
        model.getTwoWayHandler().dispose();
        this.editors.remove(target);
        if (target.equals(this.currentTarget) && !this.transformerModel.getTargets().isEmpty()) {
            ITransformationTarget firstTarget = this.transformerModel.getTargets().get(0);
            this.editors.remove(firstTarget);
            this.openEditor(firstTarget);
            this.refreshTwoWayHandler();
        }
    }

    public void openEditor(ITransformationTarget target) {
        Composite parent = null;
        parent = this.editors.containsKey(target) ? this.editors.get(target).getParent() : this.createEditor(target);
        this.currentTarget = target;
        this.graphicalEditorLayout.topControl = parent;
        this.editorsComposite.layout(true);
        this.context.getEventBus().fireEvent((IEvent)new ToggleModeEvent(this.currentToogleType));
    }

    public void doSave() {
        this.saveTargetSources();
    }

    public void doClose(boolean saveTargetSources) {
        if (saveTargetSources) {
            this.saveTargetSources();
        }
        this.eventBusHelper.unregister();
        for (IHandlerActivation handlerActivation : this.handlersActivation) {
            handlerActivation.getHandlerService().deactivateHandler(handlerActivation);
        }
    }

    public void refresh() {
        if (this.isMappingsActive()) {
            this.editors.get(this.currentTarget).getTwoWayHandler().refresh();
            this.inputViewer.refresh();
        }
    }

    public void togglePreview() {
        if (this.currentTarget != null && this.editors.containsKey(this.currentTarget)) {
            DualCodePreviewContainer dualContainer;
            dualContainer.setPreviewEnabled(!(dualContainer = this.editors.get(this.currentTarget).getDualContainer()).isPreviewEnabled());
            this.context.getEventBus().fireEvent((IEvent)new TogglePreviewEvent());
        }
    }

    public void showSourceOnly() {
        if (this.currentTarget != null && this.editors.containsKey(this.currentTarget)) {
            DualCodePreviewContainer dualContainer = this.editors.get(this.currentTarget).getDualContainer();
            dualContainer.getToogleControlManager().getShowOnlyCode().run();
        }
    }

    public void showSourceWithTree() {
        if (this.currentTarget != null && this.editors.containsKey(this.currentTarget)) {
            DualCodePreviewContainer dualContainer = this.editors.get(this.currentTarget).getDualContainer();
            dualContainer.getToogleControlManager().getHideMappings().run();
        }
    }

    public void showSourceWithGraphics() {
        if (this.currentTarget != null && this.editors.containsKey(this.currentTarget)) {
            DualCodePreviewContainer dualContainer = this.editors.get(this.currentTarget).getDualContainer();
            dualContainer.getToogleControlManager().getShowFullMapping().run();
        }
    }

    public void assignFocusToInputSearch() {
        if (this.currentTarget != null && this.editors.containsKey(this.currentTarget)) {
            TwoWayHandler twoWayHandler = this.editors.get(this.currentTarget).getTwoWayHandler();
            twoWayHandler.getMappingPainter().getLeftFilteredTree().getFilterControl().setFocus();
        }
    }

    public void assignFocusToOutputSearch() {
        if (this.currentTarget != null && this.editors.containsKey(this.currentTarget)) {
            TwoWayHandler twoWayHandler = this.editors.get(this.currentTarget).getTwoWayHandler();
            twoWayHandler.getMappingPainter().getRightFilteredTree().getFilterControl().setFocus();
        }
    }

    @Override
    public DFLEmbeddedEditor getCurrentEditor() {
        if (this.currentTarget != null && this.editors.containsKey(this.currentTarget)) {
            return this.editors.get(this.currentTarget).getEditor();
        }
        return null;
    }

    @Override
    public TwoWayHandler getCurrentTwoWayHandler() {
        if (this.currentTarget != null && this.editors.containsKey(this.currentTarget)) {
            return this.editors.get(this.currentTarget).getTwoWayHandler();
        }
        return null;
    }

    @Override
    public ITransformationTarget getCurrentTarget() {
        return this.currentTarget;
    }

    @Override
    public Optional<DFLEmbeddedEditor> getEditor(ITransformationTarget target) {
        if (this.editors.containsKey(target)) {
            return Optional.of(this.editors.get(target).getEditor());
        }
        return Optional.empty();
    }

    @Override
    public Optional<TransformerEditorModel> getEditorModel(ITransformationTarget target) {
        if (this.editors.containsKey(target)) {
            return Optional.of(this.editors.get(target));
        }
        return Optional.empty();
    }

    public ToogleActionType getCurrentToogleType() {
        return this.currentToogleType;
    }

    private boolean isControlOrChildFocused(Control control) {
        if (control.isDisposed()) {
            return false;
        }
        if (control.isFocusControl()) {
            return true;
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control children = controlArray[n2];
                if (this.isControlOrChildFocused(children)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void dispose() {
        if (this.isControlOrChildFocused((Control)this)) {
            this.getShell().setFocus();
        }
        for (Map.Entry<ITransformationTarget, TransformerEditorModel> pair : this.editors.entrySet()) {
            ITransformationTarget target = pair.getKey();
            target.dispose();
            TransformerEditorModel transformerEditorModel = pair.getValue();
            transformerEditorModel.getEditor().cleanDisposeListener();
            transformerEditorModel.getDualContainer().dispose();
            transformerEditorModel.getParent().dispose();
        }
        this.editors.clear();
        super.dispose();
    }

    private void createControls(Composite parent) {
        this.editorsComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.editorsComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.editorsComposite);
        this.graphicalEditorLayout = new StackLayout();
        this.editorsComposite.setLayout((Layout)this.graphicalEditorLayout);
    }

    private Composite createEditor(ITransformationTarget target) {
        TargetAwareDataSenseProvider datasenseProvider = new TargetAwareDataSenseProvider(this.context.getInputMetadataProvider(), target, this.context.getOutputMetadataProvider());
        Splitter splitter = this.createSplitter();
        Composite inputWrapper = new Composite((Composite)splitter, 0);
        inputWrapper.setBackground(WeaveUIConstants.WHITE);
        GridLayoutFactory.fillDefaults().applyTo(inputWrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)inputWrapper);
        this.inputViewer = this.createInputView(inputWrapper, splitter);
        StudioFilteredTree inputTree = this.inputViewer.getInputMetadataTree();
        InputContextMenuProvider inputContextMenuProvider = new InputContextMenuProvider(this.context, this.inputViewer, this.transformerModel);
        inputContextMenuProvider.provideContextMenuFor((Viewer)inputTree.getViewer());
        Composite mappingPainterWrapper = new Composite((Composite)splitter, 4);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mappingPainterWrapper);
        mappingPainterWrapper.setLayout((Layout)new FillLayout());
        Composite outputWrapper = new Composite((Composite)splitter, 0);
        outputWrapper.setBackground(WeaveUIConstants.WHITE);
        GridLayoutFactory.fillDefaults().applyTo(outputWrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)outputWrapper);
        this.outputTree = this.createOutputViewer(outputWrapper, splitter);
        EventBus eventBus = new EventBus();
        MappingPainter mappingPainter = this.createMappingPainter(mappingPainterWrapper, inputTree, this.outputTree, splitter, eventBus);
        SearchJobHandler jobHandler = new SearchJobHandler(mappingPainter);
        ((DFLStudioFilteredTree)inputTree).getRefreshJob().addJobChangeListener((IJobChangeListener)jobHandler);
        ((DFLStudioFilteredTree)this.outputTree).getRefreshJob().addJobChangeListener((IJobChangeListener)jobHandler);
        Composite dualWrapper = new Composite((Composite)splitter, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)dualWrapper);
        dualWrapper.setLayout((Layout)new FillLayout(512));
        DualCodePreviewContainer dualContainer = this.createDualContainer(dualWrapper, splitter, inputWrapper, outputWrapper, mappingPainterWrapper, target);
        DFLEmbeddedEditor codeEditor = this.createCodeEditor((Composite)dualContainer, (IDataSenseProvider)datasenseProvider, target);
        codeEditor.getViewer().getControl().setBackground(DFLEditor.WHITE);
        XtextDocument document = codeEditor.getDocument();
        SettableFuture futureDocument = SettableFuture.create();
        futureDocument.set((Object)document);
        SampleDataValidator sampleDataValidator = new SampleDataValidator(this.context);
        OutputPreviewEditor previewEditor = new OutputPreviewEditor((Composite)dualContainer, this.context, this.inputViewer, this, sampleDataValidator, document);
        OutputPreviewController outputPreviewController = new OutputPreviewController(this.context, (SettableFuture<IXtextDocument>)futureDocument, this.transformerModel, dualContainer, this.errorManager, sampleDataValidator);
        this.eventBusHelper.addAllHandler(outputPreviewController.handle(previewEditor, codeEditor));
        this.twoWayHandler = new TwoWayHandler(codeEditor, mappingPainter, this.context, inputContextMenuProvider, this.errorManager, target, this.transformerModel, eventBus);
        document.addDocumentListener((IDocumentListener)new IdleDocumentEventListener(this.getDelayTime(), (IDocumentListener)new GraphicalEditorDocumentChange(this.twoWayHandler), (Control)splitter));
        splitter.setWeights(new int[]{18, 16, 18, 48});
        this.context.getEventBus().fireEvent((IEvent)new NewEditorOpenedEvent(target, (SettableFuture<IXtextDocument>)futureDocument, codeEditor));
        DefaultContextMenuProvider contextMenuProvider = DefaultContextMenuProvider.createContextMenu((StructuredViewer)this.outputTree.getViewer());
        contextMenuProvider.addGroup(ASSIGNMENT_GROUP_NAME);
        contextMenuProvider.addAction((Action)new ExplodeMappingAction(this.twoWayHandler, this.outputTree.getViewer()), ASSIGNMENT_GROUP_NAME);
        this.deleteFieldAssignment = new DeleteAssignmentAction(this.twoWayHandler, (Viewer)this.outputTree.getViewer());
        contextMenuProvider.addAction((Action)this.deleteFieldAssignment, ASSIGNMENT_GROUP_NAME);
        this.editFieldAssignmentAction = new EditAssignmentAction(this.twoWayHandler, (Viewer)this.outputTree.getViewer());
        contextMenuProvider.addAction((Action)this.editFieldAssignmentAction, ASSIGNMENT_GROUP_NAME);
        contextMenuProvider.addGroup(TRANSFORMATIONS_GROUP_NAME);
        MenuManager transformations = new MenuManager("Apply Transformation");
        transformations.setRemoveAllWhenShown(true);
        transformations.addMenuListener((IMenuListener)new TransformationContextMenuManager(this.twoWayHandler, (Viewer)this.outputTree.getViewer()));
        contextMenuProvider.addSubMenu(transformations, TRANSFORMATIONS_GROUP_NAME);
        contextMenuProvider.addGroup(METADATA_GROUP_NAME);
        contextMenuProvider.addAction((Action)new SetOutputTargetMetadataAction(this.transformerModel, this.twoWayHandler), METADATA_GROUP_NAME);
        contextMenuProvider.addAction((Action)new ClearOutputTargetMetadataAction(this.transformerModel, this.twoWayHandler), METADATA_GROUP_NAME);
        this.editors.put(target, new TransformerEditorModel((Composite)splitter, codeEditor, dualContainer, this.twoWayHandler));
        return splitter;
    }

    public void editFieldAssignment() {
        if (this.editFieldAssignmentAction != null && this.editFieldAssignmentAction.isEnabled()) {
            this.editFieldAssignmentAction.run();
        }
    }

    public void applyFunctionToField() {
        GraphicalTreeNode element;
        IStructuredSelection selection = (IStructuredSelection)this.outputTree.getViewer().getSelection();
        IMuleProject project = this.context.getProject();
        if (!selection.isEmpty() && !GraphicalTreeNodeUtils.isUnresolvedMetadataNodeId((GraphicalTreeNode)(element = (GraphicalTreeNode)selection.getFirstElement()))) {
            MetadataType metadataType;
            Object model = element.getModel();
            if (model instanceof ObjectFieldType) {
                ObjectFieldType field = (ObjectFieldType)model;
                metadataType = field.getValue();
            } else if (model instanceof AttributeFieldType) {
                metadataType = ((AttributeFieldType)model).getValue();
            } else if (model instanceof MetadataType) {
                metadataType = (MetadataType)model;
            } else {
                return;
            }
            WeaveType selectedWeaveType = MuleWeaveToolingHelper.toWeaveType((MetadataType)metadataType);
            new OpenFunctionBrowserAction(selectedWeaveType, this.twoWayHandler, project, element, (Viewer)this.outputTree.getViewer()).run();
        }
    }

    public void removeFieldAssignment() {
        if (this.deleteFieldAssignment != null && this.deleteFieldAssignment.isEnabled()) {
            this.deleteFieldAssignment.run();
        }
    }

    private DualCodePreviewContainer createDualContainer(Composite dualWrapper, Splitter splitter, Composite inputWrapper, Composite outputWrapper, Composite mappingsWrapper, ITransformationTarget currentTarget) {
        Composite toolbarContainer;
        Composite codeContainer = new Composite(dualWrapper, 4);
        GridLayoutFactory.fillDefaults().margins(0, 0).extendedMargins(0, 0, 0, 0).spacing(0, 0).applyTo(codeContainer);
        codeContainer.setBackground(WeaveUIConstants.WHITE);
        if (this.layoutToolbar == null || this.targetToolBar == null) {
            toolbarContainer = new Composite(codeContainer, 8);
            GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(7, 0, 0, 0).applyTo(toolbarContainer);
            this.configureLayoutDataForToolbar(toolbarContainer);
            toolbarContainer.setBackground(WeaveUIConstants.WHITE);
        } else {
            toolbarContainer = null;
        }
        ToolBarManager targetToolbar = this.createTargetToolBar(toolbarContainer);
        DisposableToolbarManager targetToolbarManager = new DisposableToolbarManager((IToolBarManager)targetToolbar);
        if (this.transformerModel.supportsMultipleTargets()) {
            targetToolbarManager.add((IContributionItem)new LabelControlContribution("Output"));
            targetToolbarManager.add((IAction)new SelectTransformTargetAction((Composite)targetToolbar.getControl(), this.transformerModel, this, this.context, currentTarget));
            targetToolbarManager.add((IAction)new CreateTargetAction(this.transformerModel, this.context.getProject()));
            targetToolbarManager.add((IAction)new EditTargetAction(this.transformerModel, this.context, this, currentTarget));
            targetToolbarManager.add((IAction)new RemoveTargetAction((Composite)targetToolbar.getControl(), this.transformerModel, this.context, currentTarget));
        }
        WeaveErrorDisplay errorDisplay = new WeaveErrorDisplay((IToolBarManager)targetToolbarManager, new WeaveErrorListProvider(this.transformerModel, this, this.errorManager), this.errorManager);
        errorDisplay.setAmountOfIssuesOnLabel(this.targetToolBar == null);
        ActionContributionItem errorContributionItem = new ActionContributionItem((IAction)errorDisplay);
        errorContributionItem.setMode(ActionContributionItem.MODE_FORCE_TEXT | 0x20000);
        targetToolbarManager.add((IContributionItem)errorContributionItem);
        targetToolbarManager.update(true);
        ToolBarManager layoutItemsToolbar = this.createLayoutToolbar(toolbarContainer);
        DisposableToolbarManager layoutToolbarManager = new DisposableToolbarManager((IToolBarManager)layoutItemsToolbar);
        ToogleControlAction showFullMapping = new ToogleControlAction(ToogleActionType.MAPPING_VIEW, splitter, this.context.getEventBus(), this);
        showFullMapping.setControls2Show(inputWrapper, mappingsWrapper, outputWrapper, dualWrapper);
        showFullMapping.setChecked(true);
        layoutToolbarManager.add((IAction)showFullMapping);
        ToogleControlAction hideMappings = new ToogleControlAction(ToogleActionType.TWO_PANE_VIEW, splitter, this.context.getEventBus(), this);
        hideMappings.setControls2Hide(mappingsWrapper);
        hideMappings.setControls2Show(inputWrapper, outputWrapper, dualWrapper);
        layoutToolbarManager.add((IAction)hideMappings);
        ToogleControlAction showOnlyCode = new ToogleControlAction(ToogleActionType.SOURCE_VIEW, splitter, this.context.getEventBus(), this);
        if (DflPlugin.hideInputOnSourceOnlyView().booleanValue()) {
            showOnlyCode.setControls2Hide(mappingsWrapper, outputWrapper, inputWrapper);
            showOnlyCode.setControls2Show(dualWrapper);
        } else {
            showOnlyCode.setControls2Hide(mappingsWrapper, outputWrapper);
            showOnlyCode.setControls2Show(inputWrapper, dualWrapper);
        }
        layoutToolbarManager.add((IAction)showOnlyCode);
        ToogleControlManager toogleControlManager = new ToogleControlManager(codeContainer, showOnlyCode, hideMappings, showFullMapping);
        new ToogleSizeManager(this.context.getEventBus(), splitter, showOnlyCode, hideMappings, showFullMapping);
        layoutToolbarManager.add((IContributionItem)new Separator());
        Composite toolbarSeparator = new Composite(codeContainer, 0);
        GridDataFactory.fillDefaults().grab(true, false).hint(4, 1).applyTo((Control)toolbarSeparator);
        toolbarSeparator.setBackground(WeaveUIConstants.ALUMINUM_4);
        GridLayoutFactory.fillDefaults().applyTo(toolbarSeparator);
        DualCodePreviewContainer dualContainer = new DualCodePreviewContainer(codeContainer, toogleControlManager, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)dualContainer);
        GridLayoutFactory.fillDefaults().applyTo((Composite)dualContainer);
        TooglePreviewAction tooglePreview = new TooglePreviewAction(dualContainer, this.context);
        this.eventBusHelper.registerUIListener(this.context.getEventBus(), MessageTransformerEventTypes.ON_SHORTCUT_PREVIEW, transformationTarget -> tooglePreview.setChecked(dualContainer.isPreviewEnabled()));
        layoutToolbarManager.add((IAction)tooglePreview);
        layoutToolbarManager.update(true);
        dualContainer.addDisposeListener(e -> {
            layoutToolbarManager.dispose();
            targetToolbarManager.dispose();
        });
        ThemeUtils.setCssClass((Object)((Object)dualContainer), (String)"DualCodePreview");
        return dualContainer;
    }

    private ToolBarManager createLayoutToolbar(Composite toolbarContainer) {
        if (this.layoutToolbar != null) {
            return this.layoutToolbar;
        }
        ToolBar layoutItemsToolbar = new ToolBar(toolbarContainer, 8519936);
        GridLayoutFactory.fillDefaults().applyTo((Composite)layoutItemsToolbar);
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000008, 0x1000000).applyTo((Control)layoutItemsToolbar);
        return new ToolBarManager(layoutItemsToolbar);
    }

    private ToolBarManager createTargetToolBar(Composite toolbarContainer) {
        if (this.targetToolBar != null) {
            return this.targetToolBar;
        }
        ToolBar targetToolbar = new ToolBar(toolbarContainer, 8519936);
        GridLayoutFactory.fillDefaults().applyTo((Composite)targetToolbar);
        GridDataFactory.fillDefaults().grab(true, true).align(1, 0x1000000).applyTo((Control)targetToolbar);
        return new ToolBarManager(targetToolbar);
    }

    private void configureLayoutDataForToolbar(Composite toolbarContainer) {
        GridDataFactory factory = GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000);
        if (OsDetect.getOperatingSystemType() == OsDetect.OsType.OSX) {
            factory.hint(4, 36);
        }
        factory.applyTo((Control)toolbarContainer);
    }

    private MappingPainter createMappingPainter(Composite parent, StudioFilteredTree inputTree, StudioFilteredTree outputTree, Splitter splitter, EventBus eventBus) {
        Point treeViewerSize = inputTree.computeSize(-1, -1);
        Point treeSize = inputTree.getViewer().getTree().computeSize(-1, -1);
        int margin = treeViewerSize.y - treeSize.y + 2;
        splitter.setMargin(margin);
        MappingPainter mappingPainter = new MappingPainter(parent, eventBus, 0);
        mappingPainter.setInputSplitter(splitter);
        mappingPainter.setLeftMargin(margin);
        mappingPainter.setRightMargin(margin);
        mappingPainter.setLeftFilteredTree((FilteredTree)inputTree);
        mappingPainter.setRightFilteredTree((FilteredTree)outputTree);
        return mappingPainter;
    }

    private long getDelayTime() {
        return this.getPreferenceStore().getLong("dfl.preview.delay");
    }

    private IPreferenceStore getPreferenceStore() {
        return DFLExtendedActivator.getInstance().getPreferenceStore();
    }

    private StudioFilteredTree createOutputViewer(Composite parent, Splitter splitter) {
        Rectangle margins = Geometry.createDiffRectangle((int)10, (int)10, (int)7, (int)10);
        DFLStudioFilteredTree outputMetadataTree = new DFLStudioFilteredTree(parent, 770, (PatternFilter)new LimitedLevelPatternFilter(8), margins);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)outputMetadataTree);
        this.registerMetadataTreeListeners(splitter, (StudioFilteredTree)outputMetadataTree, 1);
        outputMetadataTree.setBackground(WeaveUIConstants.WHITE);
        outputMetadataTree.setInitialText("Output");
        outputMetadataTree.getFilterControl().setToolTipText(BindingServiceHelper.getShortcut("org.mule.tooling.ui.dfl.contribution.commands.outputSearchCommand"));
        TreeViewer outputTreeViewer = outputMetadataTree.getViewer();
        Tree outputTree = outputTreeViewer.getTree();
        outputTree.setBackground(WeaveUIConstants.WHITE);
        outputTreeViewer.setUseHashlookup(true);
        outputTreeViewer.setLabelProvider((IBaseLabelProvider)new WeaveGraphicalTreeLabelProvider(this.transformerModel));
        outputTreeViewer.setContentProvider((IContentProvider)new GraphicalTreeContentProvider());
        return outputMetadataTree;
    }

    private Splitter createSplitter() {
        HashMap<Integer, Object> handlers = new HashMap<Integer, Object>();
        handlers.put(0, new LeftSashHandler());
        handlers.put(1, new RightSashHandler());
        handlers.put(2, new DefaultSashHandler());
        Splitter splitter = new Splitter(this.editorsComposite, handlers);
        GridLayoutFactory.fillDefaults().applyTo((Composite)splitter);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)splitter);
        return splitter;
    }

    private DFLEmbeddedEditor createCodeEditor(Composite parent, IDataSenseProvider datasense, ITransformationTarget target) {
        try {
            Composite editorWrapper = new Composite(parent, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)editorWrapper);
            editorWrapper.setLayout((Layout)new FillLayout());
            return DFLEditorHelper.createEditor(editorWrapper, target.getSource().getSourceContent(), datasense, this.context, this.errorManager);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private InputViewer createInputView(Composite parent, Splitter splitter) {
        InputViewer inputView = new InputViewer(parent, this.context);
        StudioFilteredTree inputMetadataTree = inputView.getInputMetadataTree();
        TreeViewer inputTreeviewer = inputMetadataTree.getViewer();
        inputTreeviewer.setLabelProvider((IBaseLabelProvider)new WeaveGraphicalTreeLabelProvider(this.transformerModel));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)inputTreeviewer);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)inputView);
        this.registerMetadataTreeListeners(splitter, inputMetadataTree, 0);
        inputMetadataTree.setInitialText("Input");
        inputMetadataTree.getFilterControl().setToolTipText(BindingServiceHelper.getShortcut("org.mule.tooling.ui.dfl.contribution.commands.inputSearchCommand"));
        return inputView;
    }

    private void registerMetadataTreeListeners(Splitter splitter, StudioFilteredTree filteredTree, int sashIndex) {
        filteredTree.getViewer().getTree().addTreeListener((TreeListener)new RedrawTreeViewerListener((Control)splitter, (IRedrawFunction)new SashRedraw(sashIndex)));
        filteredTree.getViewer().getTree().getVerticalBar().addSelectionListener((SelectionListener)new ScrollBarSelectionListener((Control)splitter, (IRedrawFunction)new SashRedraw(sashIndex)));
        filteredTree.getViewer().addSelectionChangedListener((ISelectionChangedListener)new RedrawSelectionChangedListener((Control)splitter, (IRedrawFunction)new SplitterRedraw()));
    }

    private void saveTargetSources() {
        for (Map.Entry<ITransformationTarget, TransformerEditorModel> entry : this.editors.entrySet()) {
            ITransformationTarget target = entry.getKey();
            DFLEmbeddedEditor embeddedEditor = entry.getValue().getEditor();
            if (!embeddedEditor.isDocumentModified()) continue;
            target.getSource().setSourceContent(embeddedEditor.getDocument().get());
        }
    }

    private boolean isMappingsActive() {
        return true;
    }

    private void refreshTwoWayHandler() {
        TwoWayHandler twoWayHandler = this.getCurrentTwoWayHandler();
        if (twoWayHandler != null) {
            this.refreshMetadataTrees();
            this.refresh();
        }
    }

    public void refreshMetadataTrees() {
        TwoWayHandler currentTwoWayHandler = this.getCurrentTwoWayHandler();
        if (currentTwoWayHandler != null) {
            MetadataOperations.refreshMetadataTrees(currentTwoWayHandler);
        }
    }

    private static final class SearchJobHandler
    extends JobChangeAdapter {
        private MappingPainter mappingPainter;

        public SearchJobHandler(MappingPainter mappingPainter) {
            this.mappingPainter = mappingPainter;
        }

        public void done(IJobChangeEvent event) {
            super.done(event);
            Display.getDefault().syncExec(() -> {
                this.mappingPainter.refreshItems();
                this.mappingPainter.reload();
            });
        }
    }

    private static final class TooglePreviewAction
    extends Action {
        private EditorContext context;
        private DualCodePreviewContainer dualContainer;

        public TooglePreviewAction(DualCodePreviewContainer dualContainer, EditorContext context) {
            super("&Preview", 2);
            this.setToolTipText("Preview (" + BindingServiceHelper.getShortcut("org.mule.tooling.ui.dfl.contribution.commands.turnOnOffPreviewCommand") + ")");
            this.context = context;
            this.dualContainer = dualContainer;
        }

        public void run() {
            this.dualContainer.setPreviewEnabled(this.isChecked());
            this.context.getEventBus().fireEvent((IEvent)new TogglePreviewEvent());
        }
    }
}

