/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import java.util.List;
import java.util.Optional;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.DFLEditor;
import org.mule.tooling.dfl.ui.datasense.DwMetadataProvider;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.messageflow.command.UpdatePropertiesCommand;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.PatternEditPart;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.properties.editor.IPropertiesEditor;
import org.mule.tooling.properties.editor.IPropertiesTitle;
import org.mule.tooling.properties.views.MulePropertiesView;
import org.mule.tooling.ui.dfl.contribution.editor.script.DataWeaveEditor;
import org.mule.tooling.ui.dfl.contribution.editor.script.EditorContext;
import org.mule.tooling.ui.dfl.contribution.editor.script.UndoRedoListener;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.IMappingModel;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.ITransformationTarget;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.MessageTransformMappingModel;
import org.mule.tooling.ui.modules.core.metadata.IPropagationInfoProvider;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageRowType;
import org.mule.tooling.ui.modules.core.properties.IMessageFlowNodePropertyManager;
import org.mule.tooling.ui.modules.core.properties.IPropertyValueChangeListener;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;

public class DFLPropertiesEditor
implements IPropertiesEditor<PatternEditPart> {
    private IMuleProject project;
    private EventBus eventBus = new EventBus();
    private EventBusHelper eventBusHelper;
    private PatternEditPart element;
    private IPropertiesTitle titleHandler;
    private CommandStack commandStack;
    private PropertyCollection newProperties;
    private IReadOnlyPropertyCollection originalProperties;
    private volatile DataWeaveEditor editor;
    private IMappingModel messageTransformer;

    public boolean handles(Object element) {
        if (element instanceof PatternEditPart) {
            return ((PatternNode)((PatternEditPart)element).getEntity()).getType().equalsIgnoreCase("http://www.mulesoft.org/schema/mule/ee/core/transform");
        }
        return false;
    }

    public void setTitleHandler(IPropertiesTitle titleHandler) {
        this.titleHandler = titleHandler;
    }

    public void setEditElement(PatternEditPart element) {
        this.element = element;
        this.setOriginalProperties();
        this.newProperties = PropertiesUtils.toWritablePropertyCollection((IPropertyCollectionReadCapability)this.originalProperties);
    }

    private void setOriginalProperties() {
        this.originalProperties = ((PatternNode)this.element.getEntity()).getProperties();
    }

    public void setMuleProject(IMuleProject project) {
        this.project = project;
    }

    public Control createControl(Composite parent) {
        this.titleHandler.setTitleMessage(((PatternNode)this.element.getEntity()).getName());
        this.titleHandler.setTooltip(((PatternNode)this.element.getEntity()).getDescription());
        this.titleHandler.setImage(((PatternNode)this.element.getEntity()).getDefinition().getIconImage());
        this.eventBusHelper = new EventBusHelper();
        IPropagationInfoProvider propagationProvider = (IPropagationInfoProvider)MulePropertiesView.get().getDataSenseInfoProvider().get();
        DwMetadataProvider inputMetaDataProvider = DwMetadataProvider.createInputMetaDataProvider((IMuleProject)this.project, (IMessageFlowEntity)this.element.getEntity(), (IPropagationInfoProvider)propagationProvider);
        DwMetadataProvider outputPayloadMetaDataProvider = DwMetadataProvider.createOutputMetaDataProvider((IMuleProject)this.project, (IMessageFlowNode)((IMessageFlowNode)this.element.getEntity()), (IPropagationInfoProvider)propagationProvider, (MessageRowType)MessageRowType.OUTPUT_PAYLOAD);
        EditorContext editorContext = new EditorContext(this.project, this.element.getMuleConfiguration(), (IMessageFlowNode)this.element.getEntity(), this.getEventBus(), propagationProvider, (IMetaDataProvider)inputMetaDataProvider, (IMetaDataProvider)outputPayloadMetaDataProvider);
        this.editor = new DataWeaveEditor(parent, this.getMessageTransformerHandler(), editorContext);
        parent.setBackground(DFLEditor.BACKGROUND_COLOR);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.editor);
        ThemeUtils.setCssClass((Object)this.editor, (String)"DataWeave");
        return this.editor;
    }

    public IMappingModel getMessageTransformerHandler() {
        if (this.messageTransformer == null) {
            this.messageTransformer = new MessageTransformMappingModel(this.project, (PatternNode)this.element.getEntity(), this.getEventBus(), this.getNewPropertyCollection());
        }
        return this.messageTransformer;
    }

    public void addActions(IToolBarManager toolbar) {
        toolbar.add((IAction)this.editor.getUndoAction());
        toolbar.add((IAction)this.editor.getRedoAction());
        IContributionItem undoItem = null;
        IContributionItem redoItem = null;
        IToolBarManager toolBarManager = MulePropertiesView.get().getViewSite().getActionBars().getToolBarManager();
        IContributionItem[] iContributionItemArray = toolBarManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem iContributionItem = iContributionItemArray[n2];
            if (ActionFactory.UNDO.getId().equals(iContributionItem.getId())) {
                undoItem = iContributionItem;
            } else if (ActionFactory.REDO.getId().equals(iContributionItem.getId())) {
                redoItem = iContributionItem;
            }
            ++n2;
        }
        if (undoItem != null && redoItem != null) {
            UndoRedoListener undoRedoListener = new UndoRedoListener(undoItem, redoItem);
            XtextDocument document = this.editor.getCurrentEditor().getDocument();
            document.addDocumentListener((IDocumentListener)undoRedoListener);
            this.editor.addDisposeListener(event -> document.removeDocumentListener((IDocumentListener)undoRedoListener));
        }
    }

    public void setEditor(MultiPageMessageFlowEditor editor) {
        this.commandStack = editor.getFlowEditor().getEditDomain().getCommandStack();
    }

    public void apply(boolean force) {
        this.doSave(force);
    }

    public void doSave(boolean force) {
        if (this.editor != null) {
            this.titleHandler.markAsSaved();
            this.editor.doSave();
        }
        if (force || !this.originalProperties.equals(this.getNewPropertyCollection())) {
            EntityDecorator model = (EntityDecorator)this.element.getModel();
            this.commandStack.execute((Command)new UpdatePropertiesCommand(this.project, null, model, this.originalProperties, PropertiesUtils.toWritablePropertyCollection((IPropertyCollectionReadCapability)this.getNewPropertyCollection())));
            this.setOriginalProperties();
        }
    }

    public PropertyCollection getNewPropertyCollection() {
        return this.newProperties;
    }

    public void onSave() {
        this.doSave(false);
    }

    public void onOpen() {
        List<ITransformationTarget> targets = this.getMessageTransformerHandler().getTargets();
        if (targets.isEmpty()) {
            MetadataType targetPayload = IPropagationInfoProvider.getUnresolvedMetadata().getExpectedMetadataType().getMessage().getPayload();
            this.getMessageTransformerHandler().newPayloadTransformation(targetPayload);
            this.doSave(true);
        } else {
            ITransformationTarget payload = null;
            for (ITransformationTarget targetTransformation : targets) {
                if (!targetTransformation.isPayload()) {
                    this.editor.openEditor(targetTransformation);
                    continue;
                }
                payload = targetTransformation;
            }
            if (payload != null) {
                this.editor.openEditor(payload);
            }
        }
    }

    public void onClose() {
        this.messageTransformer = null;
        this.editor.doClose(true);
        this.editor.dispose();
        this.eventBus.cleanAllListeners();
        this.editor = null;
        this.eventBus = new EventBus();
        this.eventBusHelper.unregister();
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public boolean requiresMultiPageEditorShown() {
        return false;
    }

    public Optional<IMessageFlowNodePropertyManager> getPropertiesManager() {
        return Optional.empty();
    }

    public void addPropertyValueChangeListener(IPropertyValueChangeListener propertyListener) {
    }

    public void removeAllPropertyValueChangeListeners() {
    }

    public String getHelpURL() {
        return null;
    }

    public boolean showDataSense() {
        return false;
    }

    public String getContentDescriptor() {
        return ((PatternNode)this.element.getEntity()).getType();
    }
}

