/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import com.google.inject.Injector;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.validation.Issue;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.DFLExtendedActivator;
import org.mule.tooling.dfl.ui.datasense.DataSenseHolder;
import org.mule.tooling.dfl.ui.datasense.IDataSenseProvider;
import org.mule.tooling.dfl.ui.embedded.editor.DFLEmbeddedEditor;
import org.mule.tooling.dfl.ui.embedded.editor.DFLEmbeddedEditorBuilder;
import org.mule.tooling.dfl.ui.embedded.editor.DFLEmbeddedEditorResourceProvider;
import org.mule.tooling.dfl.ui.ls.DataWeaveLanguageService;
import org.mule.tooling.ui.dfl.contribution.editor.script.EditorContext;
import org.mule.tooling.ui.widgets.errors.ErrorManager;
import org.mule.tooling.utils.eventbus.EventBus;

public final class DFLEditorHelper {
    private DFLEditorHelper() {
    }

    public static DFLEmbeddedEditor createEditor(Composite parent, String content, IDataSenseProvider dataSenseProvider, EditorContext context, ErrorManager<Document, Issue> errorManager) throws CoreException {
        IMuleProject project = context.getProject();
        EventBus eventBus = context.getEventBus();
        return DFLEditorHelper.createEditor(parent, content, dataSenseProvider, errorManager, project, eventBus, new DFLEditorConfiguration());
    }

    public static DFLEmbeddedEditor createEditor(Composite parent, String content, IDataSenseProvider dataSenseProvider, ErrorManager<Document, Issue> errorManager, final IMuleProject project, EventBus eventBus, DFLEditorConfiguration editorConfiguration) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(container);
        Injector injector = DFLExtendedActivator.getInstance().getInjector("org.mule.tooling.dfl.DFL");
        DFLEmbeddedEditorResourceProvider resourceProvider = (DFLEmbeddedEditorResourceProvider)injector.getInstance(DFLEmbeddedEditorResourceProvider.class);
        final URI uri = resourceProvider.createURI();
        resourceProvider.setUri(uri);
        DataSenseHolder.setContext((String)uri.toString(), (IDataSenseProvider)dataSenseProvider, (IMuleProject)project);
        EmbeddedEditorFactory factory = (EmbeddedEditorFactory)injector.getInstance(EmbeddedEditorFactory.class);
        DFLEmbeddedEditorBuilder builder = (DFLEmbeddedEditorBuilder)factory.newEditor((IEditedResourceProvider)resourceProvider);
        if (editorConfiguration.isShowMarker()) {
            builder.showLineNumbers();
            builder.showErrorAndWarningAnnotations();
        }
        final Optional<ErrorManager<Document, Issue>> errorMananger = Optional.ofNullable(errorManager);
        builder.oneLiner(editorConfiguration.isOneLiner());
        builder.setErrorManager(errorMananger);
        builder.setMuleProject(project);
        builder.setDataSenseProvider(dataSenseProvider);
        builder.setEventBus(eventBus);
        DFLEmbeddedEditor editor = builder.withParent(container);
        EmbeddedEditorModelAccess editorModelAccess = editor.createPartialEditor("", content, "", false);
        editor.setEditorModelAccess(editorModelAccess);
        editor.getViewer().getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DataSenseHolder.removeContext((String)uri.toString());
                Optional.ofNullable(DataWeaveLanguageService.getInstance((IMuleProject)project)).ifPresent(it -> it.close(uri.toString()));
                errorMananger.ifPresent(manager -> {
                    manager.clearListeners();
                    manager.clear();
                });
            }
        });
        return editor;
    }

    public static class DFLEditorConfiguration {
        private boolean showMarker = true;
        private boolean oneLiner = false;

        public boolean isShowMarker() {
            return this.showMarker;
        }

        public boolean isOneLiner() {
            return this.oneLiner;
        }

        public DFLEditorConfiguration oneLiner(boolean onLiner) {
            this.oneLiner = onLiner;
            return this;
        }

        public DFLEditorConfiguration withShowMarker(boolean showMarker) {
            this.showMarker = showMarker;
            return this;
        }
    }
}

