/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import java.util.Optional;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.datasense.MetadataHelper;
import org.mule.tooling.dfl.ui.graphical.util.TreeViewerHelper;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingUtils;
import org.mule.tooling.ui.dfl.contribution.editor.action.AbstractOutputMetadataAction;
import org.mule.tooling.ui.dfl.contribution.editor.datasense.MetadataOperations;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.TwoWayHandler;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.IMappingModel;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageRowType;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class ClearOutputTargetMetadataAction
extends AbstractOutputMetadataAction {
    private IMappingModel transformerModel;

    public ClearOutputTargetMetadataAction(IMappingModel transformerModel, TwoWayHandler twoWayHandler) {
        super("Clear Metadata", twoWayHandler, twoWayHandler.getMappingPainter().getRightViewer());
        this.transformerModel = transformerModel;
        this.twoWayHandler = twoWayHandler;
    }

    public void run() {
        MessageRowType rowType = this.getMessageRowType();
        GraphicalTreeNode graphicalTreeNode = (GraphicalTreeNode)TreeViewerHelper.getSelectedNode((ISelectionProvider)this.treeViewer).get();
        Optional<String> propertyName = MetadataOperations.propertyName(this.twoWayHandler, rowType, graphicalTreeNode);
        this.transformerModel.clearOutputMetadata(rowType, propertyName, this.twoWayHandler.getPropagationProvider());
    }

    @Override
    protected boolean isEnabledFor(TreeItem[] selection, GraphicalTreeNode<?> node) {
        return selection.length != 0 && selection[0].getParentItem() == null;
    }

    @Override
    protected MessageRowType getMessageRowType() {
        Optional maybeMessageRowType = MetadataHelper.getCurrentOutputMessageRowType((String)this.twoWayHandler.getCurrentTarget().getCategory());
        return (MessageRowType)maybeMessageRowType.get();
    }

    @Override
    protected void refreshHeaderScript(final MetadataType model) {
        this.twoWayHandler.getEditor().getDocument().modify((IUnitOfWork)new IUnitOfWork<Void, XtextResource>(){

            public Void exec(XtextResource state) throws Exception {
                MappingUtils.configureOutputType((MetadataType)model, (XtextResource)state, (IMuleProject)ClearOutputTargetMetadataAction.this.twoWayHandler.getProject());
                return null;
            }
        });
    }
}

