/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import java.util.List;
import java.util.Optional;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.ImportDirective;
import org.mule.tooling.dfl.ui.datasense.IDataSenseProvider;
import org.mule.tooling.dfl.ui.embedded.editor.DFLEmbeddedEditor;
import org.mule.tooling.ui.dfl.contribution.editor.script.AssignmentEditorComposite;
import org.mule.tooling.ui.dfl.contribution.editor.script.DFLEditorHelper;
import org.mule.tooling.ui.dfl.contribution.editor.script.SelectAssignmentExpression;
import org.mule.tooling.ui.dfl.contribution.editor.script.SelectImportsExpression;
import org.mule.tooling.ui.widgets.dialog.ISimpleDialogEditorPresenter;
import org.mule.tooling.ui.widgets.errors.ErrorManager;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.weave.v2.ts.WeaveType;

public class AssignmentEditorPresenter
implements ISimpleDialogEditorPresenter<AssignmentEditorComposite> {
    private IMuleProject project;
    private AssignmentEditorComposite editor;
    private Expression result;
    private String code;
    private WeaveType selectionType;
    private String fieldName;
    private boolean hasChanged = false;
    private List<ImportDirective> imports;
    private IDataSenseProvider dataSenseProvider;
    private String defaultValue;

    public AssignmentEditorPresenter(WeaveType selectionType, String fieldName, IMuleProject project, String code, IDataSenseProvider dataSenseProvider, String defaultValue) {
        this.selectionType = selectionType;
        this.fieldName = fieldName;
        this.project = project;
        this.code = code;
        this.dataSenseProvider = dataSenseProvider;
        this.defaultValue = defaultValue;
    }

    public void handle(AssignmentEditorComposite editor) {
        this.editor = editor;
        editor.setField(this.fieldName, this.selectionType, this.defaultValue, composite -> {
            String code = Optional.ofNullable(this.code).orElse("");
            DFLEditorHelper.DFLEditorConfiguration editorConfiguration = new DFLEditorHelper.DFLEditorConfiguration();
            editorConfiguration.oneLiner(false);
            ErrorManager errorManager = new ErrorManager();
            return DFLEditorHelper.createEditor(composite, code, this.dataSenseProvider, (ErrorManager<Document, Issue>)errorManager, this.project, new EventBus(), editorConfiguration);
        });
    }

    public boolean onSave() {
        DFLEmbeddedEditor dflEmbeddedEditor = this.editor.getEditor();
        if (dflEmbeddedEditor.haveErrors()) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot apply changes", (String)"There are errors in the script. Please correct them before applying the changes.");
            return false;
        }
        this.result = (Expression)dflEmbeddedEditor.getDocument().readOnly((IUnitOfWork)new SelectAssignmentExpression());
        this.hasChanged = !dflEmbeddedEditor.getTextDocument().trim().equals(this.code.trim());
        this.imports = (List)dflEmbeddedEditor.getDocument().readOnly((IUnitOfWork)new SelectImportsExpression());
        return this.result != null;
    }

    public List<ImportDirective> getImports() {
        return this.imports;
    }

    public Expression getExpression() {
        return this.result;
    }

    public boolean onCancel() {
        return true;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }
}

