/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.mule.tooling.dfl.ui.embedded.editor.DFLEmbeddedEditor;
import org.mule.tooling.dfl.ui.graphical.WeaveUIConstants;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.weave.v2.ts.WeaveType;
import org.mule.weave.v2.utils.WeaveTypeEmitterConfigBuilder;

public class AssignmentEditorComposite
extends Composite {
    public static Font LABEL_NAME_FONT;
    public static Font LABEL_TYPE_FONT;
    private DFLEmbeddedEditor editor;

    static {
        FontData fontData = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont").getFontData()[0];
        fontData.setHeight(16);
        LABEL_NAME_FONT = new Font((Device)WidgetUtils.getDisplay(), fontData);
        fontData = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont").getFontData()[0];
        fontData.setHeight(16);
        LABEL_TYPE_FONT = new Font((Device)WidgetUtils.getDisplay(), fontData);
    }

    public AssignmentEditorComposite(Composite parent, int style) {
        super(parent, style);
        GridLayoutFactory.swtDefaults().applyTo((Composite)this);
    }

    public void setField(String name, WeaveType wtype, String defaultValue, Function<Composite, DFLEmbeddedEditor> factory) {
        Group fieldEditor = new Group((Composite)this, 0);
        GridLayoutFactory.fillDefaults().applyTo((Composite)fieldEditor);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)fieldEditor);
        Composite labelComposite = new Composite((Composite)fieldEditor, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).numColumns(3).applyTo(labelComposite);
        CLabel label = new CLabel(labelComposite, 0);
        label.setText(name + ":");
        label.setFont(LABEL_NAME_FONT);
        label.setForeground(WeaveUIConstants.BLACK);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        WeaveTypeEmitterConfigBuilder builder = new WeaveTypeEmitterConfigBuilder();
        String weaveTypeLabel = wtype.toString(builder.withNameOnly(true).withPrettyPrint(false).withSkipMetadataConstraints(true).withSkipWeaveTypeMetadata(true).build());
        CLabel type = new CLabel(labelComposite, 0);
        type.setText(weaveTypeLabel);
        type.setFont(LABEL_TYPE_FONT);
        type.setForeground(WeaveUIConstants.TYPE_COLOR);
        GridDataFactory.fillDefaults().applyTo((Control)type);
        CLabel defaultValueLabel = new CLabel(labelComposite, 0);
        Object defaultValueText = StringUtils.isNotBlank((String)defaultValue) ? "=" + defaultValue : "";
        defaultValueLabel.setText((String)defaultValueText);
        defaultValueLabel.setFont(LABEL_TYPE_FONT);
        defaultValueLabel.setForeground(WeaveUIConstants.STRING_COLOR);
        GridDataFactory.fillDefaults().applyTo((Control)defaultValueLabel);
        Composite editorContainer = new Composite((Composite)fieldEditor, 2048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)editorContainer);
        editorContainer.setBackground(Display.getDefault().getSystemColor(1));
        editorContainer.setLayout((Layout)new FillLayout());
        this.editor = factory.apply(editorContainer);
    }

    public DFLEmbeddedEditor getEditor() {
        return this.editor;
    }
}

