/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.XtextResource;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.ImportDirective;
import org.mule.tooling.dfl.dFL.ImportWithSubElements;
import org.mule.tooling.dfl.ui.scafflod.ScaffoldingHelper;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.AbstractExpressionWork;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.ApplyFunctionToFieldWork;
import org.mule.weave.v2.editor.FunctionDefinition;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;

public class ApplyFunctionToExpressionWork
extends AbstractExpressionWork {
    private List<ImportDirective> directives;
    private FunctionDefinition functionDefinition;
    private List<Expression> parameters;
    private int offset;
    private int length;

    public ApplyFunctionToExpressionWork(FunctionDefinition functionDefinition, List<Expression> parameters, int offset, int length, List<ImportDirective> directives) {
        this.functionDefinition = functionDefinition;
        this.parameters = parameters;
        this.offset = offset;
        this.length = length;
        this.directives = directives;
    }

    @Override
    public List<ImportDirective> resolveImportDirectives() {
        NameIdentifier functionName = this.functionDefinition.nameIdentifier();
        if (functionName.parent().isDefined() && !((NameIdentifier)functionName.parent().get()).name().equals(NameIdentifier.CORE_MODULE().name())) {
            ImportWithSubElements importWithSubElements = ApplyFunctionToFieldWork.createImportDirective(functionName);
            ArrayList<ImportDirective> importedResult = new ArrayList<ImportDirective>(this.directives);
            importedResult.add((ImportDirective)importWithSubElements);
            return importedResult;
        }
        return this.directives;
    }

    public void process(XtextResource state) throws Exception {
        Document document = (Document)state.getContents().get(0);
        this.mergeImports(document);
        state.update(this.offset, this.length, this.getFunctionSignatureString());
    }

    private String getFunctionSignatureString() {
        String name = this.functionDefinition.nameIdentifier().localName().name();
        StringBuilder expression = new StringBuilder();
        expression.append(name).append("(");
        int i = 0;
        while (i < this.parameters.size()) {
            Expression param = this.parameters.get(i);
            if (i > 0) {
                expression.append(", ");
            }
            expression.append(ScaffoldingHelper.eObjectToString((EObject)param).trim());
            ++i;
        }
        expression.append(")");
        return expression.toString();
    }
}

