/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.script;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.ui.embedded.editor.DFLTextViewerUndoManager;
import org.mule.tooling.dfl.ui.utils.ImagesHelper;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.TwoWayHandler;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.weave.v2.editor.FunctionDefinition;

public class ApplyFunctionAction
extends Action {
    private TwoWayHandler twoWayHandler;
    private Optional<Expression> mayBeSelectedValue = Optional.empty();
    private FunctionDefinition funcDef;
    private GraphicalTreeNode<?> selectedNode;

    public ApplyFunctionAction(TwoWayHandler twoWayHandler, String label, GraphicalTreeNode<?> selectedNode, FunctionDefinition funcDef, Optional<Expression> keyValuePair) {
        super(label, ImagesHelper.getImageDescriptor((String)(ThemeUtils.getCurrentTheme().getDflImgFolder() + "fx-16x16.png")));
        this.twoWayHandler = twoWayHandler;
        this.selectedNode = selectedNode;
        this.funcDef = funcDef;
        this.mayBeSelectedValue = keyValuePair;
        this.setToolTipText(funcDef.asciidocDoc());
    }

    public boolean isEnabled() {
        return this.mayBeSelectedValue.isPresent() && !this.twoWayHandler.getEditor().haveErrors();
    }

    public void run() {
        AnalyticsRecordsFactory.single((String)Events.DW_APPLY_FUNCTION, (String[])new String[]{"quick", "true", "function", this.funcDef.nameIdentifier().toString(), "params", "1"}).track();
        DFLTextViewerUndoManager textViewerUndoManager = (DFLTextViewerUndoManager)this.twoWayHandler.getEditor().getViewer().getUndoManager();
        textViewerUndoManager.beginCrossCompoundChange();
        this.twoWayHandler.assignFunctionDefinition(this.selectedNode, this.funcDef, Arrays.asList(this.mayBeSelectedValue.get()), Collections.emptyList());
        textViewerUndoManager.endCrossCompoundChange();
        this.twoWayHandler.deselect();
        this.twoWayHandler.applyFormatter();
        this.twoWayHandler.refreshGraphicalView();
    }
}

