/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.graphical;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.dFL.AttributeElement;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.ImportDirective;
import org.mule.tooling.dfl.ui.DFLExtendedActivator;
import org.mule.tooling.dfl.ui.datasense.MetadataHelper;
import org.mule.tooling.dfl.ui.embedded.editor.DFLEmbeddedEditor;
import org.mule.tooling.dfl.ui.embedded.editor.DFLTextViewerUndoManager;
import org.mule.tooling.dfl.ui.graphical.MappingPainter;
import org.mule.tooling.dfl.ui.graphical.events.GraphicalEventTypes;
import org.mule.tooling.dfl.ui.graphical.events.IAutoMappingClick;
import org.mule.tooling.dfl.ui.graphical.model.ITreeGraphicalMapping;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.view2code.KeyValuePairContainer;
import org.mule.tooling.dfl.ui.graphical.view2code.MultipleKeyValuePairContainer;
import org.mule.tooling.dfl.ui.graphical.view2code.ViewToCodeUnitOfWork;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.ui.dfl.contribution.editor.action.SingleStructuredSelection;
import org.mule.tooling.ui.dfl.contribution.editor.datasense.TreeEditorHelper;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.ApplyFunctionToFieldWork;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.AssignExpressionToFieldWork;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.DeleteAssignmentWork;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.DeleteAttributeAssignmentWork;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.ErrorManagerHelper;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.FindAttributeWork;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.FindKeyValuePairWork;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.FindMultipleKeyValuePairWork;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.GraphicalListenerHandler;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.GraphicalUnitOfWork;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.OutputTreeDoubleClickWork;
import org.mule.tooling.ui.dfl.contribution.editor.script.EditorContext;
import org.mule.tooling.ui.dfl.contribution.editor.script.SelectDocumentExpression;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.InputContextMenuProvider;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.IMappingModel;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.ITransformationTarget;
import org.mule.tooling.ui.modules.core.metadata.IPropagationInfoProvider;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageRowType;
import org.mule.tooling.ui.widgets.errors.ErrorManager;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.mule.weave.v2.editor.FunctionDefinition;

public class TwoWayHandler {
    private static final int MAX_METADATA_LEVELS = 3;
    private boolean isDirty;
    private EditorContext context;
    private ErrorManager<org.eclipse.jface.text.Document, Issue> errorManager;
    private DFLEmbeddedEditor codeEditor;
    private MappingPainter mappingPainter;
    private GraphicalUnitOfWork graphicalUnitOfWork;
    private GraphicalListenerHandler callbackHandler;
    private InputContextMenuProvider inputContextMenuProvider;
    private List<Composite> metadataEditors = Lists.newArrayList();
    private ITransformationTarget currentTarget;
    private IMappingModel transformerModel;
    private EventBus eventBus;

    public TwoWayHandler(DFLEmbeddedEditor graphicalSourceCodeEditor, MappingPainter mappingPainter, final EditorContext context, InputContextMenuProvider inputContextMenuProvider, ErrorManager<org.eclipse.jface.text.Document, Issue> errorManager, ITransformationTarget currentTarget, final IMappingModel transformerModel, final EventBus eventBus) {
        this.mappingPainter = mappingPainter;
        this.codeEditor = graphicalSourceCodeEditor;
        this.context = context;
        this.inputContextMenuProvider = inputContextMenuProvider;
        this.errorManager = errorManager;
        this.currentTarget = currentTarget;
        this.transformerModel = transformerModel;
        this.eventBus = eventBus;
        this.callbackHandler = new GraphicalListenerHandler(mappingPainter, inputContextMenuProvider);
        this.graphicalUnitOfWork = new GraphicalUnitOfWork(this.callbackHandler);
        this.callbackHandler.registerListener(this);
        inputContextMenuProvider.setTwoWayHandler(this);
        eventBus.registerListener(GraphicalEventTypes.ON_AUTO_MAPPING_CLICK, (IEventHandler)new IAutoMappingClick(){

            public void onAutoMappingclick(MappingNode sourceMappingNode, MappingNode targetMappingNode) {
                DFLTextViewerUndoManager textViewerUndoManager = (DFLTextViewerUndoManager)TwoWayHandler.this.getEditor().getViewer().getUndoManager();
                textViewerUndoManager.beginCrossCompoundChange();
                TwoWayHandler.this.markAsDirty();
                DFLEmbeddedEditor editor = TwoWayHandler.this.getEditor();
                boolean result = (Boolean)editor.getDocument().modify((IUnitOfWork)new ViewToCodeUnitOfWork((GraphicalTreeNode)sourceMappingNode.getNode().get(), (GraphicalTreeNode)targetMappingNode.getNode().get(), context.getInputMetadataProvider(), context.getOutputMetadataProvider(), eventBus, context.getProject(), true, transformerModel.supportsUpdateOutputHeader()));
                textViewerUndoManager.endCrossCompoundChange();
                if (result) {
                    TwoWayHandler.this.deselect();
                    TwoWayHandler.this.applyFormatter();
                    Optional<KeyValuePairContainer> keyValuePairContainer = TwoWayHandler.this.performFindKeyValuePairWork(new SingleStructuredSelection((GraphicalTreeNode)targetMappingNode.getNode().get()));
                    TwoWayHandler.this.highlightCodeKeyValuePair(keyValuePairContainer);
                    TwoWayHandler.this.refreshGraphicalView();
                }
            }
        });
    }

    private EventBus getEventBus() {
        return this.eventBus;
    }

    public EditorContext getEditorContext() {
        return this.context;
    }

    public void expandTrees() {
        this.mappingPainter.getLeftViewer().expandToLevel(3);
        this.mappingPainter.getRightViewer().expandToLevel(3);
    }

    public void checkMetadata() {
        Tree leftTree = this.mappingPainter.getLeftViewer().getTree();
        Tree rightTree = this.mappingPainter.getRightViewer().getTree();
        TreeItem[] leftItems = leftTree.getItems();
        TreeItem[] rightItems = rightTree.getItems();
        for (Composite composite : this.metadataEditors) {
            if (composite.isDisposed()) continue;
            composite.dispose();
        }
        this.metadataEditors.clear();
        TreeItem[] treeItemArray = leftItems;
        int n = leftItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem currentItem = treeItemArray[n2];
            GraphicalTreeNode currentNode = (GraphicalTreeNode)currentItem.getData();
            String id = currentNode.getId();
            if ("payload".equals(id)) {
                currentModel = currentNode.getModel();
                if (this.shouldDefineMetadata(currentModel)) {
                    metadataTree = TreeEditorHelper.createTreeMetadataEditor(leftTree, currentNode, currentItem, MessageRowType.INPUT_PAYLOAD, this.context, this.transformerModel, this, this.inputContextMenuProvider, this.mappingPainter.getLeftViewer());
                    this.metadataEditors.add(metadataTree);
                }
            } else if ("attributes".equals(id)) {
                currentModel = currentNode.getModel();
                if (this.shouldDefineMetadata(currentModel)) {
                    metadataTree = TreeEditorHelper.createTreeMetadataEditor(leftTree, currentNode, currentItem, MessageRowType.INPUT_ATTRIBUTES, this.context, this.transformerModel, this, this.inputContextMenuProvider, this.mappingPainter.getLeftViewer());
                    this.metadataEditors.add(metadataTree);
                }
            } else if (MetadataHelper.isPropertyHeader((GraphicalTreeNode)currentNode)) {
                TreeItem[] children;
                TreeItem[] treeItemArray2 = children = currentItem.getItems();
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    Optional currentMessageRowType;
                    Object currentModel;
                    TreeItem currentPropertyItem = treeItemArray2[n4];
                    GraphicalTreeNode propertyNode = (GraphicalTreeNode)currentPropertyItem.getData();
                    if (propertyNode != null && this.shouldDefineMetadata(currentModel = propertyNode.getModel()) && (currentMessageRowType = MetadataHelper.getCurrentMessageRowType((GraphicalTreeNode)currentNode)).isPresent()) {
                        Composite metadataTree = TreeEditorHelper.createTreeMetadataEditor(leftTree, propertyNode, currentPropertyItem, (MessageRowType)currentMessageRowType.get(), this.context, this.transformerModel, this, this.inputContextMenuProvider, this.mappingPainter.getLeftViewer());
                        this.metadataEditors.add(metadataTree);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        TreeItem rightItemPayload = rightItems[0];
        GraphicalTreeNode currentNode = (GraphicalTreeNode)rightItemPayload.getData();
        Object currentModel = currentNode.getModel();
        if (this.shouldDefineMetadata(currentModel) && this.allowRetypingOuputMetadata()) {
            Optional maybeMessageRowType = MetadataHelper.getCurrentOutputMessageRowType((String)this.currentTarget.getCategory());
            Composite metadataTree = TreeEditorHelper.createTreeMetadataEditor(rightTree, currentNode, rightItemPayload, (MessageRowType)maybeMessageRowType.get(), this.context, this.transformerModel, this);
            this.metadataEditors.add(metadataTree);
        }
    }

    protected boolean shouldDefineMetadata(Object model) {
        return this.isUndefined(model) || model instanceof BinaryType || model instanceof AnyType;
    }

    private boolean isUndefined(Object model) {
        return model instanceof MetadataType && MetadataFactory.isUndefined((MetadataType)((MetadataType)model));
    }

    public void deselect() {
        DFLEmbeddedEditor editor = this.getEditor();
        editor.getViewer().setSelectedRange(0, 0);
    }

    public void applyFormatter() {
        DFLEmbeddedEditor editor;
        if (this.getAutoFormatting() && !StringUtils.isBlank((String)(editor = this.getEditor()).getDocument().get())) {
            editor.getViewer().doOperation(15);
        }
    }

    private boolean getAutoFormatting() {
        return DFLExtendedActivator.getInstance() != null ? DFLExtendedActivator.getInstance().getPreferenceStore().getBoolean("dataweave.autoformatting") : true;
    }

    public void cleanGraphicalView() {
        this.callbackHandler.processMappings(Lists.newArrayList());
    }

    public void refreshGraphicalView() {
        this.getEditor().getDocument().readOnly((IUnitOfWork)this.graphicalUnitOfWork);
    }

    public void showInvalidIndicator() {
        this.mappingPainter.showErrorMessage();
        this.mappingPainter.reload();
    }

    public boolean performDrop(GraphicalTreeNode<?> sourceNode, GraphicalTreeNode<?> targetNode) {
        this.markAsDirty();
        DFLEmbeddedEditor editor = this.getEditor();
        return (Boolean)editor.getDocument().modify((IUnitOfWork)new ViewToCodeUnitOfWork(sourceNode, targetNode, this.context.getInputMetadataProvider(), this.context.getOutputMetadataProvider(), this.eventBus, this.context.getProject(), false, this.transformerModel.supportsUpdateOutputHeader()));
    }

    public void performOutputTreeDoubleClickWork(DoubleClickEvent event) {
        this.markAsDirty();
        DFLEmbeddedEditor editor = this.getEditor();
        editor.getDocument().modify((IUnitOfWork)new OutputTreeDoubleClickWork(event.getSelection(), this.context.getProject()));
    }

    public void performDeleteKeyValuePairAssignment(Optional<MultipleKeyValuePairContainer> multipleKeyValuePairContainerOptional) {
        this.markAsDirty();
        DFLEmbeddedEditor editor = this.getEditor();
        editor.getDocument().modify((IUnitOfWork)new DeleteAssignmentWork(multipleKeyValuePairContainerOptional.get()));
    }

    public void performDeleteAttributeAssignment(Optional<AttributeElement> multipleKeyValuePairContainerOptional) {
        this.markAsDirty();
        DFLEmbeddedEditor editor = this.getEditor();
        editor.getDocument().modify((IUnitOfWork)new DeleteAttributeAssignmentWork(multipleKeyValuePairContainerOptional.get()));
    }

    public void assignExpression(GraphicalTreeNode<?> element, Expression expression, List<ImportDirective> imports) {
        this.markAsDirty();
        DFLEmbeddedEditor editor = this.getEditor();
        editor.getDocument().modify((IUnitOfWork)new AssignExpressionToFieldWork(element, expression, imports));
    }

    public void assignFunctionDefinition(GraphicalTreeNode<?> element, FunctionDefinition functionDefinition, List<Expression> arguments, List<ImportDirective> imports) {
        this.markAsDirty();
        DFLEmbeddedEditor editor = this.getEditor();
        editor.getDocument().modify((IUnitOfWork)new ApplyFunctionToFieldWork(element, functionDefinition.nameIdentifier(), arguments, imports));
        this.applyFormatter();
        this.refreshGraphicalView();
    }

    public Optional<Expression> assignedExpressionTo(IStructuredSelection selection) {
        GraphicalTreeNode firstElement = (GraphicalTreeNode)selection.getFirstElement();
        Object model = firstElement.getModel();
        Optional<Expression> expression = model instanceof ObjectFieldType ? this.performFindKeyValuePairWork(selection).map(KeyValuePairContainer::getValue) : (model instanceof AttributeFieldType ? this.performFindAttributeElement(selection).map(AttributeElement::getValue) : Optional.of(this.document().getBody().getContent().getElement()));
        return expression;
    }

    public Optional<KeyValuePairContainer> performFindKeyValuePairWork(IStructuredSelection selection) {
        DFLEmbeddedEditor editor = this.getEditor();
        return (Optional)editor.getDocument().readOnly((IUnitOfWork)new FindKeyValuePairWork(selection));
    }

    public Optional<AttributeElement> performFindAttributeElement(IStructuredSelection selection) {
        DFLEmbeddedEditor editor = this.getEditor();
        return (Optional)editor.getDocument().readOnly((IUnitOfWork)new FindAttributeWork(selection));
    }

    public Optional<MultipleKeyValuePairContainer> performFindMultipleKeyValuePairWork(IStructuredSelection selection) {
        DFLEmbeddedEditor editor = this.getEditor();
        return (Optional)editor.getDocument().readOnly((IUnitOfWork)new FindMultipleKeyValuePairWork(selection));
    }

    public Document document() {
        DFLEmbeddedEditor editor = this.getEditor();
        return (Document)editor.getDocument().readOnly((IUnitOfWork)new SelectDocumentExpression());
    }

    public void highlightSelection(IStructuredSelection selection) {
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof GraphicalTreeNode) {
            Object model = ((GraphicalTreeNode)firstElement).getModel();
            if (model instanceof ObjectFieldType) {
                this.highlightCodeKeyValuePair(this.performFindKeyValuePairWork(selection));
            } else if (model instanceof AttributeFieldType) {
                this.highlightCode(this.performFindAttributeElement(selection));
            }
        }
    }

    public void highlightCode(Optional<? extends EObject> expression) {
        XtextSourceViewer viewer = this.getSourceViewer();
        if (expression.isPresent()) {
            ICompositeNode node = NodeModelUtils.getNode((EObject)expression.get());
            if (node != null) {
                String editablePart = node.getText();
                int length = editablePart.length();
                int offset = node.getOffset();
                if (!(expression.get() instanceof AttributeElement)) {
                    try {
                        offset = viewer.getDocument().getLineInformation(node.getStartLine() - 1).getOffset();
                    }
                    catch (BadLocationException badLocationException) {}
                }
                viewer.setSelectedRange(offset, length + node.getOffset() - offset);
                viewer.getTextWidget().showSelection();
            }
        } else {
            viewer.setSelectedRange(0, 0);
        }
    }

    public void assignCaretPosition(Optional<KeyValuePairContainer> keyValuePairContainer) {
        XtextSourceViewer viewer = this.getSourceViewer();
        if (keyValuePairContainer.isPresent()) {
            ICompositeNode node = NodeModelUtils.getNode((EObject)keyValuePairContainer.get().getValue());
            viewer.getTextWidget().setCaretOffset(node.getOffset());
            viewer.getTextWidget().setFocus();
        }
    }

    public XtextSourceViewer getSourceViewer() {
        return this.codeEditor.getViewer();
    }

    public void dispose() {
        this.mappingPainter = null;
        this.codeEditor = null;
        this.graphicalUnitOfWork = null;
        this.context = null;
        if (this.metadataEditors != null && !this.metadataEditors.isEmpty()) {
            this.metadataEditors.clear();
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void cleanDirtyFlag() {
        this.isDirty = false;
    }

    private void markAsDirty() {
        this.isDirty = true;
    }

    public MappingPainter getMappingPainter() {
        return this.mappingPainter;
    }

    public DFLEmbeddedEditor getEditor() {
        return this.codeEditor;
    }

    public ErrorManager<org.eclipse.jface.text.Document, Issue> getErrorManager() {
        return this.errorManager;
    }

    public ITransformationTarget getCurrentTarget() {
        return this.currentTarget;
    }

    public IMuleProject getProject() {
        return this.context.getProject();
    }

    public IMessageFlowNode getMessageFlowNode() {
        return this.context.getNode();
    }

    public IMetaDataProvider getInputMetadataProvider() {
        return this.context.getInputMetadataProvider();
    }

    public IMetaDataProvider getOutputMetadataProvider() {
        return this.context.getOutputMetadataProvider();
    }

    public IMetaDataProvider getOutputMetadataProvider(MessageRowType type) {
        return this.context.getOutputMetadataProvider(type);
    }

    public List<ITreeGraphicalMapping> getMappings() {
        return this.mappingPainter.getMappings();
    }

    public IPropagationInfoProvider getPropagationProvider() {
        return this.context.getPropagationProvider();
    }

    public boolean allowRetypingOuputMetadata() {
        return this.context.getOutputMetadataProvider().allowRetyping();
    }

    public void refresh() {
        if (ErrorManagerHelper.hasSyntaxErrors(this.errorManager, (org.eclipse.jface.text.Document)this.getEditor().getDocument())) {
            this.showInvalidIndicator();
        } else {
            this.refreshGraphicalView();
        }
    }

    public void updateInputTreeLabels() {
        this.mappingPainter.getLeftViewer().refresh(true);
    }

    public void updateOutputTreeLabels() {
        this.mappingPainter.getRightViewer().refresh(true);
    }

    public void highlightCodeKeyValuePair(Optional<KeyValuePairContainer> keyValuePairContainer) {
        this.highlightCode(keyValuePairContainer.map(KeyValuePairContainer::getValue));
    }
}

