/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.graphical;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.validation.Issue;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.dfl.ui.embedded.editor.DFLTextViewerUndoManager;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.ui.dfl.contribution.editor.action.SingleStructuredSelection;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.ErrorManagerHelper;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.TwoWayHandler;
import org.mule.tooling.ui.widgets.errors.ErrorManager;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class OutputTreeDropListener
extends ViewerDropAdapter {
    private TwoWayHandler twoWayHandler;

    public OutputTreeDropListener(TwoWayHandler twoWayHandler, Viewer viewer) {
        super(viewer);
        this.twoWayHandler = twoWayHandler;
    }

    public boolean performDrop(Object data) {
        Object[] sources;
        AnalyticsRecordsFactory.single((String)Events.DRAG_DROP_GRAPHIC_VIEW).track();
        boolean result = false;
        IStructuredSelection selection = (IStructuredSelection)data;
        GraphicalTreeNode targetNode = (GraphicalTreeNode)this.getCurrentTarget();
        Object[] objectArray = sources = selection.toArray();
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            Object sourceNode = objectArray[n2];
            DFLTextViewerUndoManager textViewerUndoManager = (DFLTextViewerUndoManager)this.twoWayHandler.getEditor().getViewer().getUndoManager();
            textViewerUndoManager.beginCrossCompoundChange();
            result = this.performDrop((GraphicalTreeNode)sourceNode, targetNode);
            textViewerUndoManager.endCrossCompoundChange();
            if (result) {
                this.twoWayHandler.deselect();
                this.twoWayHandler.applyFormatter();
                this.twoWayHandler.highlightSelection(new SingleStructuredSelection(targetNode));
                this.twoWayHandler.refreshGraphicalView();
            }
            ++n2;
        }
        return result;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        boolean isUnknownMetadataModel;
        XtextDocument document;
        ErrorManager<Document, Issue> errorManager = this.twoWayHandler.getErrorManager();
        boolean haveIssues = errorManager.haveIssues((Object)(document = this.twoWayHandler.getEditor().getDocument())) && !errorManager.areAll(input -> Severity.WARNING.equals((Object)input.getSeverity()));
        boolean hasSyntaxErrors = haveIssues ? ErrorManagerHelper.hasSyntaxErrors(errorManager, (Document)document) : false;
        GraphicalTreeNode targetNode = (GraphicalTreeNode)target;
        boolean bl = isUnknownMetadataModel = targetNode != null ? MetadataUtils.isUnknown((Object)targetNode.getModel()) : false;
        return !isUnknownMetadataModel && (!haveIssues || !hasSyntaxErrors) && LocalSelectionTransfer.getTransfer().isSupportedType(transferType) && this.getCurrentLocation() == 3;
    }

    private boolean performDrop(GraphicalTreeNode<?> sourceNode, GraphicalTreeNode<?> targetNode) {
        boolean result = this.twoWayHandler.performDrop(sourceNode, targetNode);
        TreeViewer treeViewer = (TreeViewer)this.getViewer();
        TreeItem item = (TreeItem)treeViewer.testFindItem(targetNode);
        treeViewer.getTree().setSelection(item);
        return result;
    }
}

