/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.graphical;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.util.VirtualNode;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingApplier;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingTargetFinder;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingUtils;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetInformation;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.dfl.ui.input.UndefinedMetaDataProvider;
import org.mule.tooling.dfl.ui.utils.GraphicalTreeNodeUtils;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class OutputTreeDoubleClickWork
extends IUnitOfWork.Void<XtextResource> {
    private IStructuredSelection selection;
    private IMuleProject project;

    public OutputTreeDoubleClickWork(ISelection selection, IMuleProject project) {
        this.selection = (IStructuredSelection)selection;
        this.project = project;
    }

    public void process(XtextResource state) throws Exception {
        if (!this.selection.isEmpty()) {
            EList contents = state.getContents();
            if (contents.isEmpty()) {
                return;
            }
            Document document = (Document)contents.get(0);
            GraphicalTreeNode element = (GraphicalTreeNode)this.selection.getFirstElement();
            if (!GraphicalTreeNodeUtils.isUnresolvedMetadataNodeId((GraphicalTreeNode)element)) {
                MappingTargetFinder mappingTargetFinder;
                List targets;
                MappingNode targetMappingNode = new MappingNode(element);
                MappingUtils.configureOutputType((MappingNode)targetMappingNode, (XtextResource)state, (IMuleProject)this.project);
                if (!targetMappingNode.isRoot() && !(targets = (mappingTargetFinder = new MappingTargetFinder(targetMappingNode)).find(state)).isEmpty()) {
                    TargetInformation targetInformation = (TargetInformation)targets.get(0);
                    targetInformation = MappingUtils.expandNodeIfNecessary((TargetInformation)targetInformation, (Document)document);
                    targetInformation = MappingUtils.buildTargetOutputStructure((TargetInformation)targetInformation, (Document)document);
                    UndefinedMetaDataProvider unknownMetaDataProvider = new UndefinedMetaDataProvider();
                    MappingApplier applier = new MappingApplier((MappingNode)new VirtualNode(), targetMappingNode, (IMetaDataProvider)unknownMetaDataProvider, (IMetaDataProvider)unknownMetaDataProvider);
                    applier.apply(state, targetInformation);
                }
            }
        }
    }
}

