/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.graphical;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.validation.Issue;
import org.mule.tooling.dfl.ui.embedded.editor.DFLTextViewerUndoManager;
import org.mule.tooling.dfl.ui.graphical.MappingPainter;
import org.mule.tooling.dfl.ui.graphical.WeaveUIConstants;
import org.mule.tooling.dfl.ui.graphical.listener.ExpanderCollapserHandler;
import org.mule.tooling.dfl.ui.graphical.model.IGraphicalMapping;
import org.mule.tooling.dfl.ui.graphical.model.ITreeGraphicalMapping;
import org.mule.tooling.dfl.ui.graphical.model.TreeGraphicalMappingAdapter;
import org.mule.tooling.dfl.ui.graphical.providers.IConnectorProvider;
import org.mule.tooling.dfl.ui.graphical.providers.LeftConnectorProvider;
import org.mule.tooling.dfl.ui.graphical.providers.RightConnectorProvider;
import org.mule.tooling.dfl.ui.graphical.view2code.KeyValuePairContainer;
import org.mule.tooling.ui.dfl.contribution.editor.action.SingleStructuredSelection;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.CodeHighlightingService;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.GraphicalUnitOfWorkCallback;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.OutputTreeDropListener;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.RowHeightDefinition;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.TwoWayHandler;
import org.mule.tooling.ui.dfl.contribution.editor.script.DeleteAssignmentAction;
import org.mule.tooling.ui.dfl.contribution.editor.script.WeaveGraphicalTreeLabelProvider;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.InputContextMenuProvider;

public class GraphicalListenerHandler
implements GraphicalUnitOfWorkCallback {
    private MappingPainter mappingPainter;
    private ExpanderCollapserHandler expanderCollapserHandler;
    private InputContextMenuProvider inputContextMenuProvider;
    private HighlightingProvider leftHighlightingProvider = new HighlightingProvider();
    private HighlightingProvider rightHighlightingProvider = new HighlightingProvider();
    private ShortcutsHandler leftShortcutsHandler = new LeftShortcutsHandler();
    private RightShortcutsHandler rightShortcutsHandler = new RightShortcutsHandler();

    public GraphicalListenerHandler(MappingPainter mappingPainter, InputContextMenuProvider inputContextMenuProvider) {
        this.mappingPainter = mappingPainter;
        this.inputContextMenuProvider = inputContextMenuProvider;
    }

    public void registerListener(TwoWayHandler twoWayHandler) {
        TreeViewer inputTreeViewer = this.mappingPainter.getLeftViewer();
        TreeViewer outputTreeViewer = this.mappingPainter.getRightViewer();
        this.expanderCollapserHandler = new ExpanderCollapserHandler(inputTreeViewer, outputTreeViewer);
        OutputTreeDropListener dropListener = new OutputTreeDropListener(twoWayHandler, (Viewer)outputTreeViewer);
        this.mappingPainter.getRightViewer().addDropSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)dropListener);
        inputTreeViewer.getTree().addListener(41, (Listener)new RowHeightDefinition());
        outputTreeViewer.getTree().addListener(41, (Listener)new RowHeightDefinition());
        inputTreeViewer.getTree().addSelectionListener((SelectionListener)this.leftHighlightingProvider);
        outputTreeViewer.getTree().addSelectionListener((SelectionListener)this.rightHighlightingProvider);
        inputTreeViewer.getTree().addKeyListener((KeyListener)this.leftShortcutsHandler);
        outputTreeViewer.getTree().addKeyListener((KeyListener)this.rightShortcutsHandler);
        this.leftShortcutsHandler.setTwoWayHandler(twoWayHandler);
        this.leftShortcutsHandler.setInputContextMenuProvider(this.inputContextMenuProvider);
        this.rightShortcutsHandler.setTwoWayHandler(twoWayHandler);
        this.rightShortcutsHandler.setInputContextMenuProvider(this.inputContextMenuProvider);
        inputTreeViewer.addTreeListener((ITreeViewerListener)this.expanderCollapserHandler);
        outputTreeViewer.addTreeListener((ITreeViewerListener)this.expanderCollapserHandler);
        HoverListener hoverListener = new HoverListener(this.mappingPainter.getLeftViewer(), this.mappingPainter);
        inputTreeViewer.getTree().addMouseMoveListener((MouseMoveListener)hoverListener);
        inputTreeViewer.getTree().addMouseTrackListener((MouseTrackListener)hoverListener);
        inputTreeViewer.getTree().getVerticalBar().addSelectionListener((SelectionListener)hoverListener);
        outputTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new CodeHighlightingService(twoWayHandler));
        outputTreeViewer.addDoubleClickListener((IDoubleClickListener)new OutputTreeViewerDoubleClick(twoWayHandler));
    }

    @Override
    public void processMappings(List<IGraphicalMapping> mappings) {
        WeaveGraphicalTreeLabelProvider labelProvider;
        FilteredTree leftFilteredTree = this.mappingPainter.getLeftFilteredTree();
        FilteredTree rightFilteredTree = this.mappingPainter.getRightFilteredTree();
        ArrayList treeMappings = Lists.newArrayListWithExpectedSize((int)mappings.size());
        for (IGraphicalMapping iGraphicalMapping : mappings) {
            treeMappings.add(new TreeGraphicalMappingAdapter(leftFilteredTree, rightFilteredTree, iGraphicalMapping));
        }
        this.mappingPainter.reload((List)treeMappings);
        if (this.inputContextMenuProvider != null) {
            this.inputContextMenuProvider.updateMappings(treeMappings);
        }
        LeftConnectorProvider leftConnectorProvider = new LeftConnectorProvider(leftFilteredTree, (List)treeMappings);
        RightConnectorProvider rightConnectorProvider = new RightConnectorProvider(rightFilteredTree, leftFilteredTree, (List)treeMappings);
        this.leftHighlightingProvider.setConnectorProvider((IConnectorProvider)leftConnectorProvider);
        this.leftHighlightingProvider.setMirrorConnectorProvider((IConnectorProvider)rightConnectorProvider);
        this.rightHighlightingProvider.setConnectorProvider((IConnectorProvider)rightConnectorProvider);
        this.rightHighlightingProvider.setMirrorConnectorProvider((IConnectorProvider)leftConnectorProvider);
        this.leftShortcutsHandler.setConnectorProvider((IConnectorProvider)leftConnectorProvider);
        this.rightShortcutsHandler.setConnectorProvider((IConnectorProvider)rightConnectorProvider);
        if (this.mappingPainter.getLeftViewer().getLabelProvider() instanceof WeaveGraphicalTreeLabelProvider) {
            labelProvider = (WeaveGraphicalTreeLabelProvider)this.mappingPainter.getLeftViewer().getLabelProvider();
            labelProvider.setConnectorProvider((IConnectorProvider)leftConnectorProvider);
            this.mappingPainter.getLeftViewer().refresh();
        }
        if (this.mappingPainter.getRightViewer().getLabelProvider() instanceof WeaveGraphicalTreeLabelProvider) {
            labelProvider = (WeaveGraphicalTreeLabelProvider)this.mappingPainter.getRightViewer().getLabelProvider();
            labelProvider.setConnectorProvider((IConnectorProvider)rightConnectorProvider);
            this.mappingPainter.getRightViewer().refresh();
        }
        this.expanderCollapserHandler.storeExpandedPaths();
    }

    private static final class HighlightingProvider
    implements SelectionListener {
        private IConnectorProvider connectorProvider;
        private IConnectorProvider mirrorConnectorProvider;

        private HighlightingProvider() {
        }

        public void widgetSelected(SelectionEvent e) {
            TreeItem currentItem = (TreeItem)e.item;
            if (this.connectorProvider != null && this.mirrorConnectorProvider != null && currentItem != null) {
                List mappings = this.connectorProvider.getMappings();
                ArrayList mirrorItems = Lists.newArrayList();
                for (ITreeGraphicalMapping mapping : mappings) {
                    TreeItem connectorItem = this.connectorProvider.getConnectorItem(mapping);
                    if (connectorItem != currentItem) continue;
                    mirrorItems.add(this.connectorProvider.getMirrorConnectorItem(mapping));
                }
                Tree mirrorTree = this.mirrorConnectorProvider.getFilteredTree().getViewer().getTree();
                if (mirrorItems.size() > 0) {
                    mirrorTree.setSelection(mirrorItems.toArray(new TreeItem[0]));
                } else {
                    mirrorTree.deselectAll();
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void setConnectorProvider(IConnectorProvider connectorProvider) {
            this.connectorProvider = connectorProvider;
        }

        public void setMirrorConnectorProvider(IConnectorProvider mirrorConnectorProvider) {
            this.mirrorConnectorProvider = mirrorConnectorProvider;
        }
    }

    private static final class HoverListener
    implements MouseMoveListener,
    MouseTrackListener,
    SelectionListener {
        private Color background;
        private TreeItem prevItem = null;
        private long lastScrollingTimestamp = -1L;
        private TreeViewer viewer;
        private MappingPainter mappingPainter;

        public HoverListener(TreeViewer viewer, MappingPainter mappingPainter) {
            this.viewer = viewer;
            this.mappingPainter = mappingPainter;
        }

        public void mouseMove(MouseEvent event) {
            if (this.lastScrollingTimestamp + (long)this.getScrollingThreshhold() < System.currentTimeMillis()) {
                TreeItem item = this.viewer.getTree().getItem(new Point(event.x, event.y));
                if (this.prevItem != null && !this.prevItem.equals(item) && !this.prevItem.isDisposed()) {
                    this.prevItem.setBackground(this.background);
                }
                if (item != null && !item.equals(this.prevItem)) {
                    this.background = item.getBackground();
                    this.prevItem = item;
                    item.setBackground(WeaveUIConstants.ALUMINUM_2);
                    this.mappingPainter.setHoverItem(item);
                    this.mappingPainter.reload();
                }
            }
        }

        public void mouseEnter(MouseEvent e) {
        }

        public void mouseExit(MouseEvent e) {
            if (this.prevItem != null && !this.prevItem.isDisposed()) {
                this.prevItem.setBackground(this.background);
                this.prevItem = null;
                this.mappingPainter.setHoverItem(null);
                this.mappingPainter.reload();
            }
        }

        public void mouseHover(MouseEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.lastScrollingTimestamp = System.currentTimeMillis();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private int getScrollingThreshhold() {
            return 150;
        }
    }

    private static final class LeftShortcutsHandler
    extends ShortcutsHandler {
        private LeftShortcutsHandler() {
        }

        @Override
        public void goToMapping() {
            TreeItem[] selection = this.connectorProvider.getFilteredTree().getViewer().getTree().getSelection();
            if (selection.length != 0) {
                ArrayList<ITreeGraphicalMapping> multiplesOutput = new ArrayList<ITreeGraphicalMapping>();
                TreeItem selectedItem = selection[0];
                List mappings = this.connectorProvider.getMappings();
                for (ITreeGraphicalMapping mapping : mappings) {
                    TreeItem connectorItem = this.connectorProvider.getConnectorItem(mapping);
                    if (connectorItem != selectedItem) continue;
                    multiplesOutput.add(mapping);
                }
                if (multiplesOutput.size() == 1) {
                    Optional<KeyValuePairContainer> keyValuePairContainer = this.twoWayHandler.performFindKeyValuePairWork(new SingleStructuredSelection(((ITreeGraphicalMapping)multiplesOutput.get(0)).getRightItem().getNode()));
                    this.twoWayHandler.assignCaretPosition(keyValuePairContainer);
                } else if (multiplesOutput.size() > 1) {
                    this.inputContextMenuProvider.setGoToAction(true);
                    this.twoWayHandler.getMappingPainter().getLeftFilteredTree().getViewer().getControl().getMenu().setVisible(true);
                }
            }
        }

        @Override
        public void delete() {
        }
    }

    private static final class OutputTreeViewerDoubleClick
    implements IDoubleClickListener {
        private final TwoWayHandler twoWayHandler;

        private OutputTreeViewerDoubleClick(TwoWayHandler twoWayHandler) {
            this.twoWayHandler = twoWayHandler;
        }

        public void doubleClick(DoubleClickEvent event) {
            if (this.scriptHasErrors().booleanValue()) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Invalid script", (String)"The current state is not valid. Fix the script to enable code generation.");
                return;
            }
            DFLTextViewerUndoManager textViewerUndoManager = (DFLTextViewerUndoManager)this.twoWayHandler.getEditor().getViewer().getUndoManager();
            textViewerUndoManager.beginCrossCompoundChange();
            this.twoWayHandler.performOutputTreeDoubleClickWork(event);
            textViewerUndoManager.endCrossCompoundChange();
            this.twoWayHandler.deselect();
            this.twoWayHandler.applyFormatter();
            this.twoWayHandler.highlightSelection((IStructuredSelection)event.getSelection());
            this.twoWayHandler.refreshGraphicalView();
        }

        private Boolean scriptHasErrors() {
            XtextDocument document = this.twoWayHandler.getEditor().getDocument();
            List maybeIssues = this.twoWayHandler.getErrorManager().getIssues((Object)document);
            return Optional.ofNullable(maybeIssues).map(this::containsAnyError).orElse(false);
        }

        private boolean containsAnyError(List<Issue> issues) {
            return issues.stream().anyMatch(issue -> Severity.ERROR.equals((Object)issue.getSeverity()));
        }
    }

    private static final class RightShortcutsHandler
    extends ShortcutsHandler {
        private RightShortcutsHandler() {
        }

        @Override
        public void goToMapping() {
            TreeItem[] selection = this.connectorProvider.getFilteredTree().getViewer().getTree().getSelection();
            if (selection.length != 0) {
                TreeItem[] treeItemArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem selectedItem = treeItemArray[n2];
                    List mappings = this.connectorProvider.getMappings();
                    for (ITreeGraphicalMapping mapping : mappings) {
                        TreeItem connectorItem = this.connectorProvider.getConnectorItem(mapping);
                        if (connectorItem != selectedItem) continue;
                        Optional<KeyValuePairContainer> keyValuePairContainer = this.twoWayHandler.performFindKeyValuePairWork(new SingleStructuredSelection(mapping.getRightItem().getNode()));
                        this.twoWayHandler.assignCaretPosition(keyValuePairContainer);
                        return;
                    }
                    ++n2;
                }
            }
        }

        @Override
        public void delete() {
            DeleteAssignmentAction deleteAssignmentAction = new DeleteAssignmentAction(this.twoWayHandler, (Viewer)this.connectorProvider.getFilteredTree().getViewer());
            if (deleteAssignmentAction.isEnabled()) {
                deleteAssignmentAction.run();
            }
        }
    }

    private static abstract class ShortcutsHandler
    extends KeyAdapter {
        protected TwoWayHandler twoWayHandler;
        protected IConnectorProvider connectorProvider;
        protected InputContextMenuProvider inputContextMenuProvider;

        private ShortcutsHandler() {
        }

        public void setConnectorProvider(IConnectorProvider connectorProvider) {
            this.connectorProvider = connectorProvider;
        }

        public void setInputContextMenuProvider(InputContextMenuProvider inputContextMenuProvider) {
            this.inputContextMenuProvider = inputContextMenuProvider;
        }

        public void setTwoWayHandler(TwoWayHandler twoWayHandler) {
            this.twoWayHandler = twoWayHandler;
        }

        public void keyPressed(KeyEvent e) {
            boolean isDel;
            boolean isShiftPress = (e.stateMask & 0x20000) == 131072;
            boolean isCommandPress = (e.stateMask & 0x400000) == 0x400000 || (e.stateMask & 0x40000) == 262144;
            boolean bl = isDel = 127 == e.keyCode;
            if (isCommandPress && isShiftPress && e.keyCode == 103) {
                this.goToMapping();
            } else if (isDel) {
                this.delete();
            }
        }

        public abstract void delete();

        public abstract void goToMapping();
    }
}

