/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.graphical;

import java.util.List;
import java.util.Optional;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.view2code.KeyValuePairContainer;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingTargetFinder;
import org.mule.tooling.dfl.ui.graphical.view2code.MultipleKeyValuePairContainer;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetInformation;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class FindMultipleKeyValuePairWork
implements IUnitOfWork<Optional<MultipleKeyValuePairContainer>, XtextResource> {
    private final IStructuredSelection selection;

    public FindMultipleKeyValuePairWork(IStructuredSelection selection) {
        this.selection = selection;
    }

    public Optional<MultipleKeyValuePairContainer> exec(XtextResource state) throws Exception {
        if (!this.selection.isEmpty()) {
            MultipleKeyValuePairContainer multipleKeyValuePairContainer = new MultipleKeyValuePairContainer();
            for (GraphicalTreeNode element : this.selection) {
                MappingNode targetMappingNode = new MappingNode(element);
                MappingTargetFinder mappingTargetFinder = new MappingTargetFinder(targetMappingNode);
                List targets = mappingTargetFinder.find(state);
                if (targets.isEmpty()) continue;
                for (TargetInformation targetInformation : targets) {
                    Optional existingKeyValuePairContainer = targetInformation.getExistingKeyValuePair();
                    if (!existingKeyValuePairContainer.isPresent()) continue;
                    multipleKeyValuePairContainer.addKeyValuePairContainer((KeyValuePairContainer)existingKeyValuePairContainer.get());
                }
            }
            return Optional.of(multipleKeyValuePairContainer);
        }
        return Optional.empty();
    }
}

