/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.graphical;

import java.util.List;
import java.util.Optional;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.mule.tooling.dfl.dFL.AttributeElement;
import org.mule.tooling.dfl.ui.graphical.references.ISegment;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.view2code.KeyValuePairContainer;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingTargetFinder;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetInformation;
import org.mule.tooling.dfl.ui.utils.GraphicalTreeNodeUtils;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.AttributeFinder;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class FindAttributeWork
implements IUnitOfWork<Optional<AttributeElement>, XtextResource> {
    private final IStructuredSelection selection;

    public FindAttributeWork(IStructuredSelection selection) {
        this.selection = selection;
    }

    public Optional<AttributeElement> exec(XtextResource state) throws Exception {
        GraphicalTreeNode element;
        if (!this.selection.isEmpty() && !GraphicalTreeNodeUtils.isUnresolvedMetadataNodeId((GraphicalTreeNode)(element = (GraphicalTreeNode)this.selection.getFirstElement()))) {
            List targets;
            MappingNode targetMappingNode = new MappingNode(element);
            MappingTargetFinder mappingTargetFinder = new MappingTargetFinder(targetMappingNode);
            Optional mayBeAttributeSegment = targetMappingNode.getReference().getAttributeSegment();
            if (mayBeAttributeSegment.isPresent() && !(targets = mappingTargetFinder.find(state)).isEmpty()) {
                for (TargetInformation targetInformation : targets) {
                    Optional existingKeyValuePairContainer = targetInformation.getExistingKeyValuePair();
                    if (!existingKeyValuePairContainer.isPresent()) continue;
                    return AttributeFinder.findAttribute(((KeyValuePairContainer)existingKeyValuePairContainer.get()).getKey(), (ISegment)mayBeAttributeSegment.get());
                }
            }
        }
        return Optional.empty();
    }
}

