/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.graphical;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.resource.XtextResource;
import org.mule.tooling.dfl.dFL.BinaryFunction;
import org.mule.tooling.dfl.dFL.DFLFactory;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.FunctionCall;
import org.mule.tooling.dfl.dFL.FunctionCallArgs;
import org.mule.tooling.dfl.dFL.ImportDirective;
import org.mule.tooling.dfl.dFL.ImportWithSubElements;
import org.mule.tooling.dfl.dFL.SingleImportedElement;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.DflFactoryUtils;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.AbstractAssignExpressionWork;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;

public class ApplyFunctionToFieldWork
extends AbstractAssignExpressionWork {
    private NameIdentifier functionName;
    private List<Expression> arguments;
    private List<ImportDirective> imports;

    public ApplyFunctionToFieldWork(GraphicalTreeNode<?> targetNode, NameIdentifier functionName, List<Expression> arguments, List<ImportDirective> imports) {
        super(targetNode);
        this.functionName = functionName;
        this.arguments = arguments;
        this.imports = imports;
    }

    public void process(XtextResource state) throws Exception {
        Document document = (Document)state.getContents().get(0);
        Expression valueExpression = ApplyFunctionToFieldWork.createValueExpression(this.arguments, this.functionName);
        this.assignExpression(state, document, valueExpression);
    }

    public static Expression createValueExpression(List<Expression> arguments, NameIdentifier functionName) {
        BinaryFunction valueExpression;
        if (arguments.size() == 2) {
            DflFactoryUtils.BinaryFunctionWrapper createBinaryFunction = DflFactoryUtils.newWrappedBinaryFunction((String)functionName.localName().name());
            createBinaryFunction.setLeft(arguments.get(0));
            createBinaryFunction.setRight(arguments.get(1));
            valueExpression = createBinaryFunction.get();
        } else {
            FunctionCall functionCall = DFLFactory.eINSTANCE.createFunctionCall();
            functionCall.setName(functionName.localName().name());
            FunctionCallArgs args = DFLFactory.eINSTANCE.createFunctionCallArgs();
            for (Expression arg : arguments) {
                args.getParameters().add((Object)arg);
            }
            functionCall.setParameters(args);
            valueExpression = functionCall;
        }
        return valueExpression;
    }

    @Override
    public List<ImportDirective> resolveImportDirectives() {
        if (this.functionName.parent().isDefined() && !((NameIdentifier)this.functionName.parent().get()).name().equals(NameIdentifier.CORE_MODULE().name())) {
            ImportWithSubElements importWithSubElements = ApplyFunctionToFieldWork.createImportDirective(this.functionName);
            ArrayList<ImportDirective> importedResult = new ArrayList<ImportDirective>(this.imports);
            importedResult.add((ImportDirective)importWithSubElements);
            return importedResult;
        }
        return this.imports;
    }

    public static ImportWithSubElements createImportDirective(NameIdentifier functionName) {
        String moduleName = ((NameIdentifier)functionName.parent().get()).name();
        SingleImportedElement createSingleImportedElement = DFLFactory.eINSTANCE.createSingleImportedElement();
        createSingleImportedElement.setName(functionName.localName().name());
        ImportWithSubElements importWithSubElements = DFLFactory.eINSTANCE.createImportWithSubElements();
        importWithSubElements.setSource(moduleName);
        importWithSubElements.getElements().add((Object)createSingleImportedElement);
        return importWithSubElements;
    }
}

