/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.graphical;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.mule.tooling.dfl.dFL.Body;
import org.mule.tooling.dfl.dFL.Directive;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Header;
import org.mule.tooling.dfl.dFL.ImportDirective;
import org.mule.tooling.dfl.dFL.ImportModuleOnly;
import org.mule.tooling.dfl.dFL.ImportWithSubElements;
import org.mule.tooling.dfl.dFL.ImportedElement;
import org.mule.tooling.dfl.dFL.SingleImportedElement;
import org.mule.tooling.dfl.dFL.StarImportedElement;
import org.mule.tooling.dfl.dFL.VersionDirective;
import org.mule.tooling.dfl.ui.scafflod.ScaffoldingHelper;
import org.mule.tooling.dfl.util.DFLModelHelper;

public abstract class AbstractExpressionWork
extends IUnitOfWork.Void<XtextResource> {
    public abstract List<ImportDirective> resolveImportDirectives();

    protected void mergeImports(Document document) {
        this.addHeaderIfNotExists(document);
        Header header = document.getBody().getHeader();
        ArrayList<ImportDirective> toAdd = new ArrayList<ImportDirective>();
        List oldImportDirectives = DFLModelHelper.getImportDirectives((Document)document);
        List<ImportDirective> newImportDirectives = this.resolveImportDirectives();
        for (ImportDirective importDirective : newImportDirectives) {
            Optional<ImportDirective> findFirst;
            if (importDirective instanceof ImportModuleOnly) {
                findFirst = oldImportDirectives.stream().filter(id -> {
                    if (id instanceof ImportModuleOnly) {
                        return id.getSource().equals(importDirective.getSource());
                    }
                    return false;
                }).findFirst();
                if (findFirst.isPresent()) continue;
                toAdd.add(importDirective);
                continue;
            }
            if (!(importDirective instanceof ImportWithSubElements)) continue;
            findFirst = oldImportDirectives.stream().filter(id -> {
                if (id instanceof ImportWithSubElements) {
                    return id.getSource().equals(importDirective.getSource());
                }
                return false;
            }).findFirst();
            if (findFirst.isPresent()) {
                this.manageDuplicated(header, importDirective, (ImportWithSubElements)findFirst.get(), toAdd);
                continue;
            }
            toAdd.add(importDirective);
        }
        this.addDirectives((EList<Directive>)header.getDirectives(), toAdd);
    }

    private void manageDuplicated(Header header, ImportDirective importDirective, ImportWithSubElements matchedImport, List<ImportDirective> toAdd) {
        EList matchedElements = matchedImport.getElements();
        boolean matchedImportAll = matchedElements.stream().anyMatch(s -> s instanceof StarImportedElement);
        if (!matchedImportAll) {
            ArrayList<ImportedElement> elementsToAdd = new ArrayList<ImportedElement>();
            ImportWithSubElements toMerge = (ImportWithSubElements)importDirective;
            EList elementsToMerge = toMerge.getElements();
            for (ImportedElement elementToMerge : elementsToMerge) {
                SingleImportedElement singleImportedElement = (SingleImportedElement)elementToMerge;
                boolean anyMatch = matchedElements.stream().anyMatch(e -> ((SingleImportedElement)e).getName().equals(singleImportedElement.getName()));
                if (anyMatch) continue;
                elementsToAdd.add(elementToMerge);
            }
            matchedElements.addAll(elementsToAdd);
            toAdd.add(0, (ImportDirective)matchedImport);
            header.getDirectives().remove((Object)matchedImport);
        }
    }

    private void addDirectives(EList<Directive> directives, List<ImportDirective> toAdd) {
        if (directives.size() > 0 && directives.get(0) instanceof VersionDirective) {
            directives.addAll(1, toAdd);
        } else {
            directives.addAll(0, toAdd);
        }
    }

    private void addHeaderIfNotExists(Document document) {
        Body body = document.getBody();
        if (body.getHeader() == null) {
            Header header = ScaffoldingHelper.buildHeader((Body)body);
            ScaffoldingHelper.buildVersionDirective((Header)header);
            body.setHeader(header);
        }
    }
}

