/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.graphical;

import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.XtextResource;
import org.mule.tooling.dfl.dFL.Attribute;
import org.mule.tooling.dfl.dFL.AttributeElement;
import org.mule.tooling.dfl.dFL.Attributes;
import org.mule.tooling.dfl.dFL.DFLFactory;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.Key;
import org.mule.tooling.dfl.dFL.KeyExpression;
import org.mule.tooling.dfl.dFL.KeyValuePair;
import org.mule.tooling.dfl.dFL.NullLiteral;
import org.mule.tooling.dfl.dFL.StringLiteral;
import org.mule.tooling.dfl.ui.graphical.references.ISegment;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.view2code.KeyValuePairContainer;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingTargetFinder;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingUtils;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetInformation;
import org.mule.tooling.dfl.ui.scafflod.ScaffoldingHelper;
import org.mule.tooling.dfl.util.DFLModelHelper;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.AbstractExpressionWork;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.AttributeFinder;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public abstract class AbstractAssignExpressionWork
extends AbstractExpressionWork {
    private GraphicalTreeNode<?> targetNode;

    public AbstractAssignExpressionWork(GraphicalTreeNode<?> targetNode) {
        this.targetNode = targetNode;
    }

    public void assignExpression(XtextResource state, Document document, Expression valueExpression) throws Exception {
        this.mergeImports(document);
        MappingNode newTargetMappingNode = new MappingNode(this.targetNode);
        if (newTargetMappingNode.isRoot()) {
            document.getBody().getContent().setElement(valueExpression);
        } else {
            MappingTargetFinder mappingTargetFinder = new MappingTargetFinder(newTargetMappingNode);
            List targets = mappingTargetFinder.find(state);
            Optional mayBeAttributeSegment = newTargetMappingNode.getReference().getAttributeSegment();
            if (targets.size() == 1) {
                TargetInformation targetInformation = (TargetInformation)targets.get(0);
                targetInformation = MappingUtils.expandNodeIfNecessary((TargetInformation)targetInformation, (Document)document);
                targetInformation = MappingUtils.buildTargetOutputStructure((TargetInformation)targetInformation, (Document)document);
                KeyValuePairContainer keyValuePair = this.getOrCreateKeyValuePair(targetInformation, document, newTargetMappingNode);
                if (mayBeAttributeSegment.isPresent()) {
                    ISegment attributeSegment = (ISegment)mayBeAttributeSegment.get();
                    Key key = keyValuePair.getKey();
                    Attributes attributes = key.getAttributes() != null ? key.getAttributes() : DFLFactory.eINSTANCE.createAttributes();
                    Optional<AttributeElement> findResult = AttributeFinder.findAttribute(key, attributeSegment);
                    if (findResult.isPresent()) {
                        AttributeElement attributeElement = findResult.get();
                        attributeElement.setValue(valueExpression);
                    } else {
                        Attribute attribute = DFLFactory.eINSTANCE.createAttribute();
                        QName qName = ScaffoldingHelper.defineNamespace((Document)document, (QName)attributeSegment.getQName());
                        DFLModelHelper.assignNamespace((Attribute)attribute, (QName)qName);
                        attribute.setName(DFLModelHelper.quoteIfNecessary((String)attributeSegment.getQName().getLocalPart()));
                        attribute.setValue(valueExpression);
                        attributes.getAttributes().add((Object)attribute);
                    }
                    key.setAttributes(attributes);
                } else {
                    keyValuePair.setValue(valueExpression);
                }
            }
        }
    }

    private KeyValuePairContainer getOrCreateKeyValuePair(TargetInformation targetInformation, Document document, MappingNode newTargetMappingNode) {
        Optional existingKeyValuePairContainer = targetInformation.getExistingKeyValuePair();
        if (existingKeyValuePairContainer.isPresent()) {
            return (KeyValuePairContainer)existingKeyValuePairContainer.get();
        }
        KeyValuePair keyValuePair = DFLFactory.eINSTANCE.createKeyValuePair();
        Key key = DFLFactory.eINSTANCE.createKey();
        StringLiteral keyLiteral = DFLFactory.eINSTANCE.createStringLiteral();
        QName qName = newTargetMappingNode.getReference().getQName();
        qName = ScaffoldingHelper.defineNamespace((Document)document, (QName)qName);
        DFLModelHelper.assignNamespace((Key)key, (QName)qName);
        keyLiteral.setValue(DFLModelHelper.quoteIfNecessary((String)qName.getLocalPart()));
        key.setValue((KeyExpression)keyLiteral);
        keyValuePair.setKey(key);
        NullLiteral nullLiteral = DFLFactory.eINSTANCE.createNullLiteral();
        nullLiteral.setValue("null");
        keyValuePair.setValue((Expression)nullLiteral);
        targetInformation.getTargetContainer().addObject((EObject)keyValuePair, targetInformation.getTargetContext().getCurrentSegment());
        return new KeyValuePairContainer((EObject)keyValuePair);
    }
}

