/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.datasense.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.tooling.ui.dfl.contribution.editor.datasense.model.IObjectBuilder;

public class ObjectBuilder
implements IObjectBuilder,
TypeBuilder<MetadataType> {
    private final MetadataFormat contentType;
    private final Class<?> implementationClass;
    private final List<MetadataField> fields = new ArrayList<MetadataField>();

    public ObjectBuilder(MetadataFormat contentType, Class<?> implementationClass) {
        this.contentType = contentType;
        this.implementationClass = implementationClass;
    }

    @Override
    public IObjectBuilder addField(QName name, TypeBuilder<MetadataType> metaDataModel, TypeAnnotation ... properties) {
        MetadataField field = this.createField(name, metaDataModel, properties);
        this.fields.add(field);
        return this;
    }

    private MetadataField createField(QName name, TypeBuilder<?> builder, TypeAnnotation ... properties) {
        if (builder instanceof WithAnnotation) {
            if (!StringUtils.isEmpty((String)name.getPrefix())) {
                ((WithAnnotation)builder).with((TypeAnnotation)new LabelAnnotation(name.getPrefix() + ":" + name.getLocalPart()));
            }
            TypeAnnotation[] typeAnnotationArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                TypeAnnotation metaDataFieldProperty = typeAnnotationArray[n2];
                ((WithAnnotation)builder).with(metaDataFieldProperty);
                ++n2;
            }
        }
        return new MetadataField(name, builder);
    }

    @Override
    public MetadataType build() {
        ObjectType result;
        if (MetadataFormat.XML.equals((Object)this.contentType)) {
            ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)this.contentType).objectType();
            List<MetadataField> convertedFields = this.convertRepeatedFieldToList();
            this.addFields(builder, convertedFields);
            result = builder.build();
        } else if (MetadataFormat.JAVA.equals((Object)this.contentType)) {
            if (this.implementationClass == null) {
                ObjectTypeBuilder builder = new ObjectTypeBuilder(this.contentType);
                this.addFields(builder, this.fields);
                result = builder.build();
            } else {
                result = new JavaTypeLoader(this.implementationClass.getClassLoader()).load(this.implementationClass);
            }
        } else {
            ObjectTypeBuilder builder = new ObjectTypeBuilder(this.contentType);
            this.addFields(builder, this.fields);
            result = builder.build();
        }
        return result;
    }

    protected void addFields(ObjectTypeBuilder objectTypeBuilder, List<MetadataField> fields) {
        for (MetadataField field : fields) {
            ObjectFieldTypeBuilder newField = objectTypeBuilder.addField();
            newField.key(field.name);
            newField.value(field.builder);
        }
    }

    private List<MetadataField> convertRepeatedFieldToList() {
        LinkedHashMap<QName, Integer> fieldRepetition = new LinkedHashMap<QName, Integer>();
        ArrayList<MetadataField> uniqueFields = new ArrayList<MetadataField>();
        for (MetadataField field : this.fields) {
            QName name = field.name;
            if (fieldRepetition.containsKey(name)) {
                fieldRepetition.put(name, (Integer)fieldRepetition.get(name) + 1);
                continue;
            }
            fieldRepetition.put(name, 1);
            uniqueFields.add(field);
        }
        ArrayList<MetadataField> convertedFields = new ArrayList<MetadataField>();
        for (MetadataField field : uniqueFields) {
            QName name = field.name;
            if ((Integer)fieldRepetition.get(name) > 1) {
                Set annotationsSet = field.builder.build().getAnnotations();
                TypeAnnotation[] properties = annotationsSet.toArray(new TypeAnnotation[annotationsSet.size()]);
                ArrayTypeBuilder arrayBuilder = BaseTypeBuilder.create((MetadataFormat)this.contentType).arrayType().of(field.builder);
                convertedFields.add(this.createField(name, (TypeBuilder<?>)arrayBuilder, properties));
                continue;
            }
            convertedFields.add(field);
        }
        return convertedFields;
    }

    private final class MetadataField {
        private final QName name;
        private final TypeBuilder<?> builder;

        public MetadataField(QName name, TypeBuilder<?> builder) {
            this.name = name;
            this.builder = builder;
        }
    }
}

