/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.datasense;

import java.util.Optional;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.datasense.MetadataHelper;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.ui.dfl.contribution.editor.datasense.MetadataOperations;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.TwoWayHandler;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageRowType;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class UpdateMetadataOperation {
    private MetadataResult result;
    private MessageRowType rowType;
    private TwoWayHandler twoWayHandler;
    private Optional<String> propertyName;

    public UpdateMetadataOperation(TwoWayHandler twoWayHandler, MetadataResult result, MessageRowType rowType, Optional<String> propertyName) {
        this.twoWayHandler = twoWayHandler;
        this.result = result;
        this.rowType = rowType;
        this.propertyName = propertyName;
    }

    public UpdateMetadataOperation(TwoWayHandler twoWayHandler, MetadataResult result, MessageRowType rowType, GraphicalTreeNode<?> graphicalTreeNode) {
        this(twoWayHandler, result, rowType, MetadataOperations.propertyName(twoWayHandler, rowType, graphicalTreeNode));
    }

    public void update() {
        MetadataHelper.updateMetadata((MessageRowType)this.rowType, (IMessageFlowNode)this.twoWayHandler.getMessageFlowNode(), (IMuleProject)this.twoWayHandler.getProject(), this.propertyName, (MetadataResult)this.result);
        if (MessageRowType.OUTPUT_PAYLOAD == this.rowType) {
            this.refreshHeader(this.result.getMetadataType());
        }
        MetadataOperations.reloadPropagation(this.twoWayHandler);
    }

    private void refreshHeader(final MetadataType model) {
        this.twoWayHandler.getEditor().getDocument().modify((IUnitOfWork)new IUnitOfWork<Void, XtextResource>(){

            public Void exec(XtextResource state) throws Exception {
                MappingUtils.configureOutputType((MetadataType)model, (XtextResource)state, (IMuleProject)UpdateMetadataOperation.this.twoWayHandler.getProject());
                return null;
            }
        });
    }
}

