/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.datasense;

import java.util.Optional;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.DFLEditor;
import org.mule.tooling.ui.dfl.contribution.editor.datasense.CustomTreeEditor;
import org.mule.tooling.ui.dfl.contribution.editor.datasense.MetadataOperations;
import org.mule.tooling.ui.dfl.contribution.editor.datasense.UpdateMetadataOperation;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.TwoWayHandler;
import org.mule.tooling.ui.dfl.contribution.editor.script.EditorContext;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.InputContextMenuProvider;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.IMappingModel;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageRowType;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionWizard;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionWizardDialog;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class TreeEditorHelper {
    public static Composite createTreeMetadataEditor(Tree tree, GraphicalTreeNode<?> node, TreeItem item, MessageRowType rowType, EditorContext context, IMappingModel transformModel, TwoWayHandler twoWayHandler) {
        return TreeEditorHelper.createTreeMetadataEditor(tree, node, item, rowType, context, transformModel, twoWayHandler, null, null);
    }

    public static Composite createTreeMetadataEditor(Tree tree, GraphicalTreeNode<?> node, TreeItem item, MessageRowType rowType, EditorContext context, IMappingModel transformModel, TwoWayHandler twoWayHandler, InputContextMenuProvider inputContextMenuProvider, TreeViewer viewer) {
        CustomTreeEditor editor = new CustomTreeEditor(tree);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        Composite composite = new Composite((Composite)tree, 0);
        composite.setBackground(DFLEditor.WHITE);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        Link link = new Link(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(1, 0x1000000).applyTo((Control)link);
        link.setBackground(DFLEditor.WHITE);
        link.setFont(item.getFont());
        link.setText(item.getText() + " <a>Define metadata</a>");
        link.setEnabled(true);
        link.addSelectionListener((SelectionListener)new MetadataLinkListener(twoWayHandler, transformModel, rowType, node, inputContextMenuProvider));
        editor.setEditor((Control)composite, item);
        if (inputContextMenuProvider != null) {
            inputContextMenuProvider.provideContextMenuForLink((Control)composite, (ISelectionProvider)viewer, item, node);
            inputContextMenuProvider.provideContextMenuForLink((Control)link, (ISelectionProvider)viewer, item, node);
        }
        return composite;
    }

    private static final class MetadataLinkListener
    extends SelectionAdapter {
        private final MessageRowType rowType;
        private final GraphicalTreeNode<?> node;
        private final TwoWayHandler twoWayHandler;
        private IMappingModel transformModel;

        private MetadataLinkListener(TwoWayHandler twoWayHandler, IMappingModel transformModel, MessageRowType rowType, GraphicalTreeNode<?> node, InputContextMenuProvider inputContextMenuProvider) {
            this.transformModel = transformModel;
            this.node = node;
            this.rowType = rowType;
            this.twoWayHandler = twoWayHandler;
        }

        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            this.configureMetadata();
        }

        private void configureMetadata() {
            Optional<MetadataResult> result;
            IMuleProject project = MuleCorePlugin.getDesignContext().getMuleProject();
            MetadataDefinitionWizard wizard = new MetadataDefinitionWizard(project);
            Shell activeShell = Display.getCurrent().getActiveShell();
            MetadataDefinitionWizardDialog dialog = new MetadataDefinitionWizardDialog(activeShell, wizard);
            if (dialog.open() == 0 && (result = Optional.ofNullable(wizard.getResult())).isPresent()) {
                MetadataResult metadataResult = result.get();
                if (this.rowType.isOutput()) {
                    Optional<String> propertyName = MetadataOperations.propertyName(this.twoWayHandler, this.rowType, this.node);
                    this.transformModel.setOuputMetadata(this.rowType, propertyName, metadataResult, this.twoWayHandler.getPropagationProvider());
                } else {
                    UpdateMetadataOperation updateOperation = new UpdateMetadataOperation(this.twoWayHandler, metadataResult, this.rowType, this.node);
                    updateOperation.update();
                }
            }
        }
    }
}

