/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.datasense;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.TreeViewer;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.ToolingPropagationInfo;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.datasense.IDataSenseProvider;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.dfl.ui.ls.DataWeaveLanguageService;
import org.mule.tooling.dfl.ui.utils.WeaveGraphicalTreeNode;
import org.mule.tooling.ui.dfl.contribution.editor.datasense.DFLMetadataPropertyGraphicalChildrenProvider;
import org.mule.tooling.ui.dfl.contribution.editor.datasense.DFLRootInputDirectiveChildrenProvider;
import org.mule.tooling.ui.dfl.contribution.editor.datasense.DFLRootOutputChildrenProvider;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.TwoWayHandler;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.OutputTreeLiveDataProvider;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.ITransformationTarget;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.ITransformationTargetSource;
import org.mule.tooling.ui.modules.core.metadata.IPropagationInfoProvider;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageRowType;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.tree.model.IGraphicalChildrenProvider;
import org.mule.weave.v2.editor.ValidationMessages;

public class MetadataOperations {
    private static final IGraphicalChildrenProvider<String> DISABLED_CHILDREN_PROVIDER = new DisabledChildrenProvider();
    private static final GraphicalTreeNode<String> INPUT_DISABLED_NODE = new GraphicalTreeNode("root", "Input Data", null, DISABLED_CHILDREN_PROVIDER);
    private static final GraphicalTreeNode<String> OUTPUT_DISABLED_NODE = new GraphicalTreeNode("Output", "Expected Output", null, DISABLED_CHILDREN_PROVIDER);

    public static void reloadPropagation(TwoWayHandler twoWayHandler) {
        twoWayHandler.getPropagationProvider().reloadPropagation();
    }

    public static void refreshMetadataTrees(TwoWayHandler twoWayHandler) {
        MetadataOperations.refreshInputTree(twoWayHandler);
        MetadataOperations.refreshOutputTree(twoWayHandler);
        MetadataOperations.refreshTwoWayHandler(twoWayHandler);
    }

    public static void onPropagationStarted(TwoWayHandler twoWayHandler) {
        TreeViewer inputTreeViewer = twoWayHandler.getMappingPainter().getLeftViewer();
        TreeViewer outputTreeViewer = twoWayHandler.getMappingPainter().getRightViewer();
        inputTreeViewer.setInput(INPUT_DISABLED_NODE);
        outputTreeViewer.setInput(OUTPUT_DISABLED_NODE);
        twoWayHandler.showInvalidIndicator();
    }

    public static Optional<String> propertyName(TwoWayHandler twoWayHandler, MessageRowType rowType, GraphicalTreeNode<?> graphicalTreeNode) {
        Optional<String> propertyName = Optional.ofNullable(graphicalTreeNode.getId());
        if (MessageRowType.OUTPUT_VARIABLES.equals((Object)rowType)) {
            propertyName = Optional.of(twoWayHandler.getCurrentTarget().getVariableName());
        }
        return propertyName;
    }

    public static void reloadPropagationAndEditorMarkers(TwoWayHandler twoWayHandler) {
        MetadataOperations.reloadPropagation(twoWayHandler);
        MetadataOperations.refreshMetadataTrees(twoWayHandler);
        twoWayHandler.deselect();
        twoWayHandler.applyFormatter();
    }

    private static void refreshInputTree(TwoWayHandler twoWayHandler) {
        IMetaDataProvider inputMetadataProvider = twoWayHandler.getInputMetadataProvider();
        DFLRootInputDirectiveChildrenProvider inputChildrenProvider = new DFLRootInputDirectiveChildrenProvider(twoWayHandler.getEditorContext().getInputLiveDataProvider());
        WeaveGraphicalTreeNode inputRootNode = new WeaveGraphicalTreeNode("root", "Input Data", (Object)inputMetadataProvider, (IGraphicalChildrenProvider)inputChildrenProvider);
        TreeViewer leftViewer = twoWayHandler.getMappingPainter().getLeftViewer();
        try {
            leftViewer.getControl().setRedraw(false);
            leftViewer.refresh(true);
            leftViewer.setInput((Object)inputRootNode);
            leftViewer.expandToLevel(3);
        }
        finally {
            leftViewer.getControl().setRedraw(true);
        }
    }

    private static void refreshOutputTree(TwoWayHandler twoWayHandler) {
        Object outputChildrenProvider;
        MetadataType metadataType;
        ITransformationTarget currentTarget = twoWayHandler.getCurrentTarget();
        OutputTreeLiveDataProvider outputTreeLiveDataProviderManager = new OutputTreeLiveDataProvider(twoWayHandler.getEditorContext().getEventBus());
        if (currentTarget.isPayload()) {
            metadataType = twoWayHandler.getOutputMetadataProvider(MessageRowType.OUTPUT_PAYLOAD).getMetadata().getPayload();
            outputChildrenProvider = new DFLRootOutputChildrenProvider(metadataType, outputTreeLiveDataProviderManager);
        } else if (currentTarget.isAttributes()) {
            metadataType = twoWayHandler.getOutputMetadataProvider(MessageRowType.OUTPUT_ATTRIBUTES).getMetadata().getAttributes();
            outputChildrenProvider = new DFLRootOutputChildrenProvider(metadataType, outputTreeLiveDataProviderManager);
        } else {
            metadataType = twoWayHandler.getOutputMetadataProvider(MessageRowType.OUTPUT_VARIABLES).getMetadata().getVariables();
            outputChildrenProvider = new DFLMetadataPropertyGraphicalChildrenProvider(currentTarget.getVariableName(), outputTreeLiveDataProviderManager);
        }
        WeaveGraphicalTreeNode outputRootNode = new WeaveGraphicalTreeNode("Output", "Expected Output", (Object)metadataType, (IGraphicalChildrenProvider)outputChildrenProvider);
        TreeViewer outputTreeViewer = twoWayHandler.getMappingPainter().getRightViewer();
        try {
            outputTreeViewer.getControl().setRedraw(false);
            outputTreeViewer.refresh(true);
            outputTreeViewer.setInput((Object)outputRootNode);
            outputTreeViewer.expandToLevel(3);
        }
        finally {
            outputTreeViewer.getControl().setRedraw(true);
        }
    }

    private static void refreshTwoWayHandler(TwoWayHandler twoWayHandler) {
        twoWayHandler.checkMetadata();
        ITransformationTargetSource source = twoWayHandler.getCurrentTarget().getSource();
        String content = source.getSourceContent();
        IMuleProject project = twoWayHandler.getProject();
        ValidationMessages messages = DataWeaveLanguageService.getInstance((IMuleProject)project).validateScript((IDocument)new Document(content), (IDataSenseProvider)IDataSenseProvider.create((PropagationInfo)ToolingPropagationInfo.PropagationInfoBuilder.DEFAULT), true);
        if (messages.errorMessage().length == 0) {
            twoWayHandler.refreshGraphicalView();
        } else {
            twoWayHandler.showInvalidIndicator();
        }
    }

    private static final class DisabledChildrenProvider
    implements IGraphicalChildrenProvider<String> {
        private DisabledChildrenProvider() {
        }

        public List<GraphicalTreeNode<?>> getChildren(GraphicalTreeNode<String> parent) {
            return Arrays.asList(new GraphicalTreeNode("Loading metadata...", "Metadata for this editor is loading, please wait until the propagation finishes. Script editor is available.", (Object)"Loading metadata", null).id(IPropagationInfoProvider.getUnresolvedMetadataNodeId()));
        }
    }
}

