/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.datasense;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.dfl.ui.graphical.livedata.EmptyTreeLiveDataProvider;
import org.mule.tooling.dfl.ui.graphical.livedata.ITreeLiveDataProvider;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.dfl.ui.output.JavaRecursionField;
import org.mule.tooling.dfl.ui.output.MetaDataModelSafeRecursionChildrenProvider;
import org.mule.tooling.dfl.ui.output.SafeRecursion;
import org.mule.tooling.dfl.ui.output.SafeRecursionField;
import org.mule.tooling.dfl.ui.output.SafeRecursionImpl;
import org.mule.tooling.dfl.ui.utils.DwMetadataUtils;
import org.mule.tooling.dfl.ui.utils.WeaveGraphicalTreeNode;
import org.mule.tooling.metadata.sample.IMetadataEventSelector;
import org.mule.tooling.ui.dfl.contribution.editor.datasense.DFLMetadataPropertiesGraphicalChildrenProvider;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.InputTreeLiveDataProviderManager;
import org.mule.tooling.ui.modules.core.metadata.MetadataTypeHelper;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.tree.model.IGraphicalChildrenProvider;

public class DFLRootInputDirectiveChildrenProvider
implements IGraphicalChildrenProvider<IMetaDataProvider> {
    private InputTreeLiveDataProviderManager inputLiveDataProvider;

    public DFLRootInputDirectiveChildrenProvider(InputTreeLiveDataProviderManager inputLiveDataProvider) {
        this.inputLiveDataProvider = inputLiveDataProvider;
    }

    public List<GraphicalTreeNode<?>> getChildren(GraphicalTreeNode<IMetaDataProvider> parent) {
        MetadataEvent metadata = ((IMetaDataProvider)parent.getModel()).getMetadata();
        MetadataType payloadModel = metadata.getMessage().getPayload();
        String payloadLabel = "Payload : " + MetadataTypeHelper.getTypeLabel((MetadataType)payloadModel);
        SafeRecursionImpl safeRecursion = new SafeRecursionImpl();
        if (DwMetadataUtils.isPojo((MetadataType)payloadModel)) {
            Optional maybeAnnotation = payloadModel.getAnnotation(TypeIdAnnotation.class);
            maybeAnnotation.ifPresent(arg_0 -> DFLRootInputDirectiveChildrenProvider.lambda$0((SafeRecursion)safeRecursion, arg_0));
        }
        MetaDataModelSafeRecursionChildrenProvider payloadSafeRecursive = new MetaDataModelSafeRecursionChildrenProvider((SafeRecursion)safeRecursion, this.getTreeLiveDataProvider(IMetadataEventSelector.payload()));
        GraphicalTreeNode payload = new WeaveGraphicalTreeNode(payloadLabel, "The most important part of the Mule message because it contains the data your Mule application processes.", (Object)payloadModel, (IGraphicalChildrenProvider)payloadSafeRecursive).id("payload");
        DFLMetadataPropertiesGraphicalChildrenProvider propertiesChildFactory = new DFLMetadataPropertiesGraphicalChildrenProvider(this.inputLiveDataProvider);
        GraphicalTreeNode variables = new WeaveGraphicalTreeNode("Variables", "Variables\u00a0available to this component", (Object)metadata.getVariables(), (IGraphicalChildrenProvider)propertiesChildFactory).id("vars");
        GraphicalTreeNode attributes = this.createAttributesGraphicalTreeNode(metadata).id("attributes");
        return Arrays.asList(payload, variables, attributes);
    }

    private ITreeLiveDataProvider getTreeLiveDataProvider(IMetadataEventSelector selector) {
        if (this.inputLiveDataProvider == null) {
            return new EmptyTreeLiveDataProvider();
        }
        return this.inputLiveDataProvider.getLiveDataProvider(selector);
    }

    protected GraphicalTreeNode<MetadataType> createAttributesGraphicalTreeNode(MetadataEvent metadata) {
        MetadataType attributes = metadata.getMessage().getAttributes();
        String attributesLabel = "Attributes : " + MetadataTypeHelper.getTypeLabel((MetadataType)attributes);
        SafeRecursionImpl safeRecursion = new SafeRecursionImpl();
        if (DwMetadataUtils.isPojo((MetadataType)attributes)) {
            Optional maybeAnnotation = attributes.getAnnotation(TypeIdAnnotation.class);
            maybeAnnotation.ifPresent(arg_0 -> DFLRootInputDirectiveChildrenProvider.lambda$1((SafeRecursion)safeRecursion, arg_0));
        }
        return new WeaveGraphicalTreeNode(attributesLabel, "Are immutable, are automatically generated by the message source and cannot be set or manipulated by the user.", (Object)attributes, (IGraphicalChildrenProvider)new MetaDataModelSafeRecursionChildrenProvider((SafeRecursion)safeRecursion, this.getTreeLiveDataProvider(IMetadataEventSelector.attribute())));
    }

    private static /* synthetic */ void lambda$0(SafeRecursion safeRecursion, TypeIdAnnotation annotation) {
        safeRecursion.push((SafeRecursionField)new JavaRecursionField(annotation.getValue()));
    }

    private static /* synthetic */ void lambda$1(SafeRecursion safeRecursion, TypeIdAnnotation annotation) {
        safeRecursion.push((SafeRecursionField)new JavaRecursionField(annotation.getValue()));
    }
}

